// Copyright (C) 2016 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial

#ifndef GILSTATE_H
#define GILSTATE_H

#include <shibokenmacros.h>
#include "sbkpython.h"

namespace Shiboken
{

class LIBSHIBOKEN_API GilState
{
public:
    GilState(const GilState &) = delete;
    GilState(GilState &&) = delete;
    GilState &operator=(const GilState &) = delete;
    GilState &operator=(GilState &&) = delete;

    GilState();
    ~GilState();
    void release();
    void abandon();
private:
    PyGILState_STATE m_gstate;
    bool m_locked = false;
};

} // namespace Shiboken

#endif // GILSTATE_H

