/****************************************************************************
**
** Copyright (C) 2013 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the QtCore module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Digia.  For licensing terms and
** conditions see http://qt.digia.com/licensing.  For further information
** use the contact form at http://qt.digia.com/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Digia gives you certain additional
** rights.  These rights are described in the Digia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
**
** $QT_END_LICENSE$
**
****************************************************************************/


#ifndef QEVENTDISPATCHER_WINRT_P_H
#define QEVENTDISPATCHER_WINRT_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include "QtCore/qabstracteventdispatcher.h"
#include "private/qabstracteventdispatcher_p.h"

#include <qt_windows.h>
#include <wrl.h>

namespace ABI {
    namespace Windows {
        namespace System {
            namespace Threading {
                struct IThreadPoolTimer;
                struct IThreadPoolTimerStatics;
            }
        }
    }
}

QT_BEGIN_NAMESPACE

int qt_msectime();

class QEventDispatcherWinRTPrivate;

class Q_CORE_EXPORT QEventDispatcherWinRT : public QAbstractEventDispatcher
{
    Q_OBJECT
    Q_DECLARE_PRIVATE(QEventDispatcherWinRT)

public:
    explicit QEventDispatcherWinRT(QObject *parent = 0);
    ~QEventDispatcherWinRT();

    bool processEvents(QEventLoop::ProcessEventsFlags flags);
    bool hasPendingEvents();

    void registerSocketNotifier(QSocketNotifier *notifier);
    void unregisterSocketNotifier(QSocketNotifier *notifier);

    void registerTimer(int timerId, int interval, Qt::TimerType timerType, QObject *object);
    bool unregisterTimer(int timerId);
    bool unregisterTimers(QObject *object);
    QList<TimerInfo> registeredTimers(QObject *object) const;

    int remainingTime(int timerId);

    bool registerEventNotifier(QWinEventNotifier *notifier);
    void unregisterEventNotifier(QWinEventNotifier *notifier);

    void wakeUp();
    void interrupt();
    void flush();

    void startingUp();
    void closingDown();

protected:
    QEventDispatcherWinRT(QEventDispatcherWinRTPrivate &dd, QObject *parent = 0);


    bool event(QEvent *);
    int activateTimers();
};

struct WinRTTimerInfo                           // internal timer info
{
    WinRTTimerInfo() : timer(0) {}

    QObject *dispatcher;
    int timerId;
    int interval;
    Qt::TimerType timerType;
    quint64 timeout;                            // - when to actually fire
    QObject *obj;                               // - object to receive events
    bool inTimerEvent;
    ABI::Windows::System::Threading::IThreadPoolTimer *timer;
};

class QZeroTimerEvent : public QTimerEvent
{
public:
    explicit inline QZeroTimerEvent(int timerId)
        : QTimerEvent(timerId)
    { t = QEvent::ZeroTimerEvent; }
};

class Q_CORE_EXPORT QEventDispatcherWinRTPrivate : public QAbstractEventDispatcherPrivate
{
    Q_DECLARE_PUBLIC(QEventDispatcherWinRT)

public:
    QEventDispatcherWinRTPrivate();
    ~QEventDispatcherWinRTPrivate();

    QList<WinRTTimerInfo*> timerVec;
    QHash<int, WinRTTimerInfo*> timerDict;
    QHash<ABI::Windows::System::Threading::IThreadPoolTimer*, WinRTTimerInfo*> threadPoolTimerDict;

    void registerTimer(WinRTTimerInfo *t);
    void unregisterTimer(WinRTTimerInfo *t);
    void sendTimerEvent(int timerId);
    HRESULT timerExpiredCallback(ABI::Windows::System::Threading::IThreadPoolTimer *source);

    QAtomicInt wakeUps;
    bool interrupt;

    ABI::Windows::System::Threading::IThreadPoolTimerStatics *timerFactory;
};

QT_END_NAMESPACE

#endif // QEVENTDISPATCHER_WINRT_P_H
