.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER CONVERSION" "" "2008-06-08" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER CONVERSION \- change the definition of a conversion

.SH SYNOPSIS
.sp
.nf
ALTER CONVERSION \fIname\fR RENAME TO \fInewname\fR
ALTER CONVERSION \fIname\fR OWNER TO \fInewowner\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER CONVERSION\fR changes the definition of a
conversion.
.PP
You must own the conversion to use \fBALTER CONVERSION\fR.
To alter the owner, you must also be a direct or indirect member of the new
owning role, and that role must have CREATE privilege on
the conversion's schema. (These restrictions enforce that altering the
owner doesn't do anything you couldn't do by dropping and recreating the
conversion. However, a superuser can alter ownership of any conversion
anyway.)
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing conversion.
.TP
\fB\fInewname\fB\fR
The new name of the conversion.
.TP
\fB\fInewowner\fB\fR
The new owner of the conversion.
.SH "EXAMPLES"
.PP
To rename the conversion iso_8859_1_to_utf8 to
latin1_to_unicode:
.sp
.nf
ALTER CONVERSION iso_8859_1_to_utf8 RENAME TO latin1_to_unicode;
.sp
.fi
.PP
To change the owner of the conversion iso_8859_1_to_utf8 to
joe:
.sp
.nf
ALTER CONVERSION iso_8859_1_to_utf8 OWNER TO joe;
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBALTER CONVERSION\fR statement in the SQL
standard.
.SH "SEE ALSO"
CREATE CONVERSION [\fBcreate_conversion\fR(l)], DROP CONVERSION [\fBdrop_conversion\fR(l)]
