.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "INSERT" "" "2010-05-14" "SQL - Language Statements" "SQL Commands"
.SH NAME
INSERT \- create new rows in a table

.SH SYNOPSIS
.sp
.nf
INSERT INTO \fItable\fR [ ( \fIcolumn\fR [, ...] ) ]
    { DEFAULT VALUES | VALUES ( { \fIexpression\fR | DEFAULT } [, ...] ) [, ...] | \fIquery\fR }
    [ RETURNING * | \fIoutput_expression\fR [ AS \fIoutput_name\fR ] [, ...] ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBINSERT\fR inserts new rows into a table.
One can insert one or more rows specified by value expressions,
or zero or more rows resulting from a query.
.PP
The target column names may be listed in any order. If no list of
column names is given at all, the default is all the columns of the
table in their declared order; or the first \fIN\fR column
names, if there are only \fIN\fR columns supplied by the
VALUES clause or \fIquery\fR. The values
supplied by the VALUES clause or \fIquery\fR are
associated with the explicit or implicit column list left-to-right.
.PP
Each column not present in the explicit or implicit column list will be
filled with a default value, either its declared default value
or null if there is none.
.PP
If the expression for any column is not of the correct data type,
automatic type conversion will be attempted.
.PP
The optional RETURNING clause causes \fBINSERT\fR
to compute and return value(s) based on each row actually inserted.
This is primarily useful for obtaining values that were supplied by
defaults, such as a serial sequence number. However, any expression
using the table's columns is allowed. The syntax of the
RETURNING list is identical to that of the output list
of \fBSELECT\fR.
.PP
You must have INSERT privilege on a table in
order to insert into it, and SELECT privilege on it to
use RETURNING. If you use the \fIquery\fR clause to insert rows from a
query, you also need to have SELECT privilege on
any table used in the query.
.SH "PARAMETERS"
.TP
\fB\fItable\fB\fR
The name (optionally schema-qualified) of an existing table.
.TP
\fB\fIcolumn\fB\fR
The name of a column in \fItable\fR.
The column name can be qualified with a subfield name or array
subscript, if needed. (Inserting into only some fields of a
composite column leaves the other fields null.)
.TP
\fBDEFAULT VALUES\fR
All columns will be filled with their default values.
.TP
\fB\fIexpression\fB\fR
An expression or value to assign to the corresponding \fIcolumn\fR.
.TP
\fBDEFAULT\fR
The corresponding \fIcolumn\fR will be filled with
its default value.
.TP
\fB\fIquery\fB\fR
A query (\fBSELECT\fR statement) that supplies the
rows to be inserted. Refer to the
SELECT [\fBselect\fR(l)]
statement for a description of the syntax.
.TP
\fB\fIoutput_expression\fB\fR
An expression to be computed and returned by the \fBINSERT\fR
command after each row is inserted. The expression may use any
column names of the \fItable\fR.
Write * to return all columns of the inserted row(s).
.TP
\fB\fIoutput_name\fB\fR
A name to use for a returned column.
.SH "OUTPUTS"
.PP
On successful completion, an \fBINSERT\fR command returns a command
tag of the form
.sp
.nf
INSERT \fIoid\fR \fIcount\fR
.sp
.fi
The \fIcount\fR is the number
of rows inserted. If \fIcount\fR
is exactly one, and the target table has OIDs, then
\fIoid\fR is the
OID assigned to the inserted row. Otherwise
\fIoid\fR is zero.
.PP
If the \fBINSERT\fR command contains a RETURNING
clause, the result will be similar to that of a \fBSELECT\fR
statement containing the columns and values defined in the
RETURNING list, computed over the row(s) inserted by the
command.
.SH "EXAMPLES"
.PP
Insert a single row into table films:
.sp
.nf
INSERT INTO films VALUES
    ('UA502', 'Bananas', 105, '1971-07-13', 'Comedy', '82 minutes');
.sp
.fi
.PP
In this example, the len column is
omitted and therefore it will have the default value:
.sp
.nf
INSERT INTO films (code, title, did, date_prod, kind)
    VALUES ('T_601', 'Yojimbo', 106, '1961-06-16', 'Drama');
.sp
.fi
.PP
This example uses the DEFAULT clause for
the date columns rather than specifying a value:
.sp
.nf
INSERT INTO films VALUES
    ('UA502', 'Bananas', 105, DEFAULT, 'Comedy', '82 minutes');
INSERT INTO films (code, title, did, date_prod, kind)
    VALUES ('T_601', 'Yojimbo', 106, DEFAULT, 'Drama');
.sp
.fi
.PP
To insert a row consisting entirely of default values:
.sp
.nf
INSERT INTO films DEFAULT VALUES;
.sp
.fi
.PP
To insert multiple rows using the multirow \fBVALUES\fR syntax:
.sp
.nf
INSERT INTO films (code, title, did, date_prod, kind) VALUES
    ('B6717', 'Tampopo', 110, '1985-02-10', 'Comedy'),
    ('HG120', 'The Dinner Game', 140, DEFAULT, 'Comedy');
.sp
.fi
.PP
This example inserts some rows into table
films from a table tmp_films
with the same column layout as films:
.sp
.nf
INSERT INTO films SELECT * FROM tmp_films WHERE date_prod < '2004-05-07';
.sp
.fi
.PP
This example inserts into array columns:
.sp
.nf
-- Create an empty 3x3 gameboard for noughts-and-crosses
INSERT INTO tictactoe (game, board[1:3][1:3])
    VALUES (1, '{{" "," "," "},{" "," "," "},{" "," "," "}}');
-- The subscripts in the above example aren't really needed
INSERT INTO tictactoe (game, board)
    VALUES (2, '{{X," "," "},{" ",O," "},{" ",X," "}}');
.sp
.fi
.PP
Insert a single row into table distributors, returning
the sequence number generated by the DEFAULT clause:
.sp
.nf
INSERT INTO distributors (did, dname) VALUES (DEFAULT, 'XYZ Widgets')
   RETURNING did;
.sp
.fi
.SH "COMPATIBILITY"
.PP
\fBINSERT\fR conforms to the SQL standard, except that
the RETURNING clause is a
PostgreSQL extension. Also, the case in
which a column name list is omitted, but not all the columns are
filled from the VALUES clause or \fIquery\fR,
is disallowed by the standard.
.PP
Possible limitations of the \fIquery\fR clause are documented under
SELECT [\fBselect\fR(l)].
