//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/gfx/PCanvasManagerParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/gfx/CanvasManagerParent.h"
#include "mozilla/layers/LayersMessageUtils.h"

#include "mozilla/layers/PCanvasParent.h"
#include "mozilla/dom/PWebGLParent.h"
#include "mozilla/webgpu/PWebGPUParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace gfx {


auto PCanvasManagerParent::RecvPCanvasConstructor(PCanvasParent* actor) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PCanvasManagerParent::RecvPWebGLConstructor(PWebGLParent* actor) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PCanvasManagerParent::RecvPWebGPUConstructor(PWebGPUParent* actor) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PCanvasManagerParent::ProcessingError(
        Result aCode,
        const char* aReason) -> void
{
}

auto PCanvasManagerParent::ShouldContinueFromReplyTimeout() -> bool
{
    return true;
}

MOZ_IMPLICIT PCanvasManagerParent::PCanvasManagerParent() :
    mozilla::ipc::IToplevelProtocol("PCanvasManagerParent", kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PCanvasManagerParent);
}

PCanvasManagerParent::~PCanvasManagerParent()
{
    MOZ_COUNT_DTOR(PCanvasManagerParent);
}

auto PCanvasManagerParent::ActorAlloc() -> void
{
    MOZ_RELEASE_ASSERT(XRE_IsParentProcess() || XRE_IsGPUProcess(), "Invalid process for `PCanvasManagerParent'");
    AddRef();
}

auto PCanvasManagerParent::ActorDealloc() -> void
{
    Release();
}

auto PCanvasManagerParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PCanvasManagerParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PCanvasManagerParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PCanvasManagerParent::ManagedPCanvasParent(nsTArray<PCanvasParent*>& aArr) const -> void
{
    mManagedPCanvasParent.ToArray(aArr);
}

auto PCanvasManagerParent::ManagedPCanvasParent() const -> const ManagedContainer<PCanvasParent>&
{
    return mManagedPCanvasParent;
}

auto PCanvasManagerParent::ManagedPWebGLParent(nsTArray<PWebGLParent*>& aArr) const -> void
{
    mManagedPWebGLParent.ToArray(aArr);
}

auto PCanvasManagerParent::ManagedPWebGLParent() const -> const ManagedContainer<PWebGLParent>&
{
    return mManagedPWebGLParent;
}

auto PCanvasManagerParent::ManagedPWebGPUParent(nsTArray<PWebGPUParent*>& aArr) const -> void
{
    mManagedPWebGPUParent.ToArray(aArr);
}

auto PCanvasManagerParent::ManagedPWebGPUParent() const -> const ManagedContainer<PWebGPUParent>&
{
    return mManagedPWebGPUParent;
}

auto PCanvasManagerParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PCanvasMsgStart,
        PWebGLMsgStart,
        PWebGPUMsgStart
    };
    return sIds;
}

auto PCanvasManagerParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PCanvasMsgStart:
        return (&(mManagedPCanvasParent));
    case PWebGLMsgStart:
        return (&(mManagedPWebGLParent));
    case PWebGPUMsgStart:
        return (&(mManagedPWebGPUParent));
    default:
        return nullptr;
    }
}

auto PCanvasManagerParent::OpenPCanvasEndpoint(PCanvasParent* aActor) -> ManagedEndpoint<PCanvasChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PCanvasParent actor");
        return ManagedEndpoint<PCanvasChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PCanvasParent actor");
        return ManagedEndpoint<PCanvasChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PCanvasChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PCanvasManagerParent::BindPCanvasEndpoint(
        ManagedEndpoint<PCanvasParent> aEndpoint,
        PCanvasParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PCanvasManagerParent::OpenPWebGLEndpoint(PWebGLParent* aActor) -> ManagedEndpoint<PWebGLChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PWebGLParent actor");
        return ManagedEndpoint<PWebGLChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PWebGLParent actor");
        return ManagedEndpoint<PWebGLChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PWebGLChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PCanvasManagerParent::BindPWebGLEndpoint(
        ManagedEndpoint<PWebGLParent> aEndpoint,
        PWebGLParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PCanvasManagerParent::OpenPWebGPUEndpoint(PWebGPUParent* aActor) -> ManagedEndpoint<PWebGPUChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PWebGPUParent actor");
        return ManagedEndpoint<PWebGPUChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PWebGPUParent actor");
        return ManagedEndpoint<PWebGPUChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PWebGPUChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PCanvasManagerParent::BindPWebGPUEndpoint(
        ManagedEndpoint<PWebGPUParent> aEndpoint,
        PWebGPUParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PCanvasManagerParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    default:
        FatalError("unreached");
        return;
    }
}

auto PCanvasManagerParent::OnMessageReceived(const Message& msg__) -> PCanvasManagerParent::Result
{
    IPC::Message::routeid_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            if (mozilla::ipc::LoggingEnabledFor("PCanvasManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Ignored message for dead actor",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__);
    }

    switch (msg__.type()) {
    case PCanvasManager::Msg_PCanvasConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCanvasManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCanvasManager::Msg_PCanvasConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PCanvasParent> actor = (static_cast<CanvasManagerParent*>(this))->AllocPCanvasParent();
            if (!actor) {
                NS_WARNING("Cannot bind null PCanvasParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PCanvasParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<CanvasManagerParent*>(this))->RecvPCanvasConstructor(actor);
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCanvasManager::Msg_PWebGLConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCanvasManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCanvasManager::Msg_PWebGLConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PWebGLParent> actor = (static_cast<CanvasManagerParent*>(this))->AllocPWebGLParent();
            if (!actor) {
                NS_WARNING("Cannot bind null PWebGLParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PWebGLParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<CanvasManagerParent*>(this))->RecvPWebGLConstructor(actor);
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCanvasManager::Msg_PWebGPUConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCanvasManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCanvasManager::Msg_PWebGPUConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PWebGPUParent> actor = (static_cast<CanvasManagerParent*>(this))->AllocPWebGPUParent();
            if (!actor) {
                NS_WARNING("Cannot bind null PWebGPUParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PWebGPUParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<CanvasManagerParent*>(this))->RecvPWebGPUConstructor(actor);
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCanvasManager::Msg_Initialize__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCanvasManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCanvasManager::Msg_Initialize", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aManagerId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aManagerId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aManagerId = *maybe__aManagerId;
            // Sentinel = 'aManagerId'
            if ((!(((&(reader__)))->ReadSentinel(347866058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CanvasManagerParent*>(this))->RecvInitialize(std::move(aManagerId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    case SHMEM_CREATED_MESSAGE_TYPE:
        {
            if (!ShmemCreated(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    case SHMEM_DESTROYED_MESSAGE_TYPE:
        {
            if (!ShmemDestroyed(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    }
}

auto PCanvasManagerParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PCanvasManagerParent::Result
{
    IPC::Message::routeid_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            return MsgDropped;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__, reply__);
    }

    switch (msg__.type()) {
    case PCanvasManager::Msg_GetSnapshot__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCanvasManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCanvasManager::Msg_GetSnapshot", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aManagerId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aManagerId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aManagerId = *maybe__aManagerId;
            // Sentinel = 'aManagerId'
            if ((!(((&(reader__)))->ReadSentinel(347866058)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aProtocolId = IPC::ReadParam<ActorId>((&(reader__)));
            if (!maybe__aProtocolId) {
                FatalError("Error deserializing 'ActorId'");
                return MsgValueError;

            }
            auto& aProtocolId = *maybe__aProtocolId;
            // Sentinel = 'aProtocolId'
            if ((!(((&(reader__)))->ReadSentinel(444269665)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ActorId'");
                return MsgValueError;
            }
            auto maybe__ownerId = IPC::ReadParam<mozilla::Maybe<RemoteTextureOwnerId>>((&(reader__)));
            if (!maybe__ownerId) {
                FatalError("Error deserializing 'RemoteTextureOwnerId?'");
                return MsgValueError;

            }
            auto& ownerId = *maybe__ownerId;
            // Sentinel = 'ownerId'
            if ((!(((&(reader__)))->ReadSentinel(199230169)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RemoteTextureOwnerId?'");
                return MsgValueError;
            }
            auto maybe__commandEncoderId = IPC::ReadParam<mozilla::Maybe<RawId>>((&(reader__)));
            if (!maybe__commandEncoderId) {
                FatalError("Error deserializing 'RawId?'");
                return MsgValueError;

            }
            auto& commandEncoderId = *maybe__commandEncoderId;
            // Sentinel = 'commandEncoderId'
            if ((!(((&(reader__)))->ReadSentinel(913180237)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId?'");
                return MsgValueError;
            }
            auto maybe__commandBufferId = IPC::ReadParam<mozilla::Maybe<RawId>>((&(reader__)));
            if (!maybe__commandBufferId) {
                FatalError("Error deserializing 'RawId?'");
                return MsgValueError;

            }
            auto& commandBufferId = *maybe__commandBufferId;
            // Sentinel = 'commandBufferId'
            if ((!(((&(reader__)))->ReadSentinel(806553063)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId?'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = MSG_ROUTING_CONTROL;
            FrontBufferSnapshotIpc ret{};
            mozilla::ipc::IPCResult __ok = (static_cast<CanvasManagerParent*>(this))->RecvGetSnapshot(std::move(aManagerId), std::move(aProtocolId), std::move(ownerId), std::move(commandEncoderId), std::move(commandBufferId), (&(ret)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PCanvasManager::Reply_GetSnapshot(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), ret);
            // Sentinel = 'ret'
            ((&(writer__)))->WriteSentinel(43450700);
            if (mozilla::ipc::LoggingEnabledFor("PCanvasManager", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasManagerParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}



} // namespace gfx
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::gfx::PCanvasManagerParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PCanvasManager'
    (aWriter)->WriteSentinel(657720680);
}

auto ParamTraits<::mozilla::gfx::PCanvasManagerParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PCanvasManager actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PCanvasManager'
    if ((!((aReader)->ReadSentinel(657720680)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PCanvasManager actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PCanvasManagerMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PCanvasManager)");

        return {};
    }
    return static_cast<::mozilla::gfx::PCanvasManagerParent*>(actor);
}

} // namespace IPC
