/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM GamepadEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "GamepadEvent.h"
#include "GamepadEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Gamepad.h"
#include "mozilla/dom/GamepadEvent.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(GamepadEvent)

NS_IMPL_ADDREF_INHERITED(GamepadEvent, Event)
NS_IMPL_RELEASE_INHERITED(GamepadEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(GamepadEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mGamepad)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(GamepadEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(GamepadEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mGamepad)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(GamepadEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

GamepadEvent::GamepadEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

GamepadEvent::~GamepadEvent()
{
}

GamepadEvent*
GamepadEvent::AsGamepadEvent()
{
  return this;
}

JSObject*
GamepadEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return GamepadEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<GamepadEvent>
GamepadEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const GamepadEventInit& aEventInitDict)
{
  RefPtr<GamepadEvent> e = new GamepadEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mGamepad = aEventInitDict.mGamepad;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<GamepadEvent>
GamepadEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const GamepadEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

Gamepad*
GamepadEvent::GetGamepad() const
{
  return mGamepad;
}


} // namespace mozilla::dom
