﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/CoipCidr.h>
#include <aws/ec2/model/ResponseMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {
class DeleteCoipCidrResponse {
 public:
  AWS_EC2_API DeleteCoipCidrResponse() = default;
  AWS_EC2_API DeleteCoipCidrResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_EC2_API DeleteCoipCidrResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p> Information about a range of customer-owned IP addresses. </p>
   */
  inline const CoipCidr& GetCoipCidr() const { return m_coipCidr; }
  template <typename CoipCidrT = CoipCidr>
  void SetCoipCidr(CoipCidrT&& value) {
    m_coipCidrHasBeenSet = true;
    m_coipCidr = std::forward<CoipCidrT>(value);
  }
  template <typename CoipCidrT = CoipCidr>
  DeleteCoipCidrResponse& WithCoipCidr(CoipCidrT&& value) {
    SetCoipCidr(std::forward<CoipCidrT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DeleteCoipCidrResponse& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  CoipCidr m_coipCidr;

  ResponseMetadata m_responseMetadata;
  bool m_coipCidrHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
