﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cleanroomsml/CleanRoomsML_EXPORTS.h>
#include <aws/cleanroomsml/model/AudienceExportJobStatus.h>
#include <aws/cleanroomsml/model/AudienceSize.h>
#include <aws/cleanroomsml/model/StatusDetails.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CleanRoomsML {
namespace Model {

/**
 * <p>Provides information about the audience export job.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/AudienceExportJobSummary">AWS
 * API Reference</a></p>
 */
class AudienceExportJobSummary {
 public:
  AWS_CLEANROOMSML_API AudienceExportJobSummary() = default;
  AWS_CLEANROOMSML_API AudienceExportJobSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLEANROOMSML_API AudienceExportJobSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLEANROOMSML_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The time at which the audience export job was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreateTime() const { return m_createTime; }
  inline bool CreateTimeHasBeenSet() const { return m_createTimeHasBeenSet; }
  template <typename CreateTimeT = Aws::Utils::DateTime>
  void SetCreateTime(CreateTimeT&& value) {
    m_createTimeHasBeenSet = true;
    m_createTime = std::forward<CreateTimeT>(value);
  }
  template <typename CreateTimeT = Aws::Utils::DateTime>
  AudienceExportJobSummary& WithCreateTime(CreateTimeT&& value) {
    SetCreateTime(std::forward<CreateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The most recent time at which the audience export job was updated.</p>
   */
  inline const Aws::Utils::DateTime& GetUpdateTime() const { return m_updateTime; }
  inline bool UpdateTimeHasBeenSet() const { return m_updateTimeHasBeenSet; }
  template <typename UpdateTimeT = Aws::Utils::DateTime>
  void SetUpdateTime(UpdateTimeT&& value) {
    m_updateTimeHasBeenSet = true;
    m_updateTime = std::forward<UpdateTimeT>(value);
  }
  template <typename UpdateTimeT = Aws::Utils::DateTime>
  AudienceExportJobSummary& WithUpdateTime(UpdateTimeT&& value) {
    SetUpdateTime(std::forward<UpdateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the audience export job.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  AudienceExportJobSummary& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the audience generation job that was
   * exported.</p>
   */
  inline const Aws::String& GetAudienceGenerationJobArn() const { return m_audienceGenerationJobArn; }
  inline bool AudienceGenerationJobArnHasBeenSet() const { return m_audienceGenerationJobArnHasBeenSet; }
  template <typename AudienceGenerationJobArnT = Aws::String>
  void SetAudienceGenerationJobArn(AudienceGenerationJobArnT&& value) {
    m_audienceGenerationJobArnHasBeenSet = true;
    m_audienceGenerationJobArn = std::forward<AudienceGenerationJobArnT>(value);
  }
  template <typename AudienceGenerationJobArnT = Aws::String>
  AudienceExportJobSummary& WithAudienceGenerationJobArn(AudienceGenerationJobArnT&& value) {
    SetAudienceGenerationJobArn(std::forward<AudienceGenerationJobArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const AudienceSize& GetAudienceSize() const { return m_audienceSize; }
  inline bool AudienceSizeHasBeenSet() const { return m_audienceSizeHasBeenSet; }
  template <typename AudienceSizeT = AudienceSize>
  void SetAudienceSize(AudienceSizeT&& value) {
    m_audienceSizeHasBeenSet = true;
    m_audienceSize = std::forward<AudienceSizeT>(value);
  }
  template <typename AudienceSizeT = AudienceSize>
  AudienceExportJobSummary& WithAudienceSize(AudienceSizeT&& value) {
    SetAudienceSize(std::forward<AudienceSizeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the audience export job.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  AudienceExportJobSummary& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the audience export job.</p>
   */
  inline AudienceExportJobStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(AudienceExportJobStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline AudienceExportJobSummary& WithStatus(AudienceExportJobStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{

  inline const StatusDetails& GetStatusDetails() const { return m_statusDetails; }
  inline bool StatusDetailsHasBeenSet() const { return m_statusDetailsHasBeenSet; }
  template <typename StatusDetailsT = StatusDetails>
  void SetStatusDetails(StatusDetailsT&& value) {
    m_statusDetailsHasBeenSet = true;
    m_statusDetails = std::forward<StatusDetailsT>(value);
  }
  template <typename StatusDetailsT = StatusDetails>
  AudienceExportJobSummary& WithStatusDetails(StatusDetailsT&& value) {
    SetStatusDetails(std::forward<StatusDetailsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon S3 bucket where the audience export is stored.</p>
   */
  inline const Aws::String& GetOutputLocation() const { return m_outputLocation; }
  inline bool OutputLocationHasBeenSet() const { return m_outputLocationHasBeenSet; }
  template <typename OutputLocationT = Aws::String>
  void SetOutputLocation(OutputLocationT&& value) {
    m_outputLocationHasBeenSet = true;
    m_outputLocation = std::forward<OutputLocationT>(value);
  }
  template <typename OutputLocationT = Aws::String>
  AudienceExportJobSummary& WithOutputLocation(OutputLocationT&& value) {
    SetOutputLocation(std::forward<OutputLocationT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Utils::DateTime m_createTime{};

  Aws::Utils::DateTime m_updateTime{};

  Aws::String m_name;

  Aws::String m_audienceGenerationJobArn;

  AudienceSize m_audienceSize;

  Aws::String m_description;

  AudienceExportJobStatus m_status{AudienceExportJobStatus::NOT_SET};

  StatusDetails m_statusDetails;

  Aws::String m_outputLocation;
  bool m_createTimeHasBeenSet = false;
  bool m_updateTimeHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_audienceGenerationJobArnHasBeenSet = false;
  bool m_audienceSizeHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_statusDetailsHasBeenSet = false;
  bool m_outputLocationHasBeenSet = false;
};

}  // namespace Model
}  // namespace CleanRoomsML
}  // namespace Aws
