declare const _exports: ({
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    fromZigbee: ({
        cluster: string;
        type: string;
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            gas: boolean;
            tamper: boolean;
            battery_low: boolean;
        };
    } | {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    })[];
    toZigbee: undefined[];
    exposes: exposes.Binary[];
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    extend: {
        exposes: any;
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
                state?: undefined;
            } | {
                state: {
                    state: any;
                };
            }>;
            convertGet: (entity: any, key: any, meta: any) => Promise<void>;
        }[];
    };
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            battery: any;
            voltage: number;
            battery_low: boolean;
        };
    } | FromZigbeeConverter)[];
    exposes: (exposes.Numeric | exposes.Enum)[];
    toZigbee: undefined[];
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string;
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            [x: number]: boolean;
        };
    } | {
        cluster: string;
        type: string;
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            contact: boolean;
            tamper: boolean;
            battery_low: boolean;
        };
    } | {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    })[];
    toZigbee: undefined[];
    exposes: (exposes.Numeric | exposes.Binary)[];
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: FromZigbeeConverter[];
    toZigbee: undefined[];
    exposes: (device: any, options: any) => exposes.Numeric[];
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => Promise<void>;
    } | {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    })[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: any[];
    meta: {
        tuyaDatapoints: (string | number | {
            to: (v: any) => any;
            from: (v: any) => any;
        })[][];
    };
    whiteLabel: {
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    }[];
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: any[];
    meta: {
        tuyaDatapoints: ((string | number | {
            from: (v: any) => boolean;
        })[] | (string | number | {
            to: (v: any) => any;
            from: (v: any) => any;
        })[])[];
    };
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    whiteLabel: ({
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    } | {
        vendor: string;
        model: string;
    } | {
        vendor: string;
        model: string;
        description: string;
    })[];
    extend: {
        meta: {
            applyRedFix: boolean;
            enhancedHue: boolean;
        };
        exposes: any[];
        fromZigbee: any[];
        toZigbee: any[];
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    whiteLabel: {
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    }[];
    toZigbee: ({
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state?: undefined;
        } | {
            state: {
                state: any;
            };
        }>;
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    } | {
        key: string[];
        options: exposes.Binary[];
        convertSet: (entity: any, _key: any, _value: any, meta: any) => Promise<{
            state: {
                color_mode: any;
                brightness: any;
                color_temp: any;
                color: {
                    hue: number;
                    saturation: number;
                };
            };
        }>;
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    })[];
    fromZigbee: {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    }[];
    exposes: exposes.Light[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    extend: {
        meta: {
            applyRedFix: boolean;
            enhancedHue: boolean;
        };
        exposes: any[];
        fromZigbee: any[];
        toZigbee: any[];
    };
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    extend: {
        meta: {
            applyRedFix: boolean;
            enhancedHue: boolean;
        };
        exposes: any[];
        fromZigbee: any[];
        toZigbee: any[];
    };
    exposes: exposes.Light[];
    toZigbee: any[];
    meta: {
        applyRedFix: boolean;
    };
} | {
    zigbeeModel: string[];
    model: string;
    description: string;
    vendor: string;
    extend: {
        exposes: any[];
        fromZigbee: any[];
        toZigbee: any[];
    };
    meta: {
        turnsOffAtBrightness1: boolean;
    };
    whiteLabel: {
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    }[];
} | {
    zigbeeModel: string[];
    model: string;
    description: string;
    vendor: string;
    extend: {
        exposes: any[];
        fromZigbee: any[];
        toZigbee: any[];
    };
    whiteLabel: {
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    }[];
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string;
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            occupancy: boolean;
            tamper: boolean;
            battery_low: boolean;
        };
    } | {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    })[];
    toZigbee: undefined[];
    onEvent: (type: any, data: any, device: any) => Promise<void>;
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: (exposes.Numeric | exposes.Binary)[];
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            battery: any;
            voltage: number;
            battery_low: boolean;
        };
    } | {
        cluster: string;
        type: string;
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            occupancy: boolean;
            tamper: boolean;
            battery_low: boolean;
        };
    } | {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    })[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: any[];
    meta: {
        tuyaDatapoints: (string | number | {
            to: (v: any) => any;
            from: (v: any) => string;
        })[][];
    };
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    whiteLabel: ({
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    } | {
        vendor: string;
        model: string;
    })[];
    fromZigbee: ({
        cluster: string;
        type: string;
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            occupancy: boolean;
            tamper: boolean;
            battery_low: boolean;
        };
    } | {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    })[];
    toZigbee: undefined[];
    exposes: (exposes.Numeric | exposes.Binary)[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string;
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            occupancy: boolean;
            tamper: boolean;
            battery_low: boolean;
        };
    } | {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    })[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<void>;
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    }[];
    exposes: any[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    whiteLabel: {
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    }[];
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            battery: any;
            voltage: number;
            battery_low: boolean;
        };
    } | {
        cluster: string;
        type: string;
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            water_leak: boolean;
            tamper: boolean;
            battery_low: boolean;
        };
    })[];
    whiteLabel: ({
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    } | {
        vendor: string;
        model: string;
    })[];
    toZigbee: undefined[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: (exposes.Numeric | exposes.Binary)[];
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    whiteLabel: ({
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    } | {
        vendor: string;
        model: string;
    })[];
    extend: {
        exposes: any;
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
                state?: undefined;
            } | {
                state: {
                    state: any;
                };
            }>;
            convertGet: (entity: any, key: any, meta: any) => Promise<void>;
        }[];
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    extend: {
        exposes: any;
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
                state?: undefined;
            } | {
                state: {
                    state: any;
                };
            }>;
            convertGet: (entity: any, key: any, meta: any) => Promise<void>;
        }[];
    };
    exposes: exposes.Switch[];
    endpoint: (device: any) => {
        l1: number;
        l2: number;
    };
    meta: {
        multiEndpoint: boolean;
        disableDefaultResponse: boolean;
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: any[];
    meta: {
        tuyaDatapoints: ((string | number | {
            to: (v: any) => any;
            from: (v: any) => any;
        })[] | (string | number | {
            to: (v: any) => any;
            from: (v: any) => string;
        } | {
            skip: (meta: any) => boolean;
        })[])[];
    };
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: any[];
    meta: {
        multiEndpoint: boolean;
        tuyaDatapoints: ((string | number | {
            to: (v: any) => any;
            from: (v: any) => any;
        })[] | (string | number | {
            to: (v: any) => any;
            from: (v: any) => string;
        } | {
            skip: (meta: any) => boolean;
        })[])[];
    };
    endpoint: (device: any) => {
        l1: number;
        l2: number;
    };
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: ({
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<void>;
    } | {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {
                calibration: any;
            };
        }>;
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    } | {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {
                motor_reversal: any;
            };
        }>;
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    } | {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {
                [x: number]: any;
            };
        }>;
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    })[];
    meta: {
        coverInverted: boolean;
    };
    whiteLabel: ({
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    } | {
        vendor: string;
        model: string;
    })[];
    exposes: any[];
} | {
    zigbeeModel: string[];
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    exposes: exposes.Switch[];
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    } | FromZigbeeConverter)[];
    toZigbee: ToZigbeeConverter[];
    meta: {
        multiEndpoint: boolean;
    };
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    endpoint: (device: any) => {
        l1: number;
        l2: number;
        l3: number;
        l4: number;
    };
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    exposes: exposes.Switch[];
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    } | FromZigbeeConverter)[];
    toZigbee: ToZigbeeConverter[];
    meta: {
        multiEndpoint: boolean;
    };
    endpoint: (device: any) => {
        l1: number;
        l2: number;
        l3: number;
        l4: number;
    };
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: exposes.Switch[];
    endpoint: (device: any) => {
        l1: number;
        l2: number;
        l3: number;
        l4: number;
        l5: number;
    };
    meta: {
        multiEndpoint: boolean;
        tuyaDatapoints: (string | number | {
            to: (v: any) => any;
            from: (v: any) => string;
        })[][];
    };
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    exposes: exposes.Switch[];
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    } | FromZigbeeConverter)[];
    toZigbee: ToZigbeeConverter[];
    whiteLabel: {
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    }[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    whiteLabel: {
        vendor: string;
        model: string;
        description: string;
    }[];
    exposes: exposes.Switch[];
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    } | FromZigbeeConverter)[];
    toZigbee: ToZigbeeConverter[];
    meta: {
        multiEndpoint: boolean;
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    endpoint: (device: any) => {
        l1: number;
        l2: number;
        l3: number;
    };
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            battery: any;
            voltage: number;
            battery_low: boolean;
        };
    } | {
        cluster: string;
        type: string;
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            action: any;
        };
    })[];
    exposes: (exposes.Numeric | exposes.Enum)[];
    toZigbee: undefined[];
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    exposes: exposes.Light[];
    fromZigbee: {
        cluster: string;
        type: string[];
        options: exposes.Binary[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: ({
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {
                state: any;
            };
        }>;
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    } | {
        key: string[];
        attr: any[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<void>;
    })[];
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    whiteLabel: ({
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    } | {
        vendor: string;
        model: string;
        description: string;
    })[];
    extend: {
        exposes: any[];
        fromZigbee: any[];
        toZigbee: any[];
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    toZigbee: ({
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state?: undefined;
        } | {
            state: {
                state: any;
            };
        }>;
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    } | {
        key: string[];
        options: exposes.Binary[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {
                brightness: number;
            };
            readAfterWriteTime?: undefined;
        } | {
            state: {
                color_mode: any;
                color: any;
                color_temp: any;
            };
            readAfterWriteTime: number;
        }>;
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    })[];
    fromZigbee: {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    }[];
    exposes: exposes.Light[];
} | {
    fingerprint: {
        manufacturerName: string;
    }[];
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        options: exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            [x: number]: any;
        };
    } | {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            battery: any;
            voltage: number;
            battery_low: boolean;
        };
    } | {
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            humidity: any;
        };
        cluster: string;
        type: string[];
        options: exposes.Numeric[];
    })[];
    toZigbee: undefined[];
    exposes: exposes.Numeric[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    whiteLabel: ({
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    } | {
        vendor: string;
        model: string;
    })[];
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            battery: any;
            voltage: number;
            battery_low: boolean;
        };
    } | {
        cluster: string;
        type: string[];
        options: exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            [x: number]: any;
        };
    } | {
        cluster: string;
        type: string[];
        options: exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            humidity: any;
        };
    })[];
    toZigbee: undefined[];
    exposes: exposes.Numeric[];
} | {
    zigbeeModel: string[];
    fingerprint: {
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    exposes: (exposes.Numeric | exposes.Enum)[];
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            battery: any;
            voltage: number;
            battery_low: boolean;
        };
    } | {
        cluster: string;
        type: string;
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            action: string;
        };
    })[];
    toZigbee: undefined[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    whiteLabel: ({
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    } | {
        vendor: string;
        model: string;
    })[];
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            battery: any;
            voltage: number;
            battery_low: boolean;
        };
    } | {
        cluster: string;
        type: string;
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            action: string;
        };
    })[];
    exposes: (exposes.Numeric | exposes.Enum)[];
    toZigbee: undefined[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    } | FromZigbeeConverter)[];
    exposes: exposes.Binary[];
    toZigbee: undefined[];
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    extend: {
        exposes: any;
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
                state?: undefined;
            } | {
                state: {
                    state: any;
                };
            }>;
            convertGet: (entity: any, key: any, meta: any) => Promise<void>;
        }[];
    };
    endpoint: (device: any) => {
        l1: number;
        l2: number;
    };
    meta: {
        multiEndpoint: boolean;
        multiEndpointSkip: string[];
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    whiteLabel: {
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    }[];
} | {
    fingerprint: any;
    model: string;
    description: string;
    vendor: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    }[];
    toZigbee: ({
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state?: undefined;
        } | {
            state: {
                state: any;
            };
        }>;
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    } | {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {
                [x: number]: any;
            };
        }>;
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    } | {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {
                switch_type: any;
            };
        }>;
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    })[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    exposes: any[];
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    extend: {
        exposes: any;
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
                state?: undefined;
            } | {
                state: {
                    state: any;
                };
            }>;
            convertGet: (entity: any, key: any, meta: any) => Promise<void>;
        }[];
    };
    whiteLabel: ({
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    } | {
        vendor: string;
        model: string;
        description: string;
    } | {
        vendor: string;
        model: string;
    })[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    extend: {
        exposes: any;
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
                state?: undefined;
            } | {
                state: {
                    state: any;
                };
            }>;
            convertGet: (entity: any, key: any, meta: any) => Promise<void>;
        }[];
    };
    exposes: exposes.Switch[];
    endpoint: (device: any) => {
        l1: number;
        l2: number;
    };
    meta: {
        multiEndpoint: boolean;
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    whiteLabel: ({
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    } | {
        vendor: string;
        model: string;
    })[];
    extend: {
        exposes: any;
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
                state?: undefined;
            } | {
                state: {
                    state: any;
                };
            }>;
            convertGet: (entity: any, key: any, meta: any) => Promise<void>;
        }[];
    };
    endpoint: (device: any) => {
        l1: number;
        l2: number;
    };
    meta: {
        multiEndpoint: boolean;
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    extend: {
        exposes: any;
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
                state?: undefined;
            } | {
                state: {
                    state: any;
                };
            }>;
            convertGet: (entity: any, key: any, meta: any) => Promise<void>;
        }[];
    };
    endpoint: (device: any) => {
        l1: number;
        l2: number;
    };
    meta: {
        multiEndpoint: boolean;
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    zigbeeModel: string[];
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    whiteLabel: ({
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    } | {
        vendor: string;
        model: string;
    } | {
        vendor: string;
        model: string;
        description: string;
    })[];
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    } | FromZigbeeConverter)[];
    toZigbee: ToZigbeeConverter[];
    exposes: any[];
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    } | FromZigbeeConverter)[];
    toZigbee: ToZigbeeConverter[];
    exposes: exposes.Cover[];
} | {
    zigbeeModel: string[];
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    meta: {
        tuyaThermostatPreset: {
            0: string;
            1: string;
            2: string;
            3: string;
            4: string;
            5: string;
            6: string;
        };
        tuyaThermostatSystemMode: {
            0: string;
            1: string;
            2: string;
        };
    };
    ota: {
        getImageMeta: (current: any, logger: any, device: any) => Promise<{
            fileVersion: any;
            fileSize: any;
            url: any;
            sha512: any;
            force: any;
        }>;
        isUpdateAvailable: (device: any, logger: any, requestPayload?: any) => Promise<any>;
        updateToLatest: (device: any, logger: any, onProgress: any) => Promise<any>;
        useIndexOverride: (indexFileName: any) => void;
        setDataDir: (dir: any) => void;
    };
    onEvent: (type: any, data: any, device: any) => Promise<void>;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    } | FromZigbeeConverter)[];
    toZigbee: ToZigbeeConverter[];
    exposes: any[];
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    onEvent: (type: any, data: any, device: any) => Promise<void>;
    options: exposes.Binary[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: any[];
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    meta: {
        tuyaDatapoints: ((string | number | {
            from: (v: any) => boolean;
        })[] | (string | number | {
            to: (v: any) => any;
            from: (v: any) => any;
        })[] | (string | number | {
            to: (v: any, meta: any) => Promise<any>;
            from: (v: any, meta: any, options: any) => any;
        })[])[];
    };
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    exposes: any[];
    whiteLabel: {
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    }[];
    meta: {
        tuyaDatapoints: ((string | number | {
            to: (v: any) => any;
            from: (v: any) => any;
        })[] | (string | number | {
            to: (v: any, meta: any) => Promise<any>;
            from: (v: any, meta: any, options: any) => any;
        })[])[];
    };
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    whiteLabel: ({
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    } | {
        vendor: string;
        model: string;
    })[];
    ota: {
        getImageMeta: (current: any, logger: any, device: any) => Promise<{
            fileVersion: any;
            fileSize: any;
            url: any;
            sha512: any;
            force: any;
        }>;
        isUpdateAvailable: (device: any, logger: any, requestPayload?: any) => Promise<any>;
        updateToLatest: (device: any, logger: any, onProgress: any) => Promise<any>;
        useIndexOverride: (indexFileName: any) => void;
        setDataDir: (dir: any) => void;
    };
    fromZigbee: {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    onEvent: (type: any, data: any, device: any) => Promise<void>;
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: any[];
    meta: {
        tuyaDatapoints: ((string | number | {
            from: (v: any) => boolean;
        })[] | (string | number | {
            to: (v: any) => any;
            from: (v: any) => any;
        })[] | (string | number | {
            to: (v: any, meta: any) => Promise<void>;
            from: (v: any) => {
                frost_protection: string;
            };
        })[] | (string | number | {
            from: (v: any) => string;
            to: (v: any, meta: any) => any[];
        })[] | (string | number | {
            to: (v: any, meta: any) => Promise<void>;
            from: (v: any) => {
                system_mode: string;
                heating_stop: string;
            };
        })[])[];
    };
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    fromZigbee: {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    onEvent: (type: any, data: any, device: any) => Promise<void>;
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    meta: {
        tuyaDatapoints: ((string | number | {
            from: (v: any) => boolean;
        })[] | (string | number | {
            to: (v: any) => any;
            from: (v: any) => any;
        })[])[];
    };
    exposes: any[];
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    onEvent: (type: any, data: any, device: any) => Promise<void>;
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: any[];
    meta: {
        tuyaDatapoints: ((number | {
            from: (v: any) => {
                battery_low: boolean;
                error?: undefined;
            } | {
                error: any;
                battery_low?: undefined;
            };
        })[] | (string | number | {
            from: (v: any) => any;
            to: (v: any) => any;
        })[])[];
    };
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    } | FromZigbeeConverter)[];
    toZigbee: ToZigbeeConverter[];
    onEvent: (type: any, data: any, device: any) => Promise<void>;
    meta: {
        thermostat: {
            weeklyScheduleMaxTransitions: number;
            weeklyScheduleSupportedModes: number[];
            weeklyScheduleFirstDayDpId: any;
        };
    };
    exposes: any[];
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    } | FromZigbeeConverter)[];
    toZigbee: ToZigbeeConverter[];
    onEvent: (type: any, data: any, device: any) => Promise<void>;
    meta: {
        timeout: number;
        thermostat: {
            weeklyScheduleMaxTransitions: number;
            weeklyScheduleSupportedModes: number[];
            weeklyScheduleFirstDayDpId: any;
        };
    };
    exposes: any[];
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    onEvent: (type: any, data: any, device: any) => Promise<void>;
    fromZigbee: {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: any[];
    meta: {
        tuyaDatapoints: ((string | number | {
            to: (v: any) => any;
            from: (v: any) => any;
        })[] | (number | {
            from: (v: any) => {
                preset: any;
                system_mode: any;
            };
        })[])[];
    };
} | {
    zigbeeModel: string[];
    model: string;
    description: string;
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    vendor: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    }[];
    toZigbee: ({
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state?: undefined;
        } | {
            state: {
                state: any;
            };
        }>;
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    } | {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {
                [x: number]: any;
            };
        }>;
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    })[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    options: exposes.Numeric[];
    exposes: any[];
    onEvent: (type: any, data: any, device: any, options: any, electricalMeasurement?: boolean, metering?: boolean) => Promise<void>;
} | {
    zigbeeModel: string[];
    model: string;
    description: string;
    vendor: string;
    whiteLabel: ({
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    } | {
        vendor: string;
        model: string;
    })[];
    ota: {
        getImageMeta: (current: any, logger: any, device: any) => Promise<{
            fileVersion: any;
            fileSize: any;
            url: any;
            sha512: any;
            force: any;
        }>;
        isUpdateAvailable: (device: any, logger: any, requestPayload?: any) => Promise<any>;
        updateToLatest: (device: any, logger: any, onProgress: any) => Promise<any>;
        useIndexOverride: (indexFileName: any) => void;
        setDataDir: (dir: any) => void;
    };
    extend: {
        exposes: any;
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
                state?: undefined;
            } | {
                state: {
                    state: any;
                };
            }>;
            convertGet: (entity: any, key: any, meta: any) => Promise<void>;
        }[];
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    fingerprint: any;
    model: string;
    description: string;
    vendor: string;
    extend: {
        exposes: any;
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
                state?: undefined;
            } | {
                state: {
                    state: any;
                };
            }>;
            convertGet: (entity: any, key: any, meta: any) => Promise<void>;
        }[];
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    fingerprint: {
        modelID: string;
        applicationVersion: number;
        priority: number;
    }[];
    model: string;
    description: string;
    vendor: string;
    whiteLabel: ({
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    } | {
        vendor: string;
        model: string;
    })[];
    ota: {
        getImageMeta: (current: any, logger: any, device: any) => Promise<{
            fileVersion: any;
            fileSize: any;
            url: any;
            sha512: any;
            force: any;
        }>;
        isUpdateAvailable: (device: any, logger: any, requestPayload?: any) => Promise<any>;
        updateToLatest: (device: any, logger: any, onProgress: any) => Promise<any>;
        useIndexOverride: (indexFileName: any) => void;
        setDataDir: (dir: any) => void;
    };
    extend: {
        exposes: any;
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
                state?: undefined;
            } | {
                state: {
                    state: any;
                };
            }>;
            convertGet: (entity: any, key: any, meta: any) => Promise<void>;
        }[];
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    options: exposes.Numeric[];
    onEvent: (type: any, data: any, device: any, options: any) => Promise<void>;
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    onEvent: (type: any, data: any, device: any) => Promise<void>;
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: any[];
    meta: {
        tuyaDatapoints: ((string | number | {
            from: (v: any) => boolean;
        })[] | (string | number | {
            to: (v: any) => any;
            from: (v: any) => any;
        })[])[];
    };
    whiteLabel: {
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    }[];
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    vendor: string;
    model: string;
    description: string;
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    fromZigbee: {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    exposes: any[];
    meta: {
        tuyaDatapoints: ((string | number | {
            from: (v: any) => boolean;
        })[] | (string | number | {
            to: (v: any) => any;
            from: (v: any) => string;
        })[])[];
    };
} | {
    zigbeeModel: string[];
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    exposes: any[];
    meta: {
        tuyaDatapoints: ((string | number | {
            from: (v: any) => boolean;
        })[] | (string | number | {
            to: (v: any) => any;
            from: (v: any) => any;
        })[])[];
    };
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    meta: {
        timeout: number;
        disableDefaultResponse: boolean;
    };
    fromZigbee: {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            smoke: boolean;
            battery: any;
            silence_siren: any;
            alarm: any;
        };
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<void>;
    }[];
    exposes: any[];
    onEvent: any;
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => Promise<void>;
    } | {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    })[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: exposes.Numeric[];
    meta: {
        tuyaDatapoints: (string | number | {
            to: (v: any) => number;
            from: (v: any) => number;
        })[][];
    };
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: (exposes.Numeric | exposes.Switch)[];
    meta: {
        tuyaDatapoints: ((string | number | {
            to: (v: any) => any;
            from: (v: any) => any;
        })[] | (number | {
            from: (v: any) => {
                voltage: number;
                current: number;
            };
        })[])[];
    };
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: any[];
    meta: {
        tuyaDatapoints: ((string | number | {
            to: (v: any) => any;
            from: (v: any) => any;
        })[] | (number | {
            from: (v: any) => {
                voltage: number;
                current: number;
                power: number;
            };
        })[] | (number | {
            from: (v: any) => {
                threshold_1_protection: any;
                threshold_1: any;
                threshold_1_value: number;
                threshold_2_protection: any;
                threshold_2: any;
                threshold_2_value: number;
            };
        })[])[];
    };
    whiteLabel: {
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    }[];
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    exposes: any[];
    meta: {
        tuyaDatapoints: ((string | number | {
            to: (v: any) => any;
            from: (v: any) => any;
        })[] | (number | {
            from: (v: any) => {
                voltage: number;
                current: number;
                power: number;
            };
        })[] | (number | {
            from: (v: any) => {
                threshold_1_protection: any;
                threshold_1: any;
                threshold_1_value: number;
                threshold_2_protection: any;
                threshold_2: any;
                threshold_2_value: number;
            };
        })[])[];
    };
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    extend: {
        exposes: any[];
        fromZigbee: any[];
        toZigbee: any[];
    };
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    extend: {
        exposes: any[];
        fromZigbee: any[];
        toZigbee: any[];
    };
    endpoint: (device: any) => {
        l1: number;
        l2: number;
    };
    meta: {
        multiEndpoint: boolean;
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    zigbeeModel: string[];
    fingerprint: {
        type: string;
        manufacturerID: number;
        applicationVersion: number;
        endpoints: {
            ID: number;
            profileID: number;
            deviceID: number;
            inputClusters: number[];
            outputClusters: number[];
        }[];
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    } | {
        cluster: string;
        type: string;
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    })[];
    toZigbee: undefined[];
    exposes: (exposes.Numeric | exposes.Binary)[];
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string;
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            occupancy: boolean;
            tamper: boolean;
            battery_low: boolean;
        };
    } | {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    })[];
    toZigbee: undefined[];
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    exposes: (exposes.Numeric | exposes.Binary)[];
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    extend: {
        exposes: any;
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
                state?: undefined;
            } | {
                state: {
                    state: any;
                };
            }>;
            convertGet: (entity: any, key: any, meta: any) => Promise<void>;
        }[];
    };
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    endpoint: (device: any) => {
        l1: number;
        l2: number;
        l3: number;
        l4: number;
        l5: number;
    };
    meta: {
        multiEndpoint: boolean;
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            battery: any;
            voltage: number;
            battery_low: boolean;
        };
    } | {
        cluster: string;
        type: string[];
        options: exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            [x: number]: any;
        };
    } | {
        cluster: string;
        type: string[];
        options: exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            humidity: any;
        };
    })[];
    toZigbee: undefined[];
    exposes: exposes.Numeric[];
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    extend: {
        exposes: any;
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
                state?: undefined;
            } | {
                state: {
                    state: any;
                };
            }>;
            convertGet: (entity: any, key: any, meta: any) => Promise<void>;
        }[];
    };
    whiteLabel: ({
        vendor: string;
        model: string;
    } | {
        vendor: string;
        model: string;
        description: string;
    })[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    extend: {
        exposes: any;
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
                state?: undefined;
            } | {
                state: {
                    state: any;
                };
            }>;
            convertGet: (entity: any, key: any, meta: any) => Promise<void>;
        }[];
    };
    endpoint: (device: any) => {
        left: number;
        right: number;
    };
    meta: {
        multiEndpoint: boolean;
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    extend: {
        exposes: any;
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
                state?: undefined;
            } | {
                state: {
                    state: any;
                };
            }>;
            convertGet: (entity: any, key: any, meta: any) => Promise<void>;
        }[];
    };
    endpoint: (device: any) => {
        left: number;
        right: number;
    };
    meta: {
        multiEndpoint: boolean;
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    } | FromZigbeeConverter)[];
    toZigbee: ToZigbeeConverter[];
    exposes: exposes.Light[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            action: string;
        };
    }[];
    exposes: exposes.Enum[];
    toZigbee: undefined[];
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    } | FromZigbeeConverter)[];
    exposes: exposes.Binary[];
    toZigbee: undefined[];
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    extend: {
        exposes: any;
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
                state?: undefined;
            } | {
                state: {
                    state: any;
                };
            }>;
            convertGet: (entity: any, key: any, meta: any) => Promise<void>;
        }[];
    };
    endpoint: (device: any) => {
        l1: number;
        l2: number;
        l3: number;
        l4: number;
    };
    whiteLabel: {
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    }[];
    meta: {
        multiEndpoint: boolean;
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    extend: {
        exposes: any;
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
                state?: undefined;
            } | {
                state: {
                    state: any;
                };
            }>;
            convertGet: (entity: any, key: any, meta: any) => Promise<void>;
        }[];
    };
    endpoint: (device: any) => {
        l1: number;
        l2: number;
        l3: number;
        l4: number;
    };
    meta: {
        multiEndpoint: boolean;
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    extend: {
        exposes: any;
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
                state?: undefined;
            } | {
                state: {
                    state: any;
                };
            }>;
            convertGet: (entity: any, key: any, meta: any) => Promise<void>;
        }[];
    };
    exposes: exposes.Switch[];
    endpoint: (device: any) => {
        l1: number;
        l2: number;
        l3: number;
        l4: number;
        l5: number;
        l6: number;
    };
    meta: {
        multiEndpoint: boolean;
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            fan_mode: any;
            fan_state: string;
        };
    } | FromZigbeeConverter)[];
    toZigbee: ({
        key: string[];
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    } | {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<void>;
    })[];
    exposes: any[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    exposes: any[];
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    } | FromZigbeeConverter)[];
    meta: {
        tuyaThermostatSystemMode: {
            0: string;
            1: string;
            2: string;
            3: string;
            4: string;
        };
        tuyaThermostatPreset: {
            0: string;
            1: string;
            2: string;
            3: string;
            4: string;
            5: string;
            6: string;
        };
    };
    toZigbee: ToZigbeeConverter[];
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    extend: {
        exposes: any;
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
                state?: undefined;
            } | {
                state: {
                    state: any;
                };
            }>;
            convertGet: (entity: any, key: any, meta: any) => Promise<void>;
        }[];
    };
    fromZigbee: {
        cluster: string;
        type: string[];
        options: exposes.Binary[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    exposes: exposes.Switch[];
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    meta: {
        multiEndpoint: boolean;
    };
    endpoint: (device: any) => {
        l1: number;
        l2: number;
        l3: number;
        l4: number;
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            battery: any;
            voltage: number;
            battery_low: boolean;
        };
    } | {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            duration: any;
            volume: number;
            alarm: boolean;
        };
    })[];
    exposes: any[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<void>;
    }[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    } | FromZigbeeConverter)[];
    toZigbee: ToZigbeeConverter[];
    onEvent: (type: any, data: any, device: any) => Promise<void>;
    exposes: any[];
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<void>;
    }[];
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    exposes: any[];
    onEvent: (type: any, data: any, device: any) => Promise<void>;
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            battery: any;
            voltage: number;
            battery_low: boolean;
        };
    } | {
        cluster: string;
        type: string[];
        options: exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            [x: number]: any;
        };
    } | {
        cluster: string;
        type: string[];
        options: exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            illuminance: any;
            illuminance_lux: any;
        };
    } | {
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            humidity: any;
        };
        cluster: string;
        type: string[];
        options: exposes.Numeric[];
    })[];
    toZigbee: undefined[];
    exposes: exposes.Numeric[];
    whiteLabel: {
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    }[];
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            battery: any;
            voltage: number;
            battery_low: boolean;
        };
    } | {
        cluster: string;
        type: string;
        options: exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            vibration: boolean;
            tamper: boolean;
            battery_low: boolean;
        };
    })[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {
                sensitivity: any;
            };
        }>;
    }[];
    exposes: any[];
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    description: string;
    vendor: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    }[];
    toZigbee: ({
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state?: undefined;
        } | {
            state: {
                state: any;
            };
        }>;
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    } | {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {
                indicator_mode: any;
            };
        }>;
    } | {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {
                [x: number]: any;
            };
        }>;
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    })[];
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    ota: {
        getImageMeta: (current: any, logger: any, device: any) => Promise<{
            fileVersion: any;
            fileSize: any;
            url: any;
            sha512: any;
            force: any;
        }>;
        isUpdateAvailable: (device: any, logger: any, requestPayload?: any) => Promise<any>;
        updateToLatest: (device: any, logger: any, onProgress: any) => Promise<any>;
        useIndexOverride: (indexFileName: any) => void;
        setDataDir: (dir: any) => void;
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: any[];
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    } | FromZigbeeConverter)[];
    toZigbee: ToZigbeeConverter[];
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: any[];
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    exposes: any[];
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            battery: any;
            voltage: number;
            battery_low: boolean;
        };
    } | {
        cluster: string;
        type: string;
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            action: any;
        };
    } | {
        cluster: string;
        type: string[];
        options: exposes.Composite[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            action: any;
        };
    } | {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            operation_mode: any;
        };
    })[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {
                operation_mode: any;
            };
        }>;
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    }[];
    onEvent: (type: any, data: any, device: any) => Promise<void>;
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    description: string;
    fromZigbee: FromZigbeeConverter[];
    toZigbee: ToZigbeeConverter[];
    exposes: any[];
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    extend: {
        exposes: any[];
        fromZigbee: any[];
        toZigbee: any[];
    };
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: FromZigbeeConverter[];
    toZigbee: ToZigbeeConverter[];
    whiteLabel: {
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    }[];
    exposes: any[];
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    exposes: any[];
    meta: {
        tuyaDatapoints: ((string | number | {
            from: (v: any) => boolean;
        })[] | (string | number | {
            to: (v: any) => any;
            from: (v: any) => any;
        })[])[];
    };
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    } | FromZigbeeConverter)[];
    toZigbee: ToZigbeeConverter[];
    onEvent: (type: any, data: any, device: any) => Promise<void>;
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: any[];
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: FromZigbeeConverter[];
    toZigbee: ToZigbeeConverter[];
    exposes: any[];
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<any>;
    }[];
    onEvent: (type: any, data: any, device: any) => Promise<void>;
    exposes: any[];
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => void;
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<void>;
    }[];
    exposes: any[];
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<void>;
    }[];
    onEvent: (type: any, data: any, device: any) => Promise<void>;
    exposes: any[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: any[];
    toZigbee: any[];
    exposes: any[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    fromZigbee: ({
        cluster: string;
        type: string[];
        options: exposes.Binary[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    } | {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            [x: number]: any;
        };
    } | {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            min_brightness: number;
            max_brightness: number;
            brightness: number;
        };
    } | {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            light_type: any;
        };
    })[];
    toZigbee: ({
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {
                brightness: any;
                state: string;
            };
        }>;
    } | {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {
                [x: number]: any;
            };
        }>;
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    } | {
        key: string[];
        options: any[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state?: undefined;
        } | {
            state: {
                state: any;
            };
        } | {
            state: {
                state: string;
                brightness: any;
            };
        }>;
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    })[];
    exposes: any[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: any[];
    toZigbee: any[];
    meta: {
        multiEndpoint: boolean;
    };
    exposes: any[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    endpoint: (device: any) => {
        l1: number;
        l2: number;
    };
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        options: exposes.Binary[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    } | {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            [x: number]: any;
        };
    } | {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            min_brightness: number;
            max_brightness: number;
            brightness: number;
        };
    } | {
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            light_type: any;
        };
    })[];
    toZigbee: ({
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {
                brightness: any;
                state: string;
            };
        }>;
    } | {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {
                [x: number]: any;
            };
        }>;
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    } | {
        key: string[];
        options: any[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state?: undefined;
        } | {
            state: {
                state: any;
            };
        } | {
            state: {
                state: string;
                brightness: any;
            };
        }>;
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    })[];
    meta: {
        multiEndpoint: boolean;
    };
    exposes: (exposes.Enum | exposes.Light)[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    endpoint: (device: any) => {
        l1: number;
        l2: number;
    };
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    whiteLabel: {
        vendor: string;
        model: string;
    }[];
    exposes: any[];
    meta: {
        tuyaDatapoints: ((string | number | {
            to: (v: any) => any;
            from: (v: any) => any;
        })[] | (number | {
            from: (v: any) => {
                [x: string]: number;
            };
        })[])[];
    };
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    onEvent: (type: any, data: any, device: any) => Promise<void>;
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: any[];
    meta: {
        tuyaSendCommand: string;
        tuyaDatapoints: (string | number | {
            to: (v: any) => any;
            from: (v: any) => any;
        })[][];
    };
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: undefined[];
    toZigbee: ({
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<void>;
    } | {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {
                [x: number]: any;
            };
        }>;
    })[];
    exposes: any[];
} | {
    fingerprint: any;
    model: string;
    description: string;
    vendor: string;
    ota: {
        getImageMeta: (current: any, logger: any, device: any) => Promise<{
            fileVersion: any;
            fileSize: any;
            url: any;
            sha512: any;
            force: any;
        }>;
        isUpdateAvailable: (device: any, logger: any, requestPayload?: any) => Promise<any>;
        updateToLatest: (device: any, logger: any, onProgress: any) => Promise<any>;
        useIndexOverride: (indexFileName: any) => void;
        setDataDir: (dir: any) => void;
    };
    extend: {
        exposes: any;
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
                state?: undefined;
            } | {
                state: {
                    state: any;
                };
            }>;
            convertGet: (entity: any, key: any, meta: any) => Promise<void>;
        }[];
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    whiteLabel: {
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    }[];
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state?: undefined;
        } | {
            state: {
                state: any;
            };
        }>;
        convertGet: (entity: any, key: any, meta: any) => Promise<void>;
    }[];
    extend: {
        exposes: any[];
        fromZigbee: any[];
        toZigbee: any[];
    };
    exposes: exposes.Switch[];
    endpoint: (device: any) => {
        l1: number;
        l2: number;
    };
    meta: {
        multiEndpoint: boolean;
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    extend: {
        exposes: any;
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
                state?: undefined;
            } | {
                state: {
                    state: any;
                };
            }>;
            convertGet: (entity: any, key: any, meta: any) => Promise<void>;
        }[];
    };
    endpoint: (device: any) => {
        left: number;
        center: number;
        right: number;
    };
    meta: {
        multiEndpoint: boolean;
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    whiteLabel: {
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    }[];
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: any[];
    endpoint: (device: any) => {
        l1: number;
        l2: number;
        l3: number;
        l4: number;
    };
    meta: {
        multiEndpoint: boolean;
        tuyaDatapoints: (string | number | {
            to: (v: any) => any;
            from: (v: any) => string;
        })[][];
    };
    whiteLabel: {
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    }[];
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    options: exposes.Binary[];
    fromZigbee: {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    exposes: any[];
    meta: {
        tuyaDatapoints: ((string | number | {
            to: (v: any) => any;
            from: (v: any) => string;
        })[] | (string | number | {
            to: (v: any, meta: any) => Promise<any>;
            from: (v: any, meta: any, options: any) => any;
        })[])[];
    };
    whiteLabel: {
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    }[];
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    options: exposes.Binary[];
    fromZigbee: {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    exposes: any[];
    endpoint: (device: any) => {
        l1: number;
    };
    meta: {
        multiEndpoint: boolean;
        tuyaDatapoints: ((string | number | {
            to: (v: any) => any;
            from: (v: any) => string;
        })[] | (string | number | {
            to: (v: any, meta: any) => Promise<any>;
            from: (v: any, meta: any, options: any) => any;
        })[])[];
    };
    whiteLabel: {
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    }[];
} | {
    fingerprint: {
        modelID: string;
        manufacturerName: string;
    }[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: {
        cluster: string;
        type: string[];
        options: (definition: any) => exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {};
    }[];
    toZigbee: {
        key: string[];
        convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
            state: {};
        }>;
    }[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    exposes: exposes.Numeric[];
    meta: {
        tuyaDatapoints: ((string | number | {
            to: (v: any) => any;
            from: (v: any) => any;
        })[] | (number | {
            from: (v: any) => {
                voltage: number;
                current: number;
                power: any;
            };
        })[])[];
    };
} | {
    fingerprint: any;
    model: string;
    vendor: string;
    description: string;
    extend: {
        exposes: any;
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
                state?: undefined;
            } | {
                state: {
                    state: any;
                };
            }>;
            convertGet: (entity: any, key: any, meta: any) => Promise<void>;
        }[];
    };
    whiteLabel: ({
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    } | {
        vendor: string;
        model: string;
    })[];
} | {
    fingerprint: any;
    model: string;
    description: string;
    vendor: string;
    ota: {
        getImageMeta: (current: any, logger: any, device: any) => Promise<{
            fileVersion: any;
            fileSize: any;
            url: any;
            sha512: any;
            force: any;
        }>;
        isUpdateAvailable: (device: any, logger: any, requestPayload?: any) => Promise<any>;
        updateToLatest: (device: any, logger: any, onProgress: any) => Promise<any>;
        useIndexOverride: (indexFileName: any) => void;
        setDataDir: (dir: any) => void;
    };
    extend: {
        exposes: any;
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: any, msg: any, publish: any, options: any, meta: any) => any;
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: any, key: any, value: any, meta: any) => Promise<{
                state?: undefined;
            } | {
                state: {
                    state: any;
                };
            }>;
            convertGet: (entity: any, key: any, meta: any) => Promise<void>;
        }[];
    };
    endpoint: (device: any) => {
        l1: number;
        l2: number;
    };
    meta: {
        multiEndpoint: boolean;
        multiEndpointSkip: string[];
    };
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    options: exposes.Numeric[];
    onEvent: (type: any, data: any, device: any, options: any) => Promise<void>;
} | {
    zigbeeModel: string[];
    model: string;
    vendor: string;
    description: string;
    fromZigbee: ({
        cluster: string;
        type: string[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            battery: any;
            voltage: number;
            battery_low: boolean;
        };
    } | {
        cluster: string;
        type: string;
        options: exposes.Numeric[];
        convert: (model: any, msg: any, publish: any, options: any, meta: any) => {
            occupancy: boolean;
            tamper: boolean;
            battery_low: boolean;
        };
    })[];
    toZigbee: undefined[];
    exposes: (exposes.Numeric | exposes.Binary)[];
    configure: (device: any, coordinatorEndpoint: any, logger: any) => Promise<void>;
    whiteLabel: {
        vendor: any;
        model: any;
        description: any;
        fingerprint: any;
    }[];
})[];
export = _exports;
import exposes = require("../lib/exposes");
//# sourceMappingURL=tuya.d.ts.map