/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.modules.startup;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.modules.startup.CopyFiles;
import org.graalvm.visualvm.modules.startup.ImportPanel;
import org.graalvm.visualvm.modules.startup.Utils;
import org.graalvm.visualvm.modules.startup.dialogs.StartupDialog;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

public class ImportSettings {
    private static final String[] SUPPORTED_USERDIRS = new String[]{"2.0", "2.0.1", "2.0.2", "2.0.3", "2.0.4", "2.0.5", "2.0.6", "2.0.7", "2.1", "2.1.1", "2.1.2", "2.1.3", "2.1.4", "2.1.5", "2.1.6", "2.1.7", "2.1.8"};
    private static final Logger LOGGER = Logger.getLogger(ImportSettings.class.getName());

    public static void main(String[] args) throws Exception {
        File userdirsRoot;
        File userdir;
        String userdirS = System.getProperty("netbeans.user");
        File file = userdir = userdirS == null || userdirS.isEmpty() ? null : new File(userdirS);
        if (userdir == null || !userdir.isDirectory()) {
            LOGGER.info("Skipping import, could not resolve VisualVM userdir: " + userdirS);
            return;
        }
        String importUserdirS = System.getProperty("visualvm.import_userdir");
        if (importUserdirS != null && !importUserdirS.isEmpty()) {
            File importUserdir = new File(importUserdirS);
            String msg = !importUserdir.isDirectory() ? "not a directory" : (userdir.equals(importUserdir) ? "own userdir" : null);
            if (msg == null) {
                ImportSettings.copyToUserdir(importUserdir, userdir);
            } else {
                LOGGER.info("Skipping import from visualvm.import_userdir, wrong directory provided (" + msg + "): " + importUserdirS);
            }
            return;
        }
        String userdirsRootS = System.getProperty("netbeans.default_userdir_root");
        File file2 = userdirsRoot = userdirsRootS == null || userdirsRootS.isEmpty() ? null : new File(userdirsRootS);
        if (userdirsRoot == null || !userdirsRoot.isDirectory()) {
            LOGGER.info("Skipping import, could not resolve VisualVM userdirs root: " + userdirsRootS);
            return;
        }
        List<File> userdirs = ImportSettings.availableUserdirs(userdirsRoot, userdir);
        if (userdirs.isEmpty()) {
            LOGGER.info("Skipping import, no supported userdirs found in: " + userdirsRootS);
            return;
        }
        File latestRelease = ImportSettings.latestReleaseUserdir(userdirs);
        File recentlyUsed = ImportSettings.lastRecentlyUsedUserdir(userdirs);
        Utils.setSystemLaF();
        final JDialog d = StartupDialog.create(NbBundle.getMessage(ImportSettings.class, (String)"ImportSettings_Caption"), null, -1);
        ImportPanel p = new ImportPanel(latestRelease, recentlyUsed, userdirsRoot, SUPPORTED_USERDIRS[0]){

            @Override
            boolean isSupportedImport(File dir) {
                return ImportSettings.isSupportedUserdir(dir, userdir);
            }

            @Override
            void contentsChanged() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        d.pack();
                    }
                });
            }

            @Override
            void beforeImport() {
                d.setDefaultCloseOperation(0);
            }

            @Override
            void doImport(File source) throws Exception {
                ImportSettings.copyToUserdir(source, userdir);
            }

            @Override
            void afterImport() {
                d.setDefaultCloseOperation(2);
            }

            @Override
            void close() {
                d.setVisible(false);
                d.dispose();
            }
        };
        d.getContentPane().add((Component)p, "Center");
        d.getRootPane().setDefaultButton(p.getDefaultButton());
        d.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (d.getDefaultCloseOperation() == 2) {
                    d.setVisible(false);
                    d.dispose();
                }
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        d.pack();
        d.setLocationRelativeTo(null);
        d.setVisible(true);
    }

    private static List<File> availableUserdirs(File userdirsRoot, File userdir) {
        ArrayList<File> userdirs = new ArrayList<File>();
        for (String supported : SUPPORTED_USERDIRS) {
            File available = ImportSettings.availableUserdir(userdirsRoot, supported, userdir);
            if (available == null) continue;
            userdirs.add(available);
        }
        return userdirs;
    }

    private static File availableUserdir(File userdirsFolder, String dir, File current) {
        File file = new File(userdirsFolder, dir);
        return ImportSettings.isSupportedUserdir(file, current) ? file : null;
    }

    private static boolean isSupportedUserdir(File userdir, File current) {
        return !current.equals(userdir) && userdir.isDirectory() && new File(userdir, "config").isDirectory();
    }

    private static File latestReleaseUserdir(List<File> userdirs) {
        return userdirs.isEmpty() ? null : userdirs.get(userdirs.size() - 1);
    }

    private static File lastRecentlyUsedUserdir(List<File> userdirs) {
        File lastRecent = null;
        long lastModified = -1L;
        for (File userdir : userdirs) {
            long modified = userdir.lastModified();
            if (modified <= lastModified) continue;
            lastModified = modified;
            lastRecent = userdir;
        }
        return lastRecent;
    }

    private static void copyToUserdir(File source, File userdir) throws IOException, PropertyVetoException {
        File visualvmDir = InstalledFileLocator.getDefault().locate("modules", null, false).getParentFile().getParentFile();
        File importFile = new File(visualvmDir, "etc/visualvm.import");
        LOGGER.fine("Import file: " + importFile);
        LOGGER.info("Importing from " + source + " to " + userdir);
        File[] files1 = userdir.listFiles();
        try {
            CopyFiles.copyDeep(source, userdir, importFile);
        }
        catch (Exception e) {
            try {
                ImportSettings.cleanupUserdir(userdir, files1);
            }
            catch (Exception ee) {
                LOGGER.info("Failed to cleanup after import failure: " + ee);
            }
            throw e;
        }
        System.setProperty("plugin.manager.import.from", source.getAbsolutePath());
    }

    private static void cleanupUserdir(File userdir, File[] initialFiles) {
        File config;
        File[] files = userdir.listFiles();
        if (initialFiles.length != files.length) {
            ArrayList<File> imported = new ArrayList<File>(Arrays.asList(files));
            imported.removeAll(Arrays.asList(initialFiles));
            for (File f : imported) {
                ImportSettings.delete(f);
            }
        }
        if ((config = new File(userdir, "config")).isDirectory()) {
            for (File f : config.listFiles()) {
                ImportSettings.delete(f);
            }
        }
    }

    private static void delete(File file) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                ImportSettings.delete(f);
            }
        }
        file.delete();
    }
}

