/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLIndividualAxiomImplWithEntityAndAnonCaching;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectOneOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubClassOfAxiomImpl;

public class OWLClassAssertionAxiomImpl
extends OWLIndividualAxiomImplWithEntityAndAnonCaching
implements OWLClassAssertionAxiom {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWLIndividual individual;
    @Nonnull
    private final OWLClassExpression classExpression;

    public OWLClassAssertionAxiomImpl(@Nonnull OWLIndividual individual, @Nonnull OWLClassExpression classExpression, @Nonnull Collection<? extends OWLAnnotation> annotations) {
        super(annotations);
        this.individual = OWLAPIPreconditions.checkNotNull(individual, "individual cannot be null");
        this.classExpression = OWLAPIPreconditions.checkNotNull(classExpression, "classExpression cannot be null");
    }

    @Override
    public OWLClassAssertionAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLClassAssertionAxiomImpl(this.getIndividual(), this.getClassExpression(), NO_ANNOTATIONS);
    }

    @Override
    public OWLClassAssertionAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return new OWLClassAssertionAxiomImpl(this.getIndividual(), this.getClassExpression(), this.mergeAnnos(annotations));
    }

    @Override
    public OWLClassExpression getClassExpression() {
        return this.classExpression;
    }

    @Override
    public OWLIndividual getIndividual() {
        return this.individual;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLClassAssertionAxiom)) {
            return false;
        }
        OWLClassAssertionAxiom other = (OWLClassAssertionAxiom)obj;
        return other.getIndividual().equals(this.individual) && other.getClassExpression().equals(this.classExpression);
    }

    @Override
    public OWLSubClassOfAxiom asOWLSubClassOfAxiom() {
        return new OWLSubClassOfAxiomImpl(new OWLObjectOneOfImpl(CollectionFactory.createSet(this.getIndividual())), this.getClassExpression(), NO_ANNOTATIONS);
    }

    @Override
    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public AxiomType<?> getAxiomType() {
        return AxiomType.CLASS_ASSERTION;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLClassAssertionAxiom otherAx = (OWLClassAssertionAxiom)object;
        int diff = this.getIndividual().compareTo(otherAx.getIndividual());
        if (diff != 0) {
            return diff;
        }
        return this.getClassExpression().compareTo(otherAx.getClassExpression());
    }
}

