/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.weather;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.weather.DarkSky;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;

@DefaultProperty(value="children")
public class WeatherSymbol
extends Region {
    private static final double PREFERRED_WIDTH = 64.0;
    private static final double PREFERRED_HEIGHT = 64.0;
    private static final double MINIMUM_WIDTH = 10.0;
    private static final double MINIMUM_HEIGHT = 10.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final StyleablePropertyFactory<WeatherSymbol> FACTORY = new StyleablePropertyFactory(Region.getClassCssMetaData());
    private static final CssMetaData<WeatherSymbol, Color> SYMBOL_COLOR = FACTORY.createColorCssMetaData("-symbol-color", s2 -> s2.symbolColor, Color.WHITE, false);
    private ObjectProperty<DarkSky.ConditionAndIcon> condition;
    private StyleableProperty<Color> symbolColor;
    private double size;
    private Region conditionIcon;
    private Pane pane;

    public WeatherSymbol() {
        this(DarkSky.ConditionAndIcon.NONE, 64.0, Color.WHITE);
    }

    public WeatherSymbol(DarkSky.ConditionAndIcon CONDITION, double SIZE2, Color COLOR) {
        this.condition = new ObjectPropertyBase<DarkSky.ConditionAndIcon>(null == CONDITION ? DarkSky.ConditionAndIcon.NONE : CONDITION){

            @Override
            protected void invalidated() {
                WeatherSymbol.this.conditionIcon.setId(((DarkSky.ConditionAndIcon)((Object)this.get())).styleClass);
                WeatherSymbol.this.resize();
            }

            @Override
            public Object getBean() {
                return WeatherSymbol.this;
            }

            @Override
            public String getName() {
                return "condition";
            }
        };
        this.symbolColor = new StyleableObjectProperty<Color>(null == COLOR ? Tile.FOREGROUND : COLOR){

            @Override
            public Object getBean() {
                return WeatherSymbol.this;
            }

            @Override
            public String getName() {
                return "symbolColor";
            }

            @Override
            public CssMetaData<? extends Styleable, Color> getCssMetaData() {
                return SYMBOL_COLOR;
            }
        };
        this.size = SIZE2;
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(64.0, 64.0);
            }
        }
        this.getStyleClass().setAll((String[])new String[]{"weather-symbol"});
        this.conditionIcon = new Region();
        this.conditionIcon.setId(((DarkSky.ConditionAndIcon)((Object)this.condition.get())).styleClass);
        this.conditionIcon.setStyle("-symbol-color: " + this.getSymbolColor().toString().replace("0x", "#") + ";");
        this.pane = new Pane(this.conditionIcon);
        this.getChildren().setAll((Node[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
    }

    @Override
    protected double computeMinWidth(double HEIGHT) {
        return 10.0;
    }

    @Override
    protected double computeMinHeight(double WIDTH) {
        return 10.0;
    }

    @Override
    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    @Override
    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    @Override
    protected double computeMaxWidth(double HEIGHT) {
        return 1024.0;
    }

    @Override
    protected double computeMaxHeight(double WIDTH) {
        return 1024.0;
    }

    @Override
    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public final DarkSky.ConditionAndIcon getCondition() {
        return (DarkSky.ConditionAndIcon)((Object)this.condition.get());
    }

    public final void setCondition(DarkSky.ConditionAndIcon CONDITION) {
        this.condition.set(CONDITION);
    }

    public final ObjectProperty<DarkSky.ConditionAndIcon> conditionProperty() {
        return this.condition;
    }

    public final Color getSymbolColor() {
        return (Color)this.symbolColor.getValue();
    }

    public final void setSymbolColor(Color COLOR) {
        this.symbolColor.setValue(COLOR);
    }

    public final StyleableProperty<Color> symbolColorProperty() {
        return this.symbolColor;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return FACTORY.getCssMetaData();
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return WeatherSymbol.getClassCssMetaData();
    }

    public void resize() {
        double height;
        double width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        double d = this.size = width < (height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom()) ? width : height;
        if (width > 0.0 && height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.setPrefSize(this.size, this.size);
            this.pane.relocate((this.getWidth() - this.size) * 0.5, (this.getHeight() - this.size) * 0.5);
            this.conditionIcon.setPrefSize(this.size * this.getCondition().widthFactor, this.size * this.getCondition().heightFactor);
            this.conditionIcon.relocate((this.size - this.conditionIcon.getPrefWidth()) * 0.5, (this.size - this.conditionIcon.getPrefHeight()) * 0.5);
        }
    }
}

