/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.BindingContextSuppressCache;
import org.jetbrains.kotlin.resolve.diagnostics.KotlinSuppressCache;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\"\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/OnDemandSuppressCache;", "Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "processedRoots", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "storage", "", "Lcom/intellij/psi/PsiElement;", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "ensureRootProcessed", "", "rootElement", "getSuppressionAnnotations", "annotated", "getClosestAnnotatedAncestorElement", "element", "excludeSelf", "", "PrecomputingVisitor", "frontend"})
public final class OnDemandSuppressCache
extends KotlinSuppressCache {
    @NotNull
    private final BindingContext context;
    @NotNull
    private final Set<KtFile> processedRoots;
    @NotNull
    private final Map<PsiElement, List<AnnotationDescriptor>> storage;

    public OnDemandSuppressCache(@NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        super(context2.getProject());
        this.context = context2;
        this.processedRoots = new LinkedHashSet();
        this.storage = new LinkedHashMap();
    }

    private final synchronized void ensureRootProcessed(PsiElement rootElement) {
        if (!(rootElement instanceof KtFile)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!this.processedRoots.contains(rootElement)) {
            PrecomputingVisitor visitor2 = new PrecomputingVisitor(this.storage, new BindingContextSuppressCache(this.context));
            ((KtFile)rootElement).accept(visitor2, null);
            this.processedRoots.add((KtFile)rootElement);
        }
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> getSuppressionAnnotations(@NotNull PsiElement annotated) {
        Intrinsics.checkNotNullParameter(annotated, "annotated");
        List<AnnotationDescriptor> list = this.storage.get(annotated);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    protected PsiElement getClosestAnnotatedAncestorElement(@NotNull PsiElement element, @NotNull PsiElement rootElement, boolean excludeSelf) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(rootElement, "rootElement");
        this.ensureRootProcessed(rootElement);
        return super.getClosestAnnotatedAncestorElement(element, rootElement, excludeSelf);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0017H\u0002R#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/OnDemandSuppressCache$PrecomputingVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "storage", "", "Lcom/intellij/psi/PsiElement;", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "computer", "Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache;", "<init>", "(Ljava/util/Map;Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache;)V", "getStorage", "()Ljava/util/Map;", "getComputer", "()Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache;", "visitKtElement", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "computeAnnotations", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "frontend"})
    @SourceDebugExtension(value={"SMAP\nOnDemandSuppressCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OnDemandSuppressCache.kt\norg/jetbrains/kotlin/resolve/diagnostics/OnDemandSuppressCache$PrecomputingVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n774#2:65\n865#2,2:66\n*S KotlinDebug\n*F\n+ 1 OnDemandSuppressCache.kt\norg/jetbrains/kotlin/resolve/diagnostics/OnDemandSuppressCache$PrecomputingVisitor\n*L\n49#1:65\n49#1:66,2\n*E\n"})
    private static final class PrecomputingVisitor
    extends KtTreeVisitorVoid {
        @NotNull
        private final Map<PsiElement, List<AnnotationDescriptor>> storage;
        @NotNull
        private final KotlinSuppressCache computer;

        public PrecomputingVisitor(@NotNull Map<PsiElement, List<AnnotationDescriptor>> storage, @NotNull KotlinSuppressCache computer) {
            Intrinsics.checkNotNullParameter(storage, "storage");
            Intrinsics.checkNotNullParameter(computer, "computer");
            this.storage = storage;
            this.computer = computer;
        }

        @NotNull
        public final Map<PsiElement, List<AnnotationDescriptor>> getStorage() {
            return this.storage;
        }

        @NotNull
        public final KotlinSuppressCache getComputer() {
            return this.computer;
        }

        @Override
        public void visitKtElement(@NotNull KtElement element) {
            Intrinsics.checkNotNullParameter(element, "element");
            super.visitKtElement(element);
            if (element instanceof KtAnnotated) {
                this.computeAnnotations((KtAnnotated)element);
            }
        }

        @Override
        public void visitKtFile(@NotNull KtFile file2) {
            Intrinsics.checkNotNullParameter(file2, "file");
            super.visitKtFile(file2);
            this.computeAnnotations(file2);
        }

        /*
         * WARNING - void declaration
         */
        private final void computeAnnotations(KtAnnotated element) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.computer.getSuppressionAnnotations(element);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                AnnotationDescriptor it = (AnnotationDescriptor)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getFqName(), StandardNames.FqNames.suppress)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List suppressions = (List)destination$iv$iv;
            if (!((Collection)suppressions).isEmpty()) {
                this.storage.put(element, suppressions);
            }
        }
    }
}

