/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.java.JavaVisibilities;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisibilityConverter;
import org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmVisibilityConverter;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "<init>", "()V", "convertPlatformVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "jvm-backend"})
public final class FirJvmVisibilityConverter
extends Fir2IrVisibilityConverter {
    @NotNull
    public static final FirJvmVisibilityConverter INSTANCE = new FirJvmVisibilityConverter();

    private FirJvmVisibilityConverter() {
    }

    @Override
    @NotNull
    protected DescriptorVisibility convertPlatformVisibility(@NotNull Visibility visibility) {
        DescriptorVisibility descriptorVisibility;
        Intrinsics.checkNotNullParameter(visibility, "visibility");
        Visibility visibility2 = visibility;
        if (Intrinsics.areEqual(visibility2, JavaVisibilities.PackageVisibility.INSTANCE)) {
            DescriptorVisibility descriptorVisibility2 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
            descriptorVisibility = descriptorVisibility2;
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility2, "PACKAGE_VISIBILITY");
        } else if (Intrinsics.areEqual(visibility2, JavaVisibilities.ProtectedStaticVisibility.INSTANCE)) {
            DescriptorVisibility descriptorVisibility3 = JavaDescriptorVisibilities.PROTECTED_STATIC_VISIBILITY;
            descriptorVisibility = descriptorVisibility3;
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility3, "PROTECTED_STATIC_VISIBILITY");
        } else if (Intrinsics.areEqual(visibility2, JavaVisibilities.ProtectedAndPackage.INSTANCE)) {
            DescriptorVisibility descriptorVisibility4 = JavaDescriptorVisibilities.PROTECTED_AND_PACKAGE;
            descriptorVisibility = descriptorVisibility4;
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility4, "PROTECTED_AND_PACKAGE");
        } else {
            throw new IllegalStateException(("Unknown visibility: " + visibility).toString());
        }
        return descriptorVisibility;
    }
}

