/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.loops.FloatingPointRangeHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfoHandler;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/FloatingPointRangeToHandler;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfoHandler;", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "", "<init>", "()V", "matchIterable", "", "expression", "build", "Lorg/jetbrains/kotlin/backend/common/lower/loops/FloatingPointRangeHeaderInfo;", "data", "scopeOwner", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nRangeContainsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RangeContainsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/FloatingPointRangeToHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,441:1\n1#2:442\n*E\n"})
public final class FloatingPointRangeToHandler
implements HeaderInfoHandler {
    @NotNull
    public static final FloatingPointRangeToHandler INSTANCE = new FloatingPointRangeToHandler();

    private FloatingPointRangeToHandler() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matchIterable(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
        IrValueParameter irValueParameter = CollectionsKt.singleOrNull(callee.getValueParameters());
        IrAnnotationContainer irAnnotationContainer = irValueParameter;
        if (irValueParameter == null) return false;
        IrType irType = irAnnotationContainer.getType();
        irAnnotationContainer = irType;
        if (irType == null) return false;
        IrAnnotationContainer irAnnotationContainer2 = irAnnotationContainer;
        boolean bl = false;
        if (!IrTypePredicatesKt.isFloat((IrType)irAnnotationContainer2)) {
            if (!IrTypePredicatesKt.isDouble((IrType)irAnnotationContainer2)) return false;
        }
        boolean bl2 = true;
        if (!bl2) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        IrValueParameter irValueParameter2 = callee.getExtensionReceiverParameter();
        IrAnnotationContainer irAnnotationContainer3 = irValueParameter2;
        if (irValueParameter2 == null) return false;
        IrType irType2 = irAnnotationContainer3.getType();
        irAnnotationContainer3 = irType2;
        if (irType2 == null) return false;
        IrAnnotationContainer irAnnotationContainer4 = irAnnotationContainer3;
        boolean bl4 = false;
        if (!IrTypePredicatesKt.isFloat((IrType)irAnnotationContainer4)) {
            if (!IrTypePredicatesKt.isDouble((IrType)irAnnotationContainer4)) return false;
        }
        boolean bl5 = true;
        if (!bl5) return false;
        boolean bl6 = true;
        if (!bl6) return false;
        if (!Intrinsics.areEqual(AdditionalIrUtilsKt.getKotlinFqName(callee), new FqName("kotlin.ranges." + OperatorNameConventions.RANGE_TO))) return false;
        return true;
    }

    @NotNull
    public FloatingPointRangeHeaderInfo build(@NotNull IrCall expression2, @Nullable Void data, @NotNull IrSymbol scopeOwner) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(scopeOwner, "scopeOwner");
        IrExpression irExpression = expression2.getExtensionReceiver();
        Intrinsics.checkNotNull(irExpression);
        IrExpression irExpression2 = expression2.getValueArgument(0);
        Intrinsics.checkNotNull(irExpression2);
        return new FloatingPointRangeHeaderInfo(irExpression, irExpression2);
    }
}

