/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlow;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.AuthenticationSelectionOption;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.ConsoleDisplayMode;
import org.keycloak.authentication.CredentialValidator;
import org.keycloak.authentication.DisplayTypeAuthenticatorFactory;
import org.keycloak.authentication.FlowStatus;
import org.keycloak.authentication.ForkFlowException;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticator;
import org.keycloak.credential.CredentialModel;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.util.AuthenticationFlowHistoryHelper;
import org.keycloak.services.util.AuthenticationFlowURLHelper;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;

public class DefaultAuthenticationFlow
implements AuthenticationFlow {
    private static final Logger logger = Logger.getLogger(DefaultAuthenticationFlow.class);
    private final List<AuthenticationExecutionModel> executions;
    private final AuthenticationProcessor processor;
    private final AuthenticationFlowModel flow;
    private boolean successful;
    private List<AuthenticationFlowException> afeList = new ArrayList<AuthenticationFlowException>();

    public DefaultAuthenticationFlow(AuthenticationProcessor processor, AuthenticationFlowModel flow) {
        this.processor = processor;
        this.flow = flow;
        this.executions = processor.getRealm().getAuthenticationExecutions(flow.getId());
    }

    protected boolean isProcessed(AuthenticationExecutionModel model) {
        if (model.isDisabled()) {
            return true;
        }
        CommonClientSessionModel.ExecutionStatus status = (CommonClientSessionModel.ExecutionStatus)this.processor.getAuthenticationSession().getExecutionStatus().get(model.getId());
        if (status == null) {
            return false;
        }
        return status == CommonClientSessionModel.ExecutionStatus.SUCCESS || status == CommonClientSessionModel.ExecutionStatus.SKIPPED || status == CommonClientSessionModel.ExecutionStatus.ATTEMPTED || status == CommonClientSessionModel.ExecutionStatus.SETUP_REQUIRED;
    }

    protected Authenticator createAuthenticator(AuthenticatorFactory factory) {
        Authenticator authenticator;
        String display = this.processor.getAuthenticationSession().getAuthNote("display");
        if (display == null) {
            return (Authenticator)factory.create(this.processor.getSession());
        }
        if (factory instanceof DisplayTypeAuthenticatorFactory && (authenticator = ((DisplayTypeAuthenticatorFactory)factory).createDisplay(this.processor.getSession(), display)) != null) {
            return authenticator;
        }
        if ("console".equalsIgnoreCase(display)) {
            this.processor.getAuthenticationSession().removeAuthNote("display");
            throw new AuthenticationFlowException(AuthenticationFlowError.DISPLAY_NOT_SUPPORTED, ConsoleDisplayMode.browserContinue((KeycloakSession)this.processor.getSession(), (String)this.processor.getRefreshUrl(true).toString()));
        }
        return (Authenticator)factory.create(this.processor.getSession());
    }

    public Response processAction(String actionExecution) {
        logger.debugv("processAction: {0}", (Object)actionExecution);
        if (actionExecution == null || actionExecution.isEmpty()) {
            throw new AuthenticationFlowException("action is not in current execution", AuthenticationFlowError.INTERNAL_ERROR);
        }
        AuthenticationExecutionModel model = this.processor.getRealm().getAuthenticationExecutionById(actionExecution);
        if (model == null) {
            throw new AuthenticationFlowException("action is not in current execution", AuthenticationFlowError.INTERNAL_ERROR);
        }
        MultivaluedMap inputData = this.processor.getRequest().getDecodedFormParameters();
        String authExecId = (String)inputData.getFirst((Object)"authenticationExecution");
        String selectedCredentialId = (String)inputData.getFirst((Object)"credentialId");
        if (inputData.containsKey((Object)"back")) {
            AuthenticationSessionModel authSession = this.processor.getAuthenticationSession();
            AuthenticationFlowHistoryHelper history = new AuthenticationFlowHistoryHelper(this.processor);
            if (history.hasAnyExecution()) {
                String executionId = history.pullExecution();
                AuthenticationExecutionModel lastActionExecution = this.processor.getRealm().getAuthenticationExecutionById(executionId);
                logger.debugf("Moving back to authentication execution '%s'", (Object)lastActionExecution.getAuthenticator());
                this.recursiveClearExecutionStatusOfAllExecutionsAfterOurExecutionInclusive(lastActionExecution);
                Response response = this.processSingleFlowExecutionModel(lastActionExecution, null, false);
                if (response == null) {
                    this.processor.getAuthenticationSession().removeAuthNote("current.authentication.execution");
                    return this.processFlow();
                }
                return response;
            }
            new AuthenticationFlowURLHelper(this.processor.getSession(), this.processor.getRealm(), this.processor.getUriInfo()).showPageExpired(authSession);
        }
        if (authExecId != null && !authExecId.isEmpty()) {
            Response response;
            List<AuthenticationSelectionOption> selectionOptions = this.createAuthenticationSelectionList(model);
            selectionOptions.stream().filter(authSelectionOption -> authExecId.equals(authSelectionOption.getAuthExecId())).findFirst().orElseThrow(() -> new AuthenticationFlowException("Requested authentication execution is not allowed", AuthenticationFlowError.INTERNAL_ERROR));
            model = this.processor.getRealm().getAuthenticationExecutionById(authExecId);
            if (model.isAuthenticatorFlow()) {
                new AuthenticationFlowHistoryHelper(this.processor).pushExecution(selectionOptions.get(0).getAuthExecId());
            }
            if ((response = this.processSingleFlowExecutionModel(model, selectedCredentialId, false)) == null) {
                this.processor.getAuthenticationSession().removeAuthNote("current.authentication.execution");
                this.checkAndValidateParentFlow(model);
                return this.processFlow();
            }
            return response;
        }
        if (model.isAuthenticatorFlow()) {
            logger.debug((Object)"execution is flow");
            AuthenticationFlow authenticationFlow = this.processor.createFlowExecution(model.getFlowId(), model);
            Response flowChallenge = authenticationFlow.processAction(actionExecution);
            if (flowChallenge == null) {
                this.checkAndValidateParentFlow(model);
                return this.processFlow();
            }
            this.processor.getAuthenticationSession().setExecutionStatus(model.getId(), CommonClientSessionModel.ExecutionStatus.CHALLENGED);
            return flowChallenge;
        }
        AuthenticatorFactory factory = this.getAuthenticatorFactory(model);
        Authenticator authenticator = this.createAuthenticator(factory);
        AuthenticationProcessor.Result result = this.processor.createAuthenticatorContext(model, authenticator, this.executions);
        result.setAuthenticationSelections(this.createAuthenticationSelectionList(model));
        result.setSelectedCredentialId(selectedCredentialId);
        logger.debugv("action: {0}", (Object)model.getAuthenticator());
        authenticator.action((AuthenticationFlowContext)result);
        Response response = this.processResult(result, true);
        if (response == null) {
            this.processor.getAuthenticationSession().removeAuthNote("current.authentication.execution");
            this.checkAndValidateParentFlow(model);
            return this.processFlow();
        }
        return response;
    }

    private void recursiveClearExecutionStatusOfAllExecutionsAfterOurExecutionInclusive(AuthenticationExecutionModel targetExecution) {
        RealmModel realm = this.processor.getRealm();
        AuthenticationSessionModel authSession = this.processor.getAuthenticationSession();
        authSession.getExecutionStatus().remove(targetExecution.getId());
        this.recursiveClearExecutionStatusOfAllSiblings(targetExecution);
        while (true) {
            AuthenticationFlowModel parentFlow;
            if ((parentFlow = realm.getAuthenticationFlowById(targetExecution.getParentFlow())).isTopLevel()) {
                return;
            }
            AuthenticationExecutionModel flowExecution = realm.getAuthenticationExecutionByFlowId(parentFlow.getId());
            if (!authSession.getExecutionStatus().containsKey(flowExecution.getId())) break;
            authSession.getExecutionStatus().remove(flowExecution.getId());
            this.recursiveClearExecutionStatusOfAllSiblings(flowExecution);
            targetExecution = flowExecution;
        }
    }

    private void recursiveClearExecutionStatusOfAllSiblings(AuthenticationExecutionModel targetExecution) {
        RealmModel realm = this.processor.getRealm();
        AuthenticationFlowModel parentFlow = realm.getAuthenticationFlowById(targetExecution.getParentFlow());
        logger.debugf("Recursively clearing executions in flow '%s', which are after execution '%s'", (Object)parentFlow.getAlias(), (Object)targetExecution.getId());
        List siblingExecutions = realm.getAuthenticationExecutions(parentFlow.getId());
        int index = siblingExecutions.indexOf(targetExecution);
        siblingExecutions = siblingExecutions.subList(index + 1, siblingExecutions.size());
        for (AuthenticationExecutionModel authExec : siblingExecutions) {
            this.recursiveClearExecutionStatus(authExec);
        }
    }

    private void recursiveClearExecutionStatus(AuthenticationExecutionModel execution) {
        this.processor.getAuthenticationSession().getExecutionStatus().remove(execution.getId());
        if (execution.isAuthenticatorFlow()) {
            this.processor.getRealm().getAuthenticationExecutions(execution.getFlowId()).forEach(this::recursiveClearExecutionStatus);
        }
    }

    private void checkAndValidateParentFlow(AuthenticationExecutionModel model) {
        block2: {
            AuthenticationExecutionModel parentFlowModel;
            block4: {
                List localExecutions;
                block3: {
                    localExecutions = this.processor.getRealm().getAuthenticationExecutions(model.getParentFlow());
                    parentFlowModel = this.processor.getRealm().getAuthenticationExecutionByFlowId(model.getParentFlow());
                    if (parentFlowModel == null) break block2;
                    if (!model.isRequired()) break block3;
                    if (localExecutions.stream().allMatch(this.processor::isSuccessful)) break block4;
                }
                if (!model.isAlternative()) break block2;
                if (!localExecutions.stream().anyMatch(this.processor::isSuccessful)) break block2;
            }
            this.processor.getAuthenticationSession().setExecutionStatus(parentFlowModel.getId(), CommonClientSessionModel.ExecutionStatus.SUCCESS);
        }
    }

    public Response processFlow() {
        logger.debug((Object)"processFlow");
        ArrayList<AuthenticationExecutionModel> requiredList = new ArrayList<AuthenticationExecutionModel>();
        ArrayList<AuthenticationExecutionModel> alternativeList = new ArrayList<AuthenticationExecutionModel>();
        for (AuthenticationExecutionModel execution : this.executions) {
            if (this.isConditionalAuthenticator(execution)) continue;
            if (execution.isRequired() || execution.isConditional()) {
                requiredList.add(execution);
                continue;
            }
            if (!execution.isAlternative()) continue;
            alternativeList.add(execution);
        }
        boolean requiredElementsSuccessful = true;
        ListIterator requiredIListIterator = requiredList.listIterator();
        while (requiredIListIterator.hasNext()) {
            AuthenticationExecutionModel required = (AuthenticationExecutionModel)requiredIListIterator.next();
            if (required.isConditional() && this.isConditionalSubflowDisabled(required)) {
                requiredIListIterator.remove();
                continue;
            }
            Response response = this.processSingleFlowExecutionModel(required, null, true);
            requiredElementsSuccessful &= this.processor.isSuccessful(required) || this.isSetupRequired(required);
            if (response == null) continue;
            return response;
        }
        if (requiredList.isEmpty()) {
            if (alternativeList.stream().anyMatch(alternative -> this.processor.isSuccessful((AuthenticationExecutionModel)alternative) || this.isSetupRequired((AuthenticationExecutionModel)alternative))) {
                this.successful = true;
                return null;
            }
            for (AuthenticationExecutionModel alternative2 : alternativeList) {
                try {
                    Response response = this.processSingleFlowExecutionModel(alternative2, null, true);
                    if (response != null) {
                        return response;
                    }
                    if (!this.processor.isSuccessful(alternative2) && !this.isSetupRequired(alternative2)) continue;
                    this.successful = true;
                    return null;
                }
                catch (AuthenticationFlowException afe) {
                    this.afeList.add(afe);
                    this.processor.getAuthenticationSession().setExecutionStatus(alternative2.getId(), CommonClientSessionModel.ExecutionStatus.ATTEMPTED);
                }
            }
        } else {
            this.successful = requiredElementsSuccessful;
        }
        return null;
    }

    private boolean isConditionalSubflowDisabled(AuthenticationExecutionModel model) {
        if (model == null || !model.isAuthenticatorFlow() || !model.isConditional()) {
            return false;
        }
        List modelList = this.processor.getRealm().getAuthenticationExecutions(model.getFlowId());
        List conditionalAuthenticatorList = modelList.stream().filter(this::isConditionalAuthenticator).collect(Collectors.toList());
        return conditionalAuthenticatorList.isEmpty() || conditionalAuthenticatorList.stream().anyMatch(m -> this.conditionalNotMatched((AuthenticationExecutionModel)m, modelList));
    }

    private boolean isConditionalAuthenticator(AuthenticationExecutionModel model) {
        return !model.isAuthenticatorFlow() && model.getAuthenticator() != null && this.createAuthenticator(this.getAuthenticatorFactory(model)) instanceof ConditionalAuthenticator;
    }

    private AuthenticatorFactory getAuthenticatorFactory(AuthenticationExecutionModel model) {
        AuthenticatorFactory factory = (AuthenticatorFactory)this.processor.getSession().getKeycloakSessionFactory().getProviderFactory(Authenticator.class, model.getAuthenticator());
        if (factory == null) {
            throw new RuntimeException("Unable to find factory for AuthenticatorFactory: " + model.getAuthenticator() + " did you forget to declare it in a META-INF/services file?");
        }
        return factory;
    }

    private boolean conditionalNotMatched(AuthenticationExecutionModel model, List<AuthenticationExecutionModel> executionList) {
        AuthenticationProcessor.Result context;
        AuthenticatorFactory factory = this.getAuthenticatorFactory(model);
        ConditionalAuthenticator authenticator = (ConditionalAuthenticator)this.createAuthenticator(factory);
        return !authenticator.matchCondition(context = this.processor.createAuthenticatorContext(model, authenticator, executionList));
    }

    private boolean isSetupRequired(AuthenticationExecutionModel model) {
        return CommonClientSessionModel.ExecutionStatus.SETUP_REQUIRED.equals(this.processor.getAuthenticationSession().getExecutionStatus().get(model.getId()));
    }

    private Response processSingleFlowExecutionModel(AuthenticationExecutionModel model, String selectedCredentialId, boolean calledFromFlow) {
        logger.debugv("check execution: {0} requirement: {1}", (Object)model.getAuthenticator(), (Object)model.getRequirement());
        if (this.isProcessed(model)) {
            logger.debug((Object)"execution is processed");
            return null;
        }
        if (model.isAuthenticatorFlow()) {
            logger.debug((Object)"execution is flow");
            AuthenticationFlow authenticationFlow = this.processor.createFlowExecution(model.getFlowId(), model);
            Response flowChallenge = authenticationFlow.processFlow();
            if (flowChallenge == null) {
                if (authenticationFlow.isSuccessful()) {
                    this.processor.getAuthenticationSession().setExecutionStatus(model.getId(), CommonClientSessionModel.ExecutionStatus.SUCCESS);
                } else {
                    this.processor.getAuthenticationSession().setExecutionStatus(model.getId(), CommonClientSessionModel.ExecutionStatus.FAILED);
                }
                return null;
            }
            this.processor.getAuthenticationSession().setExecutionStatus(model.getId(), CommonClientSessionModel.ExecutionStatus.CHALLENGED);
            return flowChallenge;
        }
        AuthenticatorFactory factory = this.getAuthenticatorFactory(model);
        Authenticator authenticator = this.createAuthenticator(factory);
        logger.debugv("authenticator: {0}", (Object)factory.getId());
        UserModel authUser = this.processor.getAuthenticationSession().getAuthenticatedUser();
        List<AuthenticationSelectionOption> selectionOptions = this.createAuthenticationSelectionList(model);
        if (!selectionOptions.isEmpty() && calledFromFlow) {
            List finalSelectionOptions = selectionOptions.stream().filter(aso -> !aso.getAuthenticationExecution().isAuthenticatorFlow() && !this.isProcessed(aso.getAuthenticationExecution())).collect(Collectors.toList());
            if (finalSelectionOptions.isEmpty()) {
                return null;
            }
            model = ((AuthenticationSelectionOption)finalSelectionOptions.get(0)).getAuthenticationExecution();
            factory = (AuthenticatorFactory)this.processor.getSession().getKeycloakSessionFactory().getProviderFactory(Authenticator.class, model.getAuthenticator());
            if (factory == null) {
                throw new RuntimeException("Unable to find factory for AuthenticatorFactory: " + model.getAuthenticator() + " did you forget to declare it in a META-INF/services file?");
            }
            authenticator = this.createAuthenticator(factory);
        }
        AuthenticationProcessor.Result context = this.processor.createAuthenticatorContext(model, authenticator, this.executions);
        context.setAuthenticationSelections(selectionOptions);
        if (selectedCredentialId != null) {
            context.setSelectedCredentialId(selectedCredentialId);
        } else if (!selectionOptions.isEmpty()) {
            context.setSelectedCredentialId(selectionOptions.get(0).getCredentialId());
        }
        if (authenticator.requiresUser()) {
            if (authUser == null) {
                throw new AuthenticationFlowException("authenticator: " + factory.getId(), AuthenticationFlowError.UNKNOWN_USER);
            }
            if (!authenticator.configuredFor(this.processor.getSession(), this.processor.getRealm(), authUser)) {
                if (factory.isUserSetupAllowed() && model.isRequired() && authenticator.areRequiredActionsEnabled(this.processor.getSession(), this.processor.getRealm())) {
                    logger.debugv("authenticator SETUP_REQUIRED: {0}", (Object)factory.getId());
                    this.processor.getAuthenticationSession().setExecutionStatus(model.getId(), CommonClientSessionModel.ExecutionStatus.SETUP_REQUIRED);
                    authenticator.setRequiredActions(this.processor.getSession(), this.processor.getRealm(), this.processor.getAuthenticationSession().getAuthenticatedUser());
                    return null;
                }
                throw new AuthenticationFlowException("authenticator: " + factory.getId(), AuthenticationFlowError.CREDENTIAL_SETUP_REQUIRED);
            }
        }
        logger.debugv("invoke authenticator.authenticate: {0}", (Object)factory.getId());
        authenticator.authenticate((AuthenticationFlowContext)context);
        return this.processResult(context, false);
    }

    private List<AuthenticationSelectionOption> createAuthenticationSelectionList(AuthenticationExecutionModel model) {
        ArrayList<AuthenticationSelectionOption> authenticationSelectionList = new ArrayList<AuthenticationSelectionOption>();
        if (this.processor.getAuthenticationSession() != null) {
            Authenticator authenticator;
            HashMap<String, AuthenticationExecutionModel> typeAuthExecMap = new HashMap<String, AuthenticationExecutionModel>();
            ArrayList<AuthenticationExecutionModel> nonCredentialExecutions = new ArrayList<AuthenticationExecutionModel>();
            if (model.isAlternative()) {
                List alternativeExecutions = this.processor.getRealm().getAuthenticationExecutions(model.getParentFlow()).stream().filter(AuthenticationExecutionModel::isAlternative).collect(Collectors.toList());
                for (AuthenticationExecutionModel execution : alternativeExecutions) {
                    if (!execution.isAuthenticatorFlow()) {
                        Authenticator localAuthenticator = (Authenticator)this.processor.getSession().getProvider(Authenticator.class, execution.getAuthenticator());
                        if (!(localAuthenticator instanceof CredentialValidator)) {
                            nonCredentialExecutions.add(execution);
                            continue;
                        }
                        CredentialValidator cv = (CredentialValidator)localAuthenticator;
                        typeAuthExecMap.put(cv.getType(this.processor.getSession()), execution);
                        continue;
                    }
                    nonCredentialExecutions.add(execution);
                }
            } else if (model.isRequired() && !model.isAuthenticatorFlow() && (authenticator = (Authenticator)this.processor.getSession().getProvider(Authenticator.class, model.getAuthenticator())) instanceof CredentialValidator) {
                typeAuthExecMap.put(((CredentialValidator)authenticator).getType(this.processor.getSession()), model);
            }
            if (this.processor.getAuthenticationSession().getAuthenticatedUser() != null) {
                List credentials = this.processor.getSession().userCredentialManager().getStoredCredentials(this.processor.getRealm(), this.processor.getAuthenticationSession().getAuthenticatedUser()).stream().filter(credential -> typeAuthExecMap.containsKey(credential.getType())).collect(Collectors.toList());
                MultivaluedHashMap countAuthSelections = new MultivaluedHashMap();
                for (CredentialModel credential2 : credentials) {
                    AuthenticationSelectionOption authSel = new AuthenticationSelectionOption((AuthenticationExecutionModel)typeAuthExecMap.get(credential2.getType()), credential2);
                    authenticationSelectionList.add(authSel);
                    countAuthSelections.add((Object)credential2.getType(), (Object)authSel);
                }
                for (Map.Entry entry : countAuthSelections.entrySet()) {
                    if (((List)entry.getValue()).size() != 1) continue;
                    ((AuthenticationSelectionOption)((List)entry.getValue()).get(0)).setShowCredentialName(false);
                }
                if (countAuthSelections.keySet().size() == 1 && nonCredentialExecutions.isEmpty()) {
                    for (AuthenticationSelectionOption so : authenticationSelectionList) {
                        so.setShowCredentialType(false);
                    }
                }
            }
            for (AuthenticationExecutionModel exec : nonCredentialExecutions) {
                if (exec.isAuthenticatorFlow()) {
                    authenticationSelectionList.add(new AuthenticationSelectionOption(exec, this.processor.getRealm().getAuthenticationFlowById(exec.getFlowId())));
                    continue;
                }
                authenticationSelectionList.add(new AuthenticationSelectionOption(exec));
            }
        }
        return authenticationSelectionList;
    }

    public Response processResult(AuthenticationProcessor.Result result, boolean isAction) {
        AuthenticationExecutionModel execution = result.getExecution();
        FlowStatus status = result.getStatus();
        switch (status) {
            case SUCCESS: {
                logger.debugv("authenticator SUCCESS: {0}", (Object)execution.getAuthenticator());
                if (isAction) {
                    new AuthenticationFlowHistoryHelper(this.processor).pushExecution(execution.getId());
                }
                this.processor.getAuthenticationSession().setExecutionStatus(execution.getId(), CommonClientSessionModel.ExecutionStatus.SUCCESS);
                return null;
            }
            case FAILED: {
                logger.debugv("authenticator FAILED: {0}", (Object)execution.getAuthenticator());
                this.processor.logFailure();
                this.processor.getAuthenticationSession().setExecutionStatus(execution.getId(), CommonClientSessionModel.ExecutionStatus.FAILED);
                if (result.getChallenge() != null) {
                    return this.sendChallenge(result, execution);
                }
                throw new AuthenticationFlowException(result.getError());
            }
            case FORK: {
                logger.debugv("reset browser login from authenticator: {0}", (Object)execution.getAuthenticator());
                this.processor.getAuthenticationSession().setAuthNote("current.authentication.execution", execution.getId());
                throw new ForkFlowException(result.getSuccessMessage(), result.getErrorMessage());
            }
            case FORCE_CHALLENGE: 
            case CHALLENGE: {
                this.processor.getAuthenticationSession().setExecutionStatus(execution.getId(), CommonClientSessionModel.ExecutionStatus.CHALLENGED);
                return this.sendChallenge(result, execution);
            }
            case FAILURE_CHALLENGE: {
                logger.debugv("authenticator FAILURE_CHALLENGE: {0}", (Object)execution.getAuthenticator());
                this.processor.logFailure();
                this.processor.getAuthenticationSession().setExecutionStatus(execution.getId(), CommonClientSessionModel.ExecutionStatus.CHALLENGED);
                return this.sendChallenge(result, execution);
            }
            case ATTEMPTED: {
                logger.debugv("authenticator ATTEMPTED: {0}", (Object)execution.getAuthenticator());
                if (execution.isRequired()) {
                    throw new AuthenticationFlowException(AuthenticationFlowError.INVALID_CREDENTIALS);
                }
                this.processor.getAuthenticationSession().setExecutionStatus(execution.getId(), CommonClientSessionModel.ExecutionStatus.ATTEMPTED);
                return null;
            }
            case FLOW_RESET: {
                this.processor.resetFlow();
                return this.processor.authenticate();
            }
        }
        logger.debugv("authenticator INTERNAL_ERROR: {0}", (Object)execution.getAuthenticator());
        ServicesLogger.LOGGER.unknownResultStatus();
        throw new AuthenticationFlowException(AuthenticationFlowError.INTERNAL_ERROR);
    }

    public Response sendChallenge(AuthenticationProcessor.Result result, AuthenticationExecutionModel execution) {
        this.processor.getAuthenticationSession().setAuthNote("current.authentication.execution", execution.getId());
        return result.getChallenge();
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public List<AuthenticationFlowException> getFlowExceptions() {
        return this.afeList;
    }
}

