/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.sasl.RealmCallback;
import org.jboss.as.core.security.RealmRole;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.core.security.SubjectUserInfo;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.AuthorizingCallbackHandler;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.security.DigestCredential;
import org.jboss.as.security.logging.SecurityLogger;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.callback.ObjectCallback;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.sasl.util.UsernamePasswordHashUtil;

public class RealmDirectLoginModule
extends UsernamePasswordLoginModule {
    private static final String DEFAULT_REALM = "ApplicationRealm";
    private static final String REALM_OPTION = "realm";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"realm"};
    private SecurityRealm securityRealm;
    private AuthMechanism chosenMech;
    private ValidationMode validationMode;
    private UsernamePasswordHashUtil hashUtil;
    private AuthorizingCallbackHandler callbackHandler;
    private DigestCredential digestCredential;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.addValidOptions(ALL_VALID_OPTIONS);
        super.initialize(subject, callbackHandler, sharedState, options);
        String realm = options.containsKey(REALM_OPTION) ? (String)options.get(REALM_OPTION) : DEFAULT_REALM;
        ServiceController controller = RealmDirectLoginModule.currentServiceContainer().getService(SecurityRealm.ServiceUtil.createServiceName((String)realm));
        if (controller != null) {
            this.securityRealm = (SecurityRealm)controller.getValue();
        }
        if (this.securityRealm == null) {
            throw SecurityLogger.ROOT_LOGGER.realmNotFound(realm);
        }
        Set authMechs = this.securityRealm.getSupportedAuthenticationMechanisms();
        this.chosenMech = authMechs.contains(AuthMechanism.DIGEST) ? AuthMechanism.DIGEST : (authMechs.contains(AuthMechanism.PLAIN) ? AuthMechanism.PLAIN : (AuthMechanism)authMechs.iterator().next());
        if (this.chosenMech == AuthMechanism.DIGEST || this.chosenMech == AuthMechanism.PLAIN) {
            Map mechOpts = this.securityRealm.getMechanismConfig(this.chosenMech);
            if (mechOpts.containsKey("org.jboss.as.domain.management.verify_password_callback_supported") && Boolean.parseBoolean((String)mechOpts.get("org.jboss.as.domain.management.verify_password_callback_supported"))) {
                this.validationMode = ValidationMode.VALIDATION;
            } else if (this.chosenMech == AuthMechanism.DIGEST) {
                if (mechOpts.containsKey("org.jboss.as.domain.management.digest.plain_text") && Boolean.parseBoolean((String)mechOpts.get("org.jboss.as.domain.management.digest.plain_text"))) {
                    this.validationMode = ValidationMode.PASSWORD;
                } else {
                    this.validationMode = ValidationMode.DIGEST;
                    try {
                        this.hashUtil = new UsernamePasswordHashUtil();
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new IllegalStateException(e);
                    }
                }
            } else {
                this.validationMode = ValidationMode.PASSWORD;
            }
        } else {
            this.validationMode = ValidationMode.NONE;
        }
    }

    public boolean login() throws LoginException {
        this.digestCredential = this.getDigestCredential();
        if (this.digestCredential != null && this.validationMode == ValidationMode.VALIDATION) {
            this.validationMode = ValidationMode.DIGEST;
        }
        return super.login();
    }

    protected String createPasswordHash(String username, String password, String digestOption) throws LoginException {
        throw new UnsupportedOperationException();
    }

    protected String getUsersPassword() throws LoginException {
        if (this.validationMode == ValidationMode.VALIDATION) {
            return null;
        }
        RealmCallback rcb = new RealmCallback("Realm", this.securityRealm.getName());
        NameCallback ncb = new NameCallback("User Name", this.getUsername());
        String password = null;
        switch (this.validationMode) {
            case DIGEST: {
                CredentialCallback cc = new CredentialCallback(PasswordCredential.class, "digest-md5");
                this.handle(new Callback[]{rcb, ncb, cc});
                PasswordCredential passwordCredential = (PasswordCredential)cc.getCredential();
                DigestPassword digestPassword = (DigestPassword)passwordCredential.getPassword(DigestPassword.class);
                password = ByteIterator.ofBytes((byte[])digestPassword.getDigest()).hexEncode().drainToString();
                break;
            }
            case PASSWORD: {
                PasswordCallback pcb = new PasswordCallback("Password", false);
                this.handle(new Callback[]{rcb, ncb, pcb});
                password = String.valueOf(pcb.getPassword());
            }
        }
        return password;
    }

    private void handle(Callback[] callbacks) throws LoginException {
        try {
            AuthorizingCallbackHandler callbackHandler = this.getCallbackHandler();
            callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            throw SecurityLogger.ROOT_LOGGER.failureCallingSecurityRealm(e.getMessage());
        }
        catch (UnsupportedCallbackException e) {
            throw SecurityLogger.ROOT_LOGGER.failureCallingSecurityRealm(e.getMessage());
        }
    }

    private AuthorizingCallbackHandler getCallbackHandler() {
        if (this.callbackHandler == null) {
            this.callbackHandler = this.securityRealm.getAuthorizingCallbackHandler(this.chosenMech);
        }
        return this.callbackHandler;
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        if (this.digestCredential != null) {
            return this.digestCredential.verifyHA1(expectedPassword.getBytes(StandardCharsets.UTF_8));
        }
        switch (this.validationMode) {
            case DIGEST: {
                String inputHashed = this.hashUtil.generateHashedHexURP(this.getUsername(), this.securityRealm.getName(), inputPassword.toCharArray());
                return expectedPassword.equals(inputHashed);
            }
            case PASSWORD: {
                return expectedPassword.equals(inputPassword);
            }
            case VALIDATION: {
                RealmCallback rcb = new RealmCallback("Realm", this.securityRealm.getName());
                NameCallback ncb = new NameCallback("User Name", this.getUsername());
                EvidenceVerifyCallback evc = new EvidenceVerifyCallback((Evidence)new PasswordGuessEvidence(inputPassword.toCharArray()));
                try {
                    this.handle(new Callback[]{rcb, ncb, evc});
                    return evc.isVerified();
                }
                catch (LoginException e) {
                    return false;
                }
            }
        }
        return false;
    }

    private DigestCredential getDigestCredential() {
        ObjectCallback oc = new ObjectCallback("Credential:");
        try {
            ((UsernamePasswordLoginModule)this).callbackHandler.handle(new Callback[]{oc});
        }
        catch (IOException | UnsupportedCallbackException e) {
            return null;
        }
        Object credential = oc.getCredential();
        if (credential instanceof DigestCredential) {
            return (DigestCredential)credential;
        }
        return null;
    }

    protected Group[] getRoleSets() throws LoginException {
        HashSet<RealmUser> principalCol = new HashSet<RealmUser>();
        principalCol.add(new RealmUser(this.getUsername()));
        try {
            AuthorizingCallbackHandler callbackHandler = this.getCallbackHandler();
            SubjectUserInfo sui = callbackHandler.createSubjectUserInfo(principalCol);
            SimpleGroup sg = new SimpleGroup("Roles");
            Set<RealmRole> roles = sui.getSubject().getPrincipals(RealmRole.class);
            for (RealmRole current : roles) {
                sg.addMember(this.createIdentity(current.getName()));
            }
            return new Group[]{sg};
        }
        catch (Exception e) {
            throw SecurityLogger.ROOT_LOGGER.failureCallingSecurityRealm(e.getMessage());
        }
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }

    private static enum ValidationMode {
        DIGEST,
        PASSWORD,
        VALIDATION,
        NONE;

    }
}

