/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.interceptors.InterceptorClassDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.metadata.javaee.spec.LifecycleCallbackMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;

public class DescriptorEnvironmentLifecycleMethodProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        DeploymentDescriptorEnvironment environment = (DeploymentDescriptorEnvironment)deploymentUnit.getAttachment(Attachments.MODULE_DEPLOYMENT_DESCRIPTOR_ENVIRONMENT);
        if (environment != null) {
            DescriptorEnvironmentLifecycleMethodProcessor.handleMethods(environment, eeModuleDescription, null);
        }
    }

    public static void handleMethods(DeploymentDescriptorEnvironment env, EEModuleDescription eeModuleDescription, String defaultClassName) throws DeploymentUnitProcessingException {
        LifecycleCallbacksMetaData preDestroys;
        RemoteEnvironment environment = env.getEnvironment();
        LifecycleCallbacksMetaData postConstructs = environment.getPostConstructs();
        if (postConstructs != null) {
            for (LifecycleCallbackMetaData postConstruct : postConstructs) {
                String className = postConstruct.getClassName();
                if (className == null || className.isEmpty()) {
                    if (defaultClassName == null) continue;
                    className = defaultClassName;
                }
                InterceptorClassDescription.Builder builder = InterceptorClassDescription.builder();
                String methodName = postConstruct.getMethodName();
                MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)methodName, (Class[])new Class[0]);
                builder.setPostConstruct(methodIdentifier);
                eeModuleDescription.addInterceptorMethodOverride(className, builder.build());
            }
        }
        if ((preDestroys = environment.getPreDestroys()) != null) {
            for (LifecycleCallbackMetaData preDestroy : preDestroys) {
                String className = preDestroy.getClassName();
                if (className == null || className.isEmpty()) {
                    if (defaultClassName == null) continue;
                    className = defaultClassName;
                }
                InterceptorClassDescription.Builder builder = InterceptorClassDescription.builder();
                String methodName = preDestroy.getMethodName();
                MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)methodName, (Class[])new Class[0]);
                builder.setPreDestroy(methodIdentifier);
                eeModuleDescription.addInterceptorMethodOverride(className, builder.build());
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

