/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.user;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.policy.provider.user.UserPolicyProvider;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;
import org.keycloak.util.JsonSerialization;

public class UserPolicyProviderFactory
implements PolicyProviderFactory<UserPolicyRepresentation> {
    private UserPolicyProvider provider = new UserPolicyProvider(this::toRepresentation);

    public String getName() {
        return "User";
    }

    public String getGroup() {
        return "Identity Based";
    }

    public PolicyProvider create(AuthorizationProvider authorization) {
        return this.provider;
    }

    public PolicyProvider create(KeycloakSession session) {
        return null;
    }

    public UserPolicyRepresentation toRepresentation(Policy policy, AuthorizationProvider authorization) {
        UserPolicyRepresentation representation = new UserPolicyRepresentation();
        try {
            representation.setUsers((Set)JsonSerialization.readValue((String)((String)policy.getConfig().get("users")), Set.class));
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to deserialize roles", cause);
        }
        return representation;
    }

    public Class<UserPolicyRepresentation> getRepresentationType() {
        return UserPolicyRepresentation.class;
    }

    public void onCreate(Policy policy, UserPolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updateUsers(policy, representation, authorization);
    }

    public void onUpdate(Policy policy, UserPolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updateUsers(policy, representation, authorization);
    }

    public void onImport(Policy policy, PolicyRepresentation representation, AuthorizationProvider authorization) {
        try {
            this.updateUsers(policy, authorization, (Set)JsonSerialization.readValue((String)((String)representation.getConfig().get("users")), Set.class));
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to deserialize users during import", cause);
        }
    }

    public void onExport(Policy policy, PolicyRepresentation representation, AuthorizationProvider authorizationProvider) {
        UserPolicyRepresentation userRep = this.toRepresentation(policy, authorizationProvider);
        HashMap<String, String> config = new HashMap<String, String>();
        try {
            UserProvider userProvider = authorizationProvider.getKeycloakSession().users();
            RealmModel realm = authorizationProvider.getRealm();
            config.put("users", JsonSerialization.writeValueAsString(userRep.getUsers().stream().map(id -> userProvider.getUserById(id, realm).getUsername()).collect(Collectors.toList())));
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to export user policy [" + policy.getName() + "]", cause);
        }
        representation.setConfig(config);
    }

    private void updateUsers(Policy policy, UserPolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updateUsers(policy, authorization, representation.getUsers());
    }

    private void updateUsers(Policy policy, AuthorizationProvider authorization, Set<String> users) {
        KeycloakSession session = authorization.getKeycloakSession();
        RealmModel realm = authorization.getRealm();
        UserProvider userProvider = session.users();
        HashSet<String> updatedUsers = new HashSet<String>();
        if (users != null) {
            for (String userId : users) {
                UserModel user = null;
                try {
                    user = userProvider.getUserByUsername(userId, realm);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (user == null) {
                    user = userProvider.getUserById(userId, realm);
                }
                if (user == null) {
                    throw new RuntimeException("Error while updating policy [" + policy.getName() + "]. User [" + userId + "] could not be found.");
                }
                updatedUsers.add(user.getId());
            }
        }
        try {
            policy.putConfig("users", JsonSerialization.writeValueAsString(updatedUsers));
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to serialize users", cause);
        }
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(event -> {
            if (event instanceof UserModel.UserRemovedEvent) {
                KeycloakSession keycloakSession = ((UserModel.UserRemovedEvent)event).getKeycloakSession();
                AuthorizationProvider provider = (AuthorizationProvider)keycloakSession.getProvider(AuthorizationProvider.class);
                StoreFactory storeFactory = provider.getStoreFactory();
                PolicyStore policyStore = storeFactory.getPolicyStore();
                UserModel removedUser = ((UserModel.UserRemovedEvent)event).getUser();
                RealmModel realm = ((UserModel.UserRemovedEvent)event).getRealm();
                ResourceServerStore resourceServerStore = storeFactory.getResourceServerStore();
                realm.getClients().forEach(clientModel -> {
                    ResourceServer resourceServer = resourceServerStore.findById(clientModel.getId());
                    if (resourceServer != null) {
                        policyStore.findByType(this.getId(), resourceServer.getId()).forEach(policy -> {
                            ArrayList<String> users = new ArrayList<String>();
                            for (String userId : UserPolicyProviderFactory.getUsers(policy)) {
                                if (userId.equals(removedUser.getId())) continue;
                                users.add(userId);
                            }
                            try {
                                if (users.isEmpty()) {
                                    policyStore.delete(policy.getId());
                                } else {
                                    policy.putConfig("users", JsonSerialization.writeValueAsString(users));
                                }
                            }
                            catch (IOException e) {
                                throw new RuntimeException("Error while synchronizing users with policy [" + policy.getName() + "].", e);
                            }
                        });
                    }
                });
            }
        });
    }

    public void close() {
    }

    public String getId() {
        return "user";
    }

    static String[] getUsers(Policy policy) {
        String users = (String)policy.getConfig().get("users");
        if (users != null) {
            try {
                return (String[])JsonSerialization.readValue((byte[])users.getBytes(), String[].class);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not parse users [" + users + "] from policy config [" + policy.getName() + ".", e);
            }
        }
        return new String[0];
    }
}

