/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.microprofile.health.MicroProfileHealthExtension;
import org.wildfly.extension.microprofile.health.MicroProfileHealthSubsystemDefinition;

public class MicroProfileHealthTransformers
implements ExtensionTransformerRegistration {
    public String getSubsystemName() {
        return "microprofile-health-smallrye";
    }

    public void registerTransformers(SubsystemTransformerRegistration registration) {
        ChainedTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)registration.getCurrentSubsystemVersion());
        this.registerTransformers_WildFly_17(builder.createBuilder(MicroProfileHealthExtension.VERSION_2_0_0, MicroProfileHealthExtension.VERSION_1_0_0));
        builder.buildAndRegister(registration, (ModelVersion[][])new ModelVersion[][]{{MicroProfileHealthExtension.VERSION_1_0_0}});
    }

    private void registerTransformers_WildFly_17(ResourceTransformationDescriptionBuilder subsystem) {
        MicroProfileHealthTransformers.rejectDefinedAttributeWithDefaultValue(subsystem, MicroProfileHealthSubsystemDefinition.EMPTY_LIVENESS_CHECKS_STATUS);
        MicroProfileHealthTransformers.rejectDefinedAttributeWithDefaultValue(subsystem, MicroProfileHealthSubsystemDefinition.EMPTY_READINESS_CHECKS_STATUS);
    }

    private static void rejectDefinedAttributeWithDefaultValue(ResourceTransformationDescriptionBuilder builder, AttributeDefinition ... attrs) {
        for (AttributeDefinition attr : attrs) {
            ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{attr.getDefaultValue()}), new AttributeDefinition[]{attr})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{attr});
        }
    }
}

