/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.util;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.function.CloseableSupplier;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Deprecated
public class PersistenceManagerCloseableSupplier<K, V>
implements CloseableSupplier<MarshalledEntry<K, V>> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final boolean trace = log.isTraceEnabled();
    private final Executor executor;
    private final AdvancedCacheLoader<K, V> loader;
    private final Predicate<? super K> filter;
    private final boolean fetchValue;
    private final boolean fetchMetadata;
    private final BlockingQueue<MarshalledEntry<K, V>> queue;
    private final long timeout;
    private final TimeUnit unit;
    private final Lock closeLock = new ReentrantLock();
    private final Condition closeCondition = this.closeLock.newCondition();
    private boolean closed = false;
    private final AtomicReference<AdvancedCacheLoader.CacheLoaderTask<K, V>> taskRef = new AtomicReference();

    public PersistenceManagerCloseableSupplier(Executor executor, AdvancedCacheLoader<K, V> loader, Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata, long timeout, TimeUnit unit, int maxQueue) {
        this.executor = executor;
        this.loader = loader;
        this.filter = filter;
        this.fetchValue = fetchValue;
        this.fetchMetadata = fetchMetadata;
        this.timeout = timeout;
        this.unit = unit;
        this.queue = new ArrayBlockingQueue<MarshalledEntry<K, V>>(maxQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MarshalledEntry<K, V> get() throws TimeoutException {
        MarshalledEntry entry;
        if (this.taskRef.get() == null && this.taskRef.getAndUpdate(t -> t == null ? new SupplierCacheLoaderTask() : t) == null) {
            AdvancedCacheLoader.CacheLoaderTask<K, V> task = this.taskRef.get();
            this.executor.execute(() -> {
                try {
                    this.loader.process(this.filter != null ? this.filter::test : k -> true, task, new WithinThreadExecutor(), this.fetchValue, this.fetchMetadata);
                }
                finally {
                    this.close();
                }
            });
        }
        boolean interrupted = false;
        while ((entry = (MarshalledEntry)this.queue.poll()) == null) {
            this.closeLock.lock();
            try {
                entry = (MarshalledEntry)this.queue.poll();
                if (entry != null || this.closed) break;
                long targetTime = System.nanoTime() + this.unit.toNanos(this.timeout);
                try {
                    if (this.closeCondition.await(targetTime - System.nanoTime(), TimeUnit.NANOSECONDS)) continue;
                    throw new TimeoutException("Couldn't retrieve entry an entry from store in allotted timeout: " + this.timeout + " unit: " + (Object)((Object)this.unit));
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            finally {
                this.closeLock.unlock();
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (trace) {
            log.tracef("Returning entry: " + entry, new Object[0]);
        }
        return entry;
    }

    @Override
    public void close() {
        this.closeLock.lock();
        try {
            this.closed = true;
            this.closeCondition.signalAll();
        }
        finally {
            this.closeLock.unlock();
        }
    }

    class SupplierCacheLoaderTask
    implements AdvancedCacheLoader.CacheLoaderTask<K, V> {
        SupplierCacheLoaderTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processEntry(MarshalledEntry<K, V> marshalledEntry, AdvancedCacheLoader.TaskContext taskContext) throws InterruptedException {
            if (!taskContext.isStopped()) {
                PersistenceManagerCloseableSupplier.this.closeLock.lock();
                try {
                    if (PersistenceManagerCloseableSupplier.this.closed) {
                        taskContext.stop();
                        return;
                    }
                }
                finally {
                    PersistenceManagerCloseableSupplier.this.closeLock.unlock();
                }
                boolean stop = PersistenceManagerCloseableSupplier.this.closed;
                while (!stop) {
                    if (PersistenceManagerCloseableSupplier.this.queue.offer(marshalledEntry, 100L, TimeUnit.MILLISECONDS)) {
                        PersistenceManagerCloseableSupplier.this.closeLock.lock();
                        try {
                            PersistenceManagerCloseableSupplier.this.closeCondition.signalAll();
                            break;
                        }
                        finally {
                            PersistenceManagerCloseableSupplier.this.closeLock.unlock();
                        }
                    }
                    PersistenceManagerCloseableSupplier.this.closeLock.lock();
                    try {
                        stop = PersistenceManagerCloseableSupplier.this.closed;
                    }
                    finally {
                        PersistenceManagerCloseableSupplier.this.closeLock.unlock();
                    }
                }
            }
        }
    }
}

