/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.sp;

import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.federation.metrics.AbstractPicketLinkMetricsOperationHandler;
import org.wildfly.extension.picketlink.federation.metrics.PicketLinkSubsystemMetrics;
import org.wildfly.extension.picketlink.federation.service.ServiceProviderService;

public class ServiceProviderMetricsOperationHandler
extends AbstractPicketLinkMetricsOperationHandler {
    public static final ServiceProviderMetricsOperationHandler INSTANCE = new ServiceProviderMetricsOperationHandler();
    static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{EXPIRED_ASSERTIONS_COUNT, REQUEST_FROM_IDP_COUNT, REQUEST_TO_IDP_COUNT, RESPONSE_FROM_IDP_COUNT};

    private ServiceProviderMetricsOperationHandler() {
    }

    @Override
    protected void doPopulateResult(PicketLinkSubsystemMetrics metrics, ModelNode result, String attributeName) {
        if (ModelElement.METRICS_EXPIRED_ASSERTIONS_COUNT.getName().equals(attributeName)) {
            result.set(metrics.getExpiredAssertionsCount());
        } else if (ModelElement.METRICS_REQUEST_FROM_IDP_COUNT.getName().equals(attributeName)) {
            result.set(metrics.getRequestFromIDPCount());
        } else if (ModelElement.METRICS_REQUEST_TO_IDP_COUNT.getName().equals(attributeName)) {
            result.set(metrics.getRequestToIDPCount());
        } else if (ModelElement.METRICS_RESPONSE_FROM_IDP_COUNT.getName().equals(attributeName)) {
            result.set(metrics.getResponseFromIDPCount());
        }
    }

    @Override
    protected ServiceName createServiceName(String name) {
        return ServiceProviderService.createServiceName(name);
    }
}

