/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.persistence;

import java.lang.reflect.Method;
import java.util.Date;
import javax.ejb.ScheduleExpression;
import org.jboss.as.ejb3.timerservice.CalendarTimer;
import org.jboss.as.ejb3.timerservice.persistence.TimeoutMethod;
import org.jboss.as.ejb3.timerservice.persistence.TimerEntity;
import org.jboss.as.ejb3.timerservice.schedule.CalendarBasedTimeout;

public class CalendarTimerEntity
extends TimerEntity {
    private transient ScheduleExpression scheduleExpression;
    private transient CalendarBasedTimeout calendarTimeout;
    private final String scheduleExprSecond;
    private final String scheduleExprMinute;
    private final String scheduleExprHour;
    private final String scheduleExprDayOfWeek;
    private final String scheduleExprDayOfMonth;
    private final String scheduleExprMonth;
    private final String scheduleExprYear;
    private final Date scheduleExprStartDate;
    private final Date scheduleExprEndDate;
    private final String scheduleExprTimezone;
    private final boolean autoTimer;
    private final TimeoutMethod timeoutMethod;

    public CalendarTimerEntity(CalendarTimer calendarTimer) {
        super(calendarTimer);
        this.scheduleExpression = calendarTimer.getScheduleExpression();
        this.autoTimer = calendarTimer.isAutoTimer();
        if (calendarTimer.isAutoTimer()) {
            Method method = calendarTimer.getTimeoutMethod();
            Class<?>[] methodParams = method.getParameterTypes();
            String[] params = new String[methodParams.length];
            for (int i = 0; i < methodParams.length; ++i) {
                params[i] = methodParams[i].getName();
            }
            this.timeoutMethod = new TimeoutMethod(method.getDeclaringClass().getName(), method.getName(), params);
        } else {
            this.timeoutMethod = null;
        }
        this.scheduleExprSecond = this.scheduleExpression.getSecond();
        this.scheduleExprMinute = this.scheduleExpression.getMinute();
        this.scheduleExprHour = this.scheduleExpression.getHour();
        this.scheduleExprDayOfMonth = this.scheduleExpression.getDayOfMonth();
        this.scheduleExprMonth = this.scheduleExpression.getMonth();
        this.scheduleExprDayOfWeek = this.scheduleExpression.getDayOfWeek();
        this.scheduleExprYear = this.scheduleExpression.getYear();
        this.scheduleExprStartDate = this.scheduleExpression.getStart();
        this.scheduleExprEndDate = this.scheduleExpression.getEnd();
        this.scheduleExprTimezone = this.scheduleExpression.getTimezone();
    }

    @Override
    public boolean isCalendarTimer() {
        return true;
    }

    public ScheduleExpression getScheduleExpression() {
        if (this.scheduleExpression == null) {
            this.scheduleExpression = new ScheduleExpression();
            this.scheduleExpression.second(this.scheduleExprSecond).minute(this.scheduleExprMinute).hour(this.scheduleExprHour).dayOfWeek(this.scheduleExprDayOfWeek).dayOfMonth(this.scheduleExprDayOfMonth).month(this.scheduleExprMonth).year(this.scheduleExprYear).timezone(this.scheduleExprTimezone).start(this.scheduleExprStartDate).end(this.scheduleExprEndDate);
        }
        return this.scheduleExpression;
    }

    public CalendarBasedTimeout getCalendarTimeout() {
        if (this.calendarTimeout == null) {
            this.calendarTimeout = new CalendarBasedTimeout(this.getScheduleExpression());
        }
        return this.calendarTimeout;
    }

    public String getSecond() {
        return this.scheduleExprSecond;
    }

    public String getMinute() {
        return this.scheduleExprMinute;
    }

    public String getHour() {
        return this.scheduleExprHour;
    }

    public String getDayOfWeek() {
        return this.scheduleExprDayOfWeek;
    }

    public String getDayOfMonth() {
        return this.scheduleExprDayOfMonth;
    }

    public String getMonth() {
        return this.scheduleExprMonth;
    }

    public String getYear() {
        return this.scheduleExprYear;
    }

    public Date getStartDate() {
        return this.scheduleExprStartDate;
    }

    public Date getEndDate() {
        return this.scheduleExprEndDate;
    }

    public TimeoutMethod getTimeoutMethod() {
        return this.timeoutMethod;
    }

    public boolean isAutoTimer() {
        return this.autoTimer;
    }

    public String getTimezone() {
        return this.scheduleExprTimezone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalendarTimerEntity)) {
            return false;
        }
        CalendarTimerEntity other = (CalendarTimerEntity)obj;
        if (this.id == null) {
            return false;
        }
        return this.id.equals(other.id);
    }

    @Override
    public int hashCode() {
        if (this.id == null) {
            return super.hashCode();
        }
        return this.id.hashCode();
    }
}

