/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.trycatch;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.trycatch.CatchAttr;
import jadx.core.dex.trycatch.ExcHandlerAttr;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.trycatch.SplitterBlockAttr;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class TryCatchBlock {
    private final List<ExceptionHandler> handlers = new LinkedList<ExceptionHandler>();
    private final List<InsnNode> insns = new ArrayList<InsnNode>();
    private final CatchAttr attr = new CatchAttr(this);

    public Iterable<ExceptionHandler> getHandlers() {
        return this.handlers;
    }

    public int getHandlersCount() {
        return this.handlers.size();
    }

    public boolean containsAllHandlers(TryCatchBlock tb) {
        return this.handlers.containsAll(tb.handlers);
    }

    public ExceptionHandler addHandler(MethodNode mth, int addr, @Nullable ClassInfo type) {
        ExceptionHandler handler = new ExceptionHandler(addr, type);
        handler.setTryBlock(this);
        ExceptionHandler addedHandler = mth.addExceptionHandler(handler);
        if (addedHandler == handler || addedHandler.getTryBlock() != this) {
            this.handlers.add(addedHandler);
        }
        return addedHandler;
    }

    public void removeSameHandlers(TryCatchBlock outerTry) {
        for (ExceptionHandler handler : outerTry.getHandlers()) {
            if (!this.handlers.remove(handler)) continue;
            handler.setTryBlock(outerTry);
        }
    }

    public void removeHandler(MethodNode mth, ExceptionHandler handler) {
        Iterator<ExceptionHandler> it = this.handlers.iterator();
        while (it.hasNext()) {
            ExceptionHandler h = it.next();
            if (h != handler) continue;
            this.unbindHandler(h);
            it.remove();
            break;
        }
        if (this.handlers.isEmpty()) {
            this.removeWholeBlock(mth);
        }
    }

    private void unbindHandler(ExceptionHandler handler) {
        for (BlockNode block : handler.getBlocks()) {
            SplitterBlockAttr splitter;
            BlockUtils.skipPredSyntheticPaths(block);
            block.add(AFlag.REMOVE);
            ExcHandlerAttr excHandlerAttr = block.get(AType.EXC_HANDLER);
            if (excHandlerAttr != null && excHandlerAttr.getHandler().equals(handler)) {
                block.remove(AType.EXC_HANDLER);
            }
            if ((splitter = handler.getHandlerBlock().get(AType.SPLITTER_BLOCK)) == null) continue;
            BlockNode splitterBlock = splitter.getBlock();
            splitterBlock.remove(AType.SPLITTER_BLOCK);
            for (BlockNode successor : splitterBlock.getSuccessors()) {
                successor.remove(AType.SPLITTER_BLOCK);
            }
        }
        handler.markForRemove();
    }

    private void removeWholeBlock(MethodNode mth) {
        Iterator<ExceptionHandler> it = this.handlers.iterator();
        while (it.hasNext()) {
            ExceptionHandler h = it.next();
            this.unbindHandler(h);
            it.remove();
        }
        for (InsnNode insn : this.insns) {
            insn.removeAttr(this.attr);
        }
        this.insns.clear();
        if (mth.getBasicBlocks() != null) {
            for (BlockNode block : mth.getBasicBlocks()) {
                block.removeAttr(this.attr);
            }
        }
    }

    public void addInsn(InsnNode insn) {
        this.insns.add(insn);
        insn.addAttr(this.attr);
    }

    public void removeInsn(MethodNode mth, InsnNode insn) {
        this.insns.remove(insn);
        insn.remove(AType.CATCH_BLOCK);
        if (this.insns.isEmpty()) {
            this.removeWholeBlock(mth);
        }
    }

    public void removeBlock(MethodNode mth, BlockNode block) {
        for (InsnNode insn : block.getInstructions()) {
            this.insns.remove(insn);
            insn.remove(AType.CATCH_BLOCK);
        }
        if (this.insns.isEmpty()) {
            this.removeWholeBlock(mth);
        }
    }

    public Iterable<InsnNode> getInsns() {
        return this.insns;
    }

    public CatchAttr getCatchAttr() {
        return this.attr;
    }

    public boolean merge(MethodNode mth, TryCatchBlock tryBlock) {
        if (tryBlock == this) {
            return false;
        }
        for (InsnNode insn : tryBlock.getInsns()) {
            this.addInsn(insn);
        }
        this.handlers.addAll(tryBlock.handlers);
        for (ExceptionHandler eh : this.handlers) {
            eh.setTryBlock(this);
        }
        tryBlock.handlers.clear();
        tryBlock.removeWholeBlock(mth);
        return true;
    }

    public int hashCode() {
        return this.handlers.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TryCatchBlock other = (TryCatchBlock)obj;
        return this.handlers.equals(other.handlers);
    }

    public String toString() {
        return "Catch:{ " + Utils.listToString(this.handlers) + " }";
    }
}

