#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 text-short
version:              0.1.3
visibility:           public
id:                   text-short-0.1.3-FAse0tIN3l6IW6VG60hCOn
key:                  text-short-0.1.3-FAse0tIN3l6IW6VG60hCOn
license:              BSD-3-Clause
maintainer:           hvr@gnu.org
author:               Herbert Valerio Riedel
synopsis:             Memory-efficient representation of Unicode text strings
description:
    This package provides the '\''ShortText'\'' type which is suitable for keeping many short strings in memory. This is similiar to how '\''ShortByteString'\'' relates to '\''ByteString'\''.

    The main difference between '\''Text'\'' and '\''ShortText'\'' is that '\''ShortText'\'' uses UTF-8 instead of UTF-16 internally and also doesn'\''t support zero-copy slicing (thereby saving 2 words). Consequently, the memory footprint of a (boxed) '\''ShortText'\'' value is 4 words (2 words when unboxed) plus the length of the UTF-8 encoded payload.

category:             Data
abi:                  27b1901fbebdfc24ad595624f421eccf
exposed:              True
exposed-modules:
    Data.Text.Short Data.Text.Short.Partial Data.Text.Short.Unsafe

hidden-modules:       Data.Text.Short.Internal PrimOps
import-dirs:          /usr/lib/ghc-8.10.5/site-local/text-short-0.1.3
library-dirs:         /usr/lib/ghc-8.10.5/site-local/text-short-0.1.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/text-short-0.1.3
hs-libraries:         HStext-short-0.1.3-FAse0tIN3l6IW6VG60hCOn
depends:
    base-4.14.2.0 binary-0.8.8.0 bytestring-0.10.12.0 deepseq-1.4.4.0
    ghc-prim-0.6.1 hashable-1.3.2.0-L2CDkY7lZtECinpkHRj0mo text-1.2.4.1

haddock-interfaces:   /usr/share/doc/haskell-text-short/html/text-short.haddock
haddock-html:         /usr/share/doc/haskell-text-short/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

