#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 some
version:              1.0.3
visibility:           public
id:                   some-1.0.3-1KmRXE4Js6K5qWAWmRn59k
key:                  some-1.0.3-1KmRXE4Js6K5qWAWmRn59k
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    James Cook <mokus@deepbondi.net>, Oleg Grenrus <oleg.grenrus@iki.fi>

stability:            provisional
homepage:             https://github.com/phadej/some
synopsis:             Existential type: Some
description:
    This library defines an existential type '\''Some'\''.

    @
    data Some f where
    \    Some :: f a -> Some f
    @

    in few variants, and utilities to work with it.

    If you are unsure which variant to use, use the one in "Data.Some" module.

category:             Data, Dependent Types
abi:                  faeb1a5c21d4a2570a212b3a49b779f5
exposed:              True
exposed-modules:
    Data.GADT.Compare Data.GADT.DeepSeq Data.GADT.Show Data.Some
    Data.Some.Church Data.Some.GADT Data.Some.Newtype

hidden-modules:       Data.GADT.Internal
import-dirs:          /usr/lib/ghc-8.10.5/site-local/some-1.0.3
library-dirs:         /usr/lib/ghc-8.10.5/site-local/some-1.0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/some-1.0.3
hs-libraries:         HSsome-1.0.3-1KmRXE4Js6K5qWAWmRn59k
depends:              base-4.14.2.0 deepseq-1.4.4.0
haddock-interfaces:   /usr/share/doc/haskell-some/html/some.haddock
haddock-html:         /usr/share/doc/haskell-some/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

