#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2017 Google
# GNU General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)
# ----------------------------------------------------------------------------
#
#     ***     AUTO GENERATED CODE    ***    Type: MMv1     ***
#
# ----------------------------------------------------------------------------
#
#     This file is automatically generated by Magic Modules and manual
#     changes will be clobbered when the file is regenerated.
#
#     Please read more about how to change this file at
#     https://www.github.com/GoogleCloudPlatform/magic-modules
#
# ----------------------------------------------------------------------------

from __future__ import absolute_import, division, print_function

__metaclass__ = type

################################################################################
# Documentation
################################################################################

ANSIBLE_METADATA = {'metadata_version': '1.1', 'status': ["preview"], 'supported_by': 'community'}

DOCUMENTATION = '''
---
module: gcp_compute_region_backend_service
description:
- A Region Backend Service defines a regionally-scoped group of virtual machines that
  will serve traffic for load balancing.
short_description: Creates a GCP RegionBackendService
author: Google Inc. (@googlecloudplatform)
requirements:
- python >= 2.6
- requests >= 2.18.4
- google-auth >= 1.3.0
options:
  state:
    description:
    - Whether the given object should exist in GCP
    choices:
    - present
    - absent
    default: present
    type: str
  affinity_cookie_ttl_sec:
    description:
    - Lifetime of cookies in seconds if session_affinity is GENERATED_COOKIE. If set
      to 0, the cookie is non-persistent and lasts only until the end of the browser
      session (or equivalent). The maximum allowed value for TTL is one day.
    - When the load balancing scheme is INTERNAL, this field is not used.
    required: false
    type: int
  backends:
    description:
    - The set of backends that serve this RegionBackendService.
    elements: dict
    required: false
    type: list
    suboptions:
      balancing_mode:
        description:
        - Specifies the balancing mode for this backend.
        - 'Some valid choices include: "UTILIZATION", "RATE", "CONNECTION"'
        required: false
        default: CONNECTION
        type: str
      capacity_scaler:
        description:
        - A multiplier applied to the group's maximum servicing capacity (based on
          UTILIZATION, RATE or CONNECTION).
        - "~>**NOTE**: This field cannot be set for INTERNAL region backend services
          (default loadBalancingScheme), but is required for non-INTERNAL backend
          service. The total capacity_scaler for all backends must be non-zero."
        - A setting of 0 means the group is completely drained, offering 0% of its
          available Capacity. Valid range is [0.0,1.0].
        required: false
        type: str
      description:
        description:
        - An optional description of this resource.
        - Provide this property when you create the resource.
        required: false
        type: str
      failover:
        description:
        - This field designates whether this is a failover backend. More than one
          failover backend can be configured for a given RegionBackendService.
        required: false
        type: bool
      group:
        description:
        - The fully-qualified URL of an Instance Group or Network Endpoint Group resource.
          In case of instance group this defines the list of instances that serve
          traffic. Member virtual machine instances from each instance group must
          live in the same zone as the instance group itself. No two backends in a
          backend service are allowed to use same Instance Group resource.
        - For Network Endpoint Groups this defines list of endpoints. All endpoints
          of Network Endpoint Group must be hosted on instances located in the same
          zone as the Network Endpoint Group.
        - Backend services cannot mix Instance Group and Network Endpoint Group backends.
        - When the `load_balancing_scheme` is INTERNAL, only instance groups are supported.
        - Note that you must specify an Instance Group or Network Endpoint Group resource
          using the fully-qualified URL, rather than a partial URL.
        required: true
        type: str
      max_connections:
        description:
        - The max number of simultaneous connections for the group. Can be used with
          either CONNECTION or UTILIZATION balancing modes.
        - Cannot be set for INTERNAL backend services.
        - For CONNECTION mode, either maxConnections or one of maxConnectionsPerInstance
          or maxConnectionsPerEndpoint, as appropriate for group type, must be set.
        required: false
        type: int
      max_connections_per_instance:
        description:
        - The max number of simultaneous connections that a single backend instance
          can handle. Cannot be set for INTERNAL backend services.
        - This is used to calculate the capacity of the group.
        - Can be used in either CONNECTION or UTILIZATION balancing modes.
        - For CONNECTION mode, either maxConnections or maxConnectionsPerInstance
          must be set.
        required: false
        type: int
      max_connections_per_endpoint:
        description:
        - The max number of simultaneous connections that a single backend network
          endpoint can handle. Cannot be set for INTERNAL backend services.
        - This is used to calculate the capacity of the group. Can be used in either
          CONNECTION or UTILIZATION balancing modes. For CONNECTION mode, either maxConnections
          or maxConnectionsPerEndpoint must be set.
        required: false
        type: int
      max_rate:
        description:
        - The max requests per second (RPS) of the group. Cannot be set for INTERNAL
          backend services.
        - Can be used with either RATE or UTILIZATION balancing modes, but required
          if RATE mode. Either maxRate or one of maxRatePerInstance or maxRatePerEndpoint,
          as appropriate for group type, must be set.
        required: false
        type: int
      max_rate_per_instance:
        description:
        - The max requests per second (RPS) that a single backend instance can handle.
          This is used to calculate the capacity of the group. Can be used in either
          balancing mode. For RATE mode, either maxRate or maxRatePerInstance must
          be set. Cannot be set for INTERNAL backend services.
        required: false
        type: str
      max_rate_per_endpoint:
        description:
        - The max requests per second (RPS) that a single backend network endpoint
          can handle. This is used to calculate the capacity of the group. Can be
          used in either balancing mode. For RATE mode, either maxRate or maxRatePerEndpoint
          must be set. Cannot be set for INTERNAL backend services.
        required: false
        type: str
      max_utilization:
        description:
        - Used when balancingMode is UTILIZATION. This ratio defines the CPU utilization
          target for the group. Valid range is [0.0, 1.0].
        - Cannot be set for INTERNAL backend services.
        required: false
        type: str
  circuit_breakers:
    description:
    - Settings controlling the volume of connections to a backend service. This field
      is applicable only when the `load_balancing_scheme` is set to INTERNAL_MANAGED
      and the `protocol` is set to HTTP, HTTPS, or HTTP2.
    required: false
    type: dict
    suboptions:
      max_requests_per_connection:
        description:
        - Maximum requests for a single backend connection. This parameter is respected
          by both the HTTP/1.1 and HTTP/2 implementations. If not specified, there
          is no limit. Setting this parameter to 1 will effectively disable keep alive.
        required: false
        type: int
      max_connections:
        description:
        - The maximum number of connections to the backend cluster.
        - Defaults to 1024.
        required: false
        default: '1024'
        type: int
      max_pending_requests:
        description:
        - The maximum number of pending requests to the backend cluster.
        - Defaults to 1024.
        required: false
        default: '1024'
        type: int
      max_requests:
        description:
        - The maximum number of parallel requests to the backend cluster.
        - Defaults to 1024.
        required: false
        default: '1024'
        type: int
      max_retries:
        description:
        - The maximum number of parallel retries to the backend cluster.
        - Defaults to 3.
        required: false
        default: '3'
        type: int
  consistent_hash:
    description:
    - Consistent Hash-based load balancing can be used to provide soft session affinity
      based on HTTP headers, cookies or other properties. This load balancing policy
      is applicable only for HTTP connections. The affinity to a particular destination
      host will be lost when one or more hosts are added/removed from the destination
      service. This field specifies parameters that control consistent hashing.
    - This field only applies when all of the following are true - * `load_balancing_scheme`
      is set to INTERNAL_MANAGED * `protocol` is set to HTTP, HTTPS, or HTTP2 * `locality_lb_policy`
      is set to MAGLEV or RING_HASH .
    required: false
    type: dict
    suboptions:
      http_cookie:
        description:
        - Hash is based on HTTP Cookie. This field describes a HTTP cookie that will
          be used as the hash key for the consistent hash load balancer. If the cookie
          is not present, it will be generated.
        - This field is applicable if the sessionAffinity is set to HTTP_COOKIE.
        required: false
        type: dict
        suboptions:
          ttl:
            description:
            - Lifetime of the cookie.
            required: false
            type: dict
            suboptions:
              seconds:
                description:
                - Span of time at a resolution of a second.
                - Must be from 0 to 315,576,000,000 inclusive.
                required: true
                type: int
              nanos:
                description:
                - Span of time that's a fraction of a second at nanosecond resolution.
                  Durations less than one second are represented with a 0 seconds
                  field and a positive nanos field. Must be from 0 to 999,999,999
                  inclusive.
                required: false
                type: int
          name:
            description:
            - Name of the cookie.
            required: false
            type: str
          path:
            description:
            - Path to set for the cookie.
            required: false
            type: str
      http_header_name:
        description:
        - The hash based on the value of the specified header field.
        - This field is applicable if the sessionAffinity is set to HEADER_FIELD.
        required: false
        type: str
      minimum_ring_size:
        description:
        - The minimum number of virtual nodes to use for the hash ring.
        - Larger ring sizes result in more granular load distributions. If the number
          of hosts in the load balancing pool is larger than the ring size, each host
          will be assigned a single virtual node.
        - Defaults to 1024.
        required: false
        default: '1024'
        type: int
  cdn_policy:
    description:
    - Cloud CDN configuration for this BackendService.
    required: false
    type: dict
    suboptions:
      cache_key_policy:
        description:
        - The CacheKeyPolicy for this CdnPolicy.
        required: false
        type: dict
        suboptions:
          include_host:
            description:
            - If true requests to different hosts will be cached separately.
            required: false
            type: bool
          include_protocol:
            description:
            - If true, http and https requests will be cached separately.
            required: false
            type: bool
          include_query_string:
            description:
            - If true, include query string parameters in the cache key according
              to query_string_whitelist and query_string_blacklist. If neither is
              set, the entire query string will be included.
            - If false, the query string will be excluded from the cache key entirely.
            required: false
            type: bool
          query_string_blacklist:
            description:
            - Names of query string parameters to exclude in cache keys.
            - All other parameters will be included. Either specify query_string_whitelist
              or query_string_blacklist, not both.
            - "'&' and '=' will be percent encoded and not treated as delimiters."
            elements: str
            required: false
            type: list
          query_string_whitelist:
            description:
            - Names of query string parameters to include in cache keys.
            - All other parameters will be excluded. Either specify query_string_whitelist
              or query_string_blacklist, not both.
            - "'&' and '=' will be percent encoded and not treated as delimiters."
            elements: str
            required: false
            type: list
      signed_url_cache_max_age_sec:
        description:
        - Maximum number of seconds the response to a signed URL request will be considered
          fresh, defaults to 1hr (3600s). After this time period, the response will
          be revalidated before being served.
        - 'When serving responses to signed URL requests, Cloud CDN will internally
          behave as though all responses from this backend had a "Cache-Control: public,
          max-age=[TTL]" header, regardless of any existing Cache-Control header.
          The actual headers served in responses will not be altered.'
        required: false
        default: '3600'
        type: int
      default_ttl:
        description:
        - Specifies the default TTL for cached content served by this origin for responses
          that do not have an existing valid TTL (max-age or s-max-age).
        required: false
        type: int
      max_ttl:
        description:
        - Specifies the maximum allowed TTL for cached content served by this origin.
        required: false
        type: int
      client_ttl:
        description:
        - Specifies the maximum allowed TTL for cached content served by this origin.
        required: false
        type: int
      negative_caching:
        description:
        - Negative caching allows per-status code TTLs to be set, in order to apply
          fine-grained caching for common errors or redirects.
        required: false
        type: bool
      negative_caching_policy:
        description:
        - Sets a cache TTL for the specified HTTP status code. negativeCaching must
          be enabled to configure negativeCachingPolicy.
        - Omitting the policy and leaving negativeCaching enabled will use Cloud CDN's
          default cache TTLs.
        elements: dict
        required: false
        type: list
        suboptions:
          code:
            description:
            - The HTTP status code to define a TTL against. Only HTTP status codes
              300, 301, 308, 404, 405, 410, 421, 451 and 501 can be specified as values,
              and you cannot specify a status code more than once.
            required: false
            type: int
      cache_mode:
        description:
        - Specifies the cache setting for all responses from this backend.
        - 'The possible values are: USE_ORIGIN_HEADERS, FORCE_CACHE_ALL and CACHE_ALL_STATIC
          .'
        - 'Some valid choices include: "USE_ORIGIN_HEADERS", "FORCE_CACHE_ALL", "CACHE_ALL_STATIC"'
        required: false
        type: str
      serve_while_stale:
        description:
        - Serve existing content from the cache (if available) when revalidating content
          with the origin, or when an error is encountered when refreshing the cache.
        required: false
        type: int
  connection_draining:
    description:
    - Settings for connection draining .
    required: false
    type: dict
    suboptions:
      draining_timeout_sec:
        description:
        - Time for which instance will be drained (not accept new connections, but
          still work to finish started).
        required: false
        default: '300'
        type: int
  description:
    description:
    - An optional description of this resource.
    required: false
    type: str
  failover_policy:
    description:
    - Policy for failovers.
    required: false
    type: dict
    suboptions:
      disable_connection_drain_on_failover:
        description:
        - 'On failover or failback, this field indicates whether connection drain
          will be honored. Setting this to true has the following effect: connections
          to the old active pool are not drained. Connections to the new active pool
          use the timeout of 10 min (currently fixed). Setting to false has the following
          effect: both old and new connections will have a drain timeout of 10 min.'
        - This can be set to true only if the protocol is TCP.
        - The default is false.
        required: false
        type: bool
      drop_traffic_if_unhealthy:
        description:
        - This option is used only when no healthy VMs are detected in the primary
          and backup instance groups. When set to true, traffic is dropped. When set
          to false, new connections are sent across all VMs in the primary group.
        - The default is false.
        required: false
        type: bool
      failover_ratio:
        description:
        - The value of the field must be in [0, 1]. If the ratio of the healthy VMs
          in the primary backend is at or below this number, traffic arriving at the
          load-balanced IP will be directed to the failover backend.
        - In case where 'failoverRatio' is not set or all the VMs in the backup backend
          are unhealthy, the traffic will be directed back to the primary backend
          in the "force" mode, where traffic will be spread to the healthy VMs with
          the best effort, or to all VMs when no VM is healthy.
        - This field is only used with l4 load balancing.
        required: false
        type: str
  enable_cdn:
    description:
    - If true, enable Cloud CDN for this RegionBackendService.
    required: false
    type: bool
  health_checks:
    description:
    - The set of URLs to HealthCheck resources for health checking this RegionBackendService.
      Currently at most one health check can be specified.
    - A health check must be specified unless the backend service uses an internet
      or serverless NEG as a backend.
    elements: str
    required: false
    type: list
  load_balancing_scheme:
    description:
    - Indicates what kind of load balancing this regional backend service will be
      used for. A backend service created for one type of load balancing cannot be
      used with the other(s).
    - 'Some valid choices include: "EXTERNAL", "INTERNAL", "INTERNAL_MANAGED"'
    required: false
    default: INTERNAL
    type: str
  locality_lb_policy:
    description:
    - The load balancing algorithm used within the scope of the locality.
    - The possible values are - * ROUND_ROBIN - This is a simple policy in which each
      healthy backend is selected in round robin order.
    - "* LEAST_REQUEST - An O(1) algorithm which selects two random healthy hosts
      and picks the host which has fewer active requests."
    - "* RING_HASH - The ring/modulo hash load balancer implements consistent hashing
      to backends. The algorithm has the property that the addition/removal of a host
      from a set of N hosts only affects 1/N of the requests."
    - "* RANDOM - The load balancer selects a random healthy host."
    - "* ORIGINAL_DESTINATION - Backend host is selected based on the client connection
      metadata, i.e., connections are opened to the same address as the destination
      address of the incoming connection before the connection was redirected to the
      load balancer."
    - "* MAGLEV - used as a drop in replacement for the ring hash load balancer."
    - Maglev is not as stable as ring hash but has faster table lookup build times
      and host selection times. For more information about Maglev, refer to https://ai.google/research/pubs/pub44824
      This field is applicable only when the `load_balancing_scheme` is set to INTERNAL_MANAGED
      and the `protocol` is set to HTTP, HTTPS, or HTTP2.
    - 'Some valid choices include: "ROUND_ROBIN", "LEAST_REQUEST", "RING_HASH", "RANDOM",
      "ORIGINAL_DESTINATION", "MAGLEV"'
    required: false
    type: str
  name:
    description:
    - Name of the resource. Provided by the client when the resource is created. The
      name must be 1-63 characters long, and comply with RFC1035. Specifically, the
      name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`
      which means the first character must be a lowercase letter, and all following
      characters must be a dash, lowercase letter, or digit, except the last character,
      which cannot be a dash.
    required: true
    type: str
  outlier_detection:
    description:
    - Settings controlling eviction of unhealthy hosts from the load balancing pool.
    - This field is applicable only when the `load_balancing_scheme` is set to INTERNAL_MANAGED
      and the `protocol` is set to HTTP, HTTPS, or HTTP2.
    required: false
    type: dict
    suboptions:
      base_ejection_time:
        description:
        - The base time that a host is ejected for. The real time is equal to the
          base time multiplied by the number of times the host has been ejected. Defaults
          to 30000ms or 30s.
        required: false
        type: dict
        suboptions:
          seconds:
            description:
            - Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
              inclusive.
            required: true
            type: int
          nanos:
            description:
            - Span of time that's a fraction of a second at nanosecond resolution.
              Durations less than one second are represented with a 0 `seconds` field
              and a positive `nanos` field. Must be from 0 to 999,999,999 inclusive.
            required: false
            type: int
      consecutive_errors:
        description:
        - Number of errors before a host is ejected from the connection pool. When
          the backend host is accessed over HTTP, a 5xx return code qualifies as an
          error.
        - Defaults to 5.
        required: false
        default: '5'
        type: int
      consecutive_gateway_failure:
        description:
        - The number of consecutive gateway failures (502, 503, 504 status or connection
          errors that are mapped to one of those status codes) before a consecutive
          gateway failure ejection occurs. Defaults to 5.
        required: false
        default: '5'
        type: int
      enforcing_consecutive_errors:
        description:
        - The percentage chance that a host will be actually ejected when an outlier
          status is detected through consecutive 5xx. This setting can be used to
          disable ejection or to ramp it up slowly. Defaults to 100.
        required: false
        default: '100'
        type: int
      enforcing_consecutive_gateway_failure:
        description:
        - The percentage chance that a host will be actually ejected when an outlier
          status is detected through consecutive gateway failures. This setting can
          be used to disable ejection or to ramp it up slowly. Defaults to 0.
        required: false
        type: int
      enforcing_success_rate:
        description:
        - The percentage chance that a host will be actually ejected when an outlier
          status is detected through success rate statistics. This setting can be
          used to disable ejection or to ramp it up slowly. Defaults to 100.
        required: false
        default: '100'
        type: int
      interval:
        description:
        - Time interval between ejection sweep analysis. This can result in both new
          ejections as well as hosts being returned to service. Defaults to 10 seconds.
        required: false
        type: dict
        suboptions:
          seconds:
            description:
            - Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
              inclusive.
            required: true
            type: int
          nanos:
            description:
            - Span of time that's a fraction of a second at nanosecond resolution.
              Durations less than one second are represented with a 0 `seconds` field
              and a positive `nanos` field. Must be from 0 to 999,999,999 inclusive.
            required: false
            type: int
      max_ejection_percent:
        description:
        - Maximum percentage of hosts in the load balancing pool for the backend service
          that can be ejected. Defaults to 10%.
        required: false
        default: '10'
        type: int
      success_rate_minimum_hosts:
        description:
        - The number of hosts in a cluster that must have enough request volume to
          detect success rate outliers. If the number of hosts is less than this setting,
          outlier detection via success rate statistics is not performed for any host
          in the cluster. Defaults to 5.
        required: false
        default: '5'
        type: int
      success_rate_request_volume:
        description:
        - The minimum number of total requests that must be collected in one interval
          (as defined by the interval duration above) to include this host in success
          rate based outlier detection. If the volume is lower than this setting,
          outlier detection via success rate statistics is not performed for that
          host. Defaults to 100.
        required: false
        default: '100'
        type: int
      success_rate_stdev_factor:
        description:
        - 'This factor is used to determine the ejection threshold for success rate
          outlier ejection. The ejection threshold is the difference between the mean
          success rate, and the product of this factor and the standard deviation
          of the mean success rate: mean - (stdev * success_rate_stdev_factor). This
          factor is divided by a thousand to get a double. That is, if the desired
          factor is 1.9, the runtime value should be 1900. Defaults to 1900.'
        required: false
        default: '1900'
        type: int
  port_name:
    description:
    - A named port on a backend instance group representing the port for communication
      to the backend VMs in that group. Required when the loadBalancingScheme is EXTERNAL,
      INTERNAL_MANAGED, or INTERNAL_SELF_MANAGED and the backends are instance groups.
      The named port must be defined on each backend instance group. This parameter
      has no meaning if the backends are NEGs. API sets a default of "http" if not
      given.
    - Must be omitted when the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load
      Balancing).
    required: false
    type: str
  protocol:
    description:
    - The protocol this RegionBackendService uses to communicate with backends.
    - 'The default is HTTP. **NOTE**: HTTP2 is only valid for beta HTTP/2 load balancer
      types and may result in errors if used with the GA API.'
    - 'Some valid choices include: "HTTP", "HTTPS", "HTTP2", "SSL", "TCP", "UDP",
      "GRPC"'
    required: false
    type: str
  session_affinity:
    description:
    - Type of session affinity to use. The default is NONE. Session affinity is not
      applicable if the protocol is UDP.
    - 'Some valid choices include: "NONE", "CLIENT_IP", "CLIENT_IP_PORT_PROTO", "CLIENT_IP_PROTO",
      "GENERATED_COOKIE", "HEADER_FIELD", "HTTP_COOKIE"'
    required: false
    type: str
  timeout_sec:
    description:
    - How many seconds to wait for the backend before considering it a failed request.
      Default is 30 seconds. Valid range is [1, 86400].
    required: false
    type: int
  log_config:
    description:
    - This field denotes the logging options for the load balancer traffic served
      by this backend service.
    - If logging is enabled, logs will be exported to Stackdriver.
    required: false
    type: dict
    suboptions:
      enable:
        description:
        - Whether to enable logging for the load balancer traffic served by this backend
          service.
        required: false
        type: bool
      sample_rate:
        description:
        - This field can only be specified if logging is enabled for this backend
          service. The value of the field must be in [0, 1]. This configures the sampling
          rate of requests to the load balancer where 1.0 means all logged requests
          are reported and 0.0 means no logged requests are reported.
        - The default value is 1.0.
        required: false
        type: str
  network:
    description:
    - The URL of the network to which this backend service belongs.
    - This field can only be specified when the load balancing scheme is set to INTERNAL.
    - 'This field represents a link to a Network resource in GCP. It can be specified
      in two ways. First, you can place a dictionary with key ''selfLink'' and value
      of your resource''s selfLink Alternatively, you can add `register: name-of-resource`
      to a gcp_compute_network task and then set this network field to "{{ name-of-resource
      }}"'
    required: false
    type: dict
  region:
    description:
    - A reference to the region where the regional backend service resides.
    required: true
    type: str
  project:
    description:
    - The Google Cloud Platform project to use.
    type: str
  auth_kind:
    description:
    - The type of credential used.
    type: str
    required: true
    choices:
    - application
    - machineaccount
    - serviceaccount
    - accesstoken
  service_account_contents:
    description:
    - The contents of a Service Account JSON file, either in a dictionary or as a
      JSON string that represents it.
    type: jsonarg
  service_account_file:
    description:
    - The path of a Service Account JSON file if serviceaccount is selected as type.
    type: path
  service_account_email:
    description:
    - An optional service account email address if machineaccount is selected and
      the user does not wish to use the default email.
    type: str
  access_token:
    description:
    - An OAuth2 access token if credential type is accesstoken.
    type: str
  scopes:
    description:
    - Array of scopes to be used
    type: list
    elements: str
  env_type:
    description:
    - Specifies which Ansible environment you're running this module within.
    - This should not be set unless you know what you're doing.
    - This only alters the User Agent string for any API requests.
    type: str
notes:
- 'API Reference: U(https://cloud.google.com/compute/docs/reference/latest/regionBackendServices)'
- 'Internal TCP/UDP Load Balancing: U(https://cloud.google.com/compute/docs/load-balancing/internal/)'
- for authentication, you can set service_account_file using the C(GCP_SERVICE_ACCOUNT_FILE)
  env variable.
- for authentication, you can set service_account_contents using the C(GCP_SERVICE_ACCOUNT_CONTENTS)
  env variable.
- For authentication, you can set service_account_email using the C(GCP_SERVICE_ACCOUNT_EMAIL)
  env variable.
- For authentication, you can set access_token using the C(GCP_ACCESS_TOKEN)
  env variable.
- For authentication, you can set auth_kind using the C(GCP_AUTH_KIND) env variable.
- For authentication, you can set scopes using the C(GCP_SCOPES) env variable.
- Environment variables values will only be used if the playbook values are not set.
- The I(service_account_email) and I(service_account_file) options are mutually exclusive.
'''

EXAMPLES = '''
- name: create a health check
  google.cloud.gcp_compute_health_check:
    name: "{{ resource_name }}"
    type: TCP
    tcp_health_check:
      port: 80
    check_interval_sec: 1
    timeout_sec: 1
    project: "{{ gcp_project }}"
    auth_kind: "{{ gcp_cred_kind }}"
    service_account_file: "{{ gcp_cred_file }}"
    state: present
  register: healthcheck

- name: create a region backend service
  google.cloud.gcp_compute_region_backend_service:
    name: test_object
    region: us-central1
    health_checks:
    - "{{ healthcheck.selfLink }}"
    connection_draining:
      draining_timeout_sec: 10
    session_affinity: CLIENT_IP
    project: test_project
    auth_kind: serviceaccount
    service_account_file: "/tmp/auth.pem"
    state: present
'''

RETURN = '''
affinityCookieTtlSec:
  description:
  - Lifetime of cookies in seconds if session_affinity is GENERATED_COOKIE. If set
    to 0, the cookie is non-persistent and lasts only until the end of the browser
    session (or equivalent). The maximum allowed value for TTL is one day.
  - When the load balancing scheme is INTERNAL, this field is not used.
  returned: success
  type: int
backends:
  description:
  - The set of backends that serve this RegionBackendService.
  returned: success
  type: complex
  contains:
    balancingMode:
      description:
      - Specifies the balancing mode for this backend.
      returned: success
      type: str
    capacityScaler:
      description:
      - A multiplier applied to the group's maximum servicing capacity (based on UTILIZATION,
        RATE or CONNECTION).
      - "~>**NOTE**: This field cannot be set for INTERNAL region backend services
        (default loadBalancingScheme), but is required for non-INTERNAL backend service.
        The total capacity_scaler for all backends must be non-zero."
      - A setting of 0 means the group is completely drained, offering 0% of its available
        Capacity. Valid range is [0.0,1.0].
      returned: success
      type: str
    description:
      description:
      - An optional description of this resource.
      - Provide this property when you create the resource.
      returned: success
      type: str
    failover:
      description:
      - This field designates whether this is a failover backend. More than one failover
        backend can be configured for a given RegionBackendService.
      returned: success
      type: bool
    group:
      description:
      - The fully-qualified URL of an Instance Group or Network Endpoint Group resource.
        In case of instance group this defines the list of instances that serve traffic.
        Member virtual machine instances from each instance group must live in the
        same zone as the instance group itself. No two backends in a backend service
        are allowed to use same Instance Group resource.
      - For Network Endpoint Groups this defines list of endpoints. All endpoints
        of Network Endpoint Group must be hosted on instances located in the same
        zone as the Network Endpoint Group.
      - Backend services cannot mix Instance Group and Network Endpoint Group backends.
      - When the `load_balancing_scheme` is INTERNAL, only instance groups are supported.
      - Note that you must specify an Instance Group or Network Endpoint Group resource
        using the fully-qualified URL, rather than a partial URL.
      returned: success
      type: str
    maxConnections:
      description:
      - The max number of simultaneous connections for the group. Can be used with
        either CONNECTION or UTILIZATION balancing modes.
      - Cannot be set for INTERNAL backend services.
      - For CONNECTION mode, either maxConnections or one of maxConnectionsPerInstance
        or maxConnectionsPerEndpoint, as appropriate for group type, must be set.
      returned: success
      type: int
    maxConnectionsPerInstance:
      description:
      - The max number of simultaneous connections that a single backend instance
        can handle. Cannot be set for INTERNAL backend services.
      - This is used to calculate the capacity of the group.
      - Can be used in either CONNECTION or UTILIZATION balancing modes.
      - For CONNECTION mode, either maxConnections or maxConnectionsPerInstance must
        be set.
      returned: success
      type: int
    maxConnectionsPerEndpoint:
      description:
      - The max number of simultaneous connections that a single backend network endpoint
        can handle. Cannot be set for INTERNAL backend services.
      - This is used to calculate the capacity of the group. Can be used in either
        CONNECTION or UTILIZATION balancing modes. For CONNECTION mode, either maxConnections
        or maxConnectionsPerEndpoint must be set.
      returned: success
      type: int
    maxRate:
      description:
      - The max requests per second (RPS) of the group. Cannot be set for INTERNAL
        backend services.
      - Can be used with either RATE or UTILIZATION balancing modes, but required
        if RATE mode. Either maxRate or one of maxRatePerInstance or maxRatePerEndpoint,
        as appropriate for group type, must be set.
      returned: success
      type: int
    maxRatePerInstance:
      description:
      - The max requests per second (RPS) that a single backend instance can handle.
        This is used to calculate the capacity of the group. Can be used in either
        balancing mode. For RATE mode, either maxRate or maxRatePerInstance must be
        set. Cannot be set for INTERNAL backend services.
      returned: success
      type: str
    maxRatePerEndpoint:
      description:
      - The max requests per second (RPS) that a single backend network endpoint can
        handle. This is used to calculate the capacity of the group. Can be used in
        either balancing mode. For RATE mode, either maxRate or maxRatePerEndpoint
        must be set. Cannot be set for INTERNAL backend services.
      returned: success
      type: str
    maxUtilization:
      description:
      - Used when balancingMode is UTILIZATION. This ratio defines the CPU utilization
        target for the group. Valid range is [0.0, 1.0].
      - Cannot be set for INTERNAL backend services.
      returned: success
      type: str
circuitBreakers:
  description:
  - Settings controlling the volume of connections to a backend service. This field
    is applicable only when the `load_balancing_scheme` is set to INTERNAL_MANAGED
    and the `protocol` is set to HTTP, HTTPS, or HTTP2.
  returned: success
  type: complex
  contains:
    maxRequestsPerConnection:
      description:
      - Maximum requests for a single backend connection. This parameter is respected
        by both the HTTP/1.1 and HTTP/2 implementations. If not specified, there is
        no limit. Setting this parameter to 1 will effectively disable keep alive.
      returned: success
      type: int
    maxConnections:
      description:
      - The maximum number of connections to the backend cluster.
      - Defaults to 1024.
      returned: success
      type: int
    maxPendingRequests:
      description:
      - The maximum number of pending requests to the backend cluster.
      - Defaults to 1024.
      returned: success
      type: int
    maxRequests:
      description:
      - The maximum number of parallel requests to the backend cluster.
      - Defaults to 1024.
      returned: success
      type: int
    maxRetries:
      description:
      - The maximum number of parallel retries to the backend cluster.
      - Defaults to 3.
      returned: success
      type: int
consistentHash:
  description:
  - Consistent Hash-based load balancing can be used to provide soft session affinity
    based on HTTP headers, cookies or other properties. This load balancing policy
    is applicable only for HTTP connections. The affinity to a particular destination
    host will be lost when one or more hosts are added/removed from the destination
    service. This field specifies parameters that control consistent hashing.
  - This field only applies when all of the following are true - * `load_balancing_scheme`
    is set to INTERNAL_MANAGED * `protocol` is set to HTTP, HTTPS, or HTTP2 * `locality_lb_policy`
    is set to MAGLEV or RING_HASH .
  returned: success
  type: complex
  contains:
    httpCookie:
      description:
      - Hash is based on HTTP Cookie. This field describes a HTTP cookie that will
        be used as the hash key for the consistent hash load balancer. If the cookie
        is not present, it will be generated.
      - This field is applicable if the sessionAffinity is set to HTTP_COOKIE.
      returned: success
      type: complex
      contains:
        ttl:
          description:
          - Lifetime of the cookie.
          returned: success
          type: complex
          contains:
            seconds:
              description:
              - Span of time at a resolution of a second.
              - Must be from 0 to 315,576,000,000 inclusive.
              returned: success
              type: int
            nanos:
              description:
              - Span of time that's a fraction of a second at nanosecond resolution.
                Durations less than one second are represented with a 0 seconds field
                and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
              returned: success
              type: int
        name:
          description:
          - Name of the cookie.
          returned: success
          type: str
        path:
          description:
          - Path to set for the cookie.
          returned: success
          type: str
    httpHeaderName:
      description:
      - The hash based on the value of the specified header field.
      - This field is applicable if the sessionAffinity is set to HEADER_FIELD.
      returned: success
      type: str
    minimumRingSize:
      description:
      - The minimum number of virtual nodes to use for the hash ring.
      - Larger ring sizes result in more granular load distributions. If the number
        of hosts in the load balancing pool is larger than the ring size, each host
        will be assigned a single virtual node.
      - Defaults to 1024.
      returned: success
      type: int
cdnPolicy:
  description:
  - Cloud CDN configuration for this BackendService.
  returned: success
  type: complex
  contains:
    cacheKeyPolicy:
      description:
      - The CacheKeyPolicy for this CdnPolicy.
      returned: success
      type: complex
      contains:
        includeHost:
          description:
          - If true requests to different hosts will be cached separately.
          returned: success
          type: bool
        includeProtocol:
          description:
          - If true, http and https requests will be cached separately.
          returned: success
          type: bool
        includeQueryString:
          description:
          - If true, include query string parameters in the cache key according to
            query_string_whitelist and query_string_blacklist. If neither is set,
            the entire query string will be included.
          - If false, the query string will be excluded from the cache key entirely.
          returned: success
          type: bool
        queryStringBlacklist:
          description:
          - Names of query string parameters to exclude in cache keys.
          - All other parameters will be included. Either specify query_string_whitelist
            or query_string_blacklist, not both.
          - "'&' and '=' will be percent encoded and not treated as delimiters."
          returned: success
          type: list
        queryStringWhitelist:
          description:
          - Names of query string parameters to include in cache keys.
          - All other parameters will be excluded. Either specify query_string_whitelist
            or query_string_blacklist, not both.
          - "'&' and '=' will be percent encoded and not treated as delimiters."
          returned: success
          type: list
    signedUrlCacheMaxAgeSec:
      description:
      - Maximum number of seconds the response to a signed URL request will be considered
        fresh, defaults to 1hr (3600s). After this time period, the response will
        be revalidated before being served.
      - 'When serving responses to signed URL requests, Cloud CDN will internally
        behave as though all responses from this backend had a "Cache-Control: public,
        max-age=[TTL]" header, regardless of any existing Cache-Control header. The
        actual headers served in responses will not be altered.'
      returned: success
      type: int
    defaultTtl:
      description:
      - Specifies the default TTL for cached content served by this origin for responses
        that do not have an existing valid TTL (max-age or s-max-age).
      returned: success
      type: int
    maxTtl:
      description:
      - Specifies the maximum allowed TTL for cached content served by this origin.
      returned: success
      type: int
    clientTtl:
      description:
      - Specifies the maximum allowed TTL for cached content served by this origin.
      returned: success
      type: int
    negativeCaching:
      description:
      - Negative caching allows per-status code TTLs to be set, in order to apply
        fine-grained caching for common errors or redirects.
      returned: success
      type: bool
    negativeCachingPolicy:
      description:
      - Sets a cache TTL for the specified HTTP status code. negativeCaching must
        be enabled to configure negativeCachingPolicy.
      - Omitting the policy and leaving negativeCaching enabled will use Cloud CDN's
        default cache TTLs.
      returned: success
      type: complex
      contains:
        code:
          description:
          - The HTTP status code to define a TTL against. Only HTTP status codes 300,
            301, 308, 404, 405, 410, 421, 451 and 501 can be specified as values,
            and you cannot specify a status code more than once.
          returned: success
          type: int
    cacheMode:
      description:
      - Specifies the cache setting for all responses from this backend.
      - 'The possible values are: USE_ORIGIN_HEADERS, FORCE_CACHE_ALL and CACHE_ALL_STATIC
        .'
      returned: success
      type: str
    serveWhileStale:
      description:
      - Serve existing content from the cache (if available) when revalidating content
        with the origin, or when an error is encountered when refreshing the cache.
      returned: success
      type: int
connectionDraining:
  description:
  - Settings for connection draining .
  returned: success
  type: complex
  contains:
    drainingTimeoutSec:
      description:
      - Time for which instance will be drained (not accept new connections, but still
        work to finish started).
      returned: success
      type: int
creationTimestamp:
  description:
  - Creation timestamp in RFC3339 text format.
  returned: success
  type: str
description:
  description:
  - An optional description of this resource.
  returned: success
  type: str
failoverPolicy:
  description:
  - Policy for failovers.
  returned: success
  type: complex
  contains:
    disableConnectionDrainOnFailover:
      description:
      - 'On failover or failback, this field indicates whether connection drain will
        be honored. Setting this to true has the following effect: connections to
        the old active pool are not drained. Connections to the new active pool use
        the timeout of 10 min (currently fixed). Setting to false has the following
        effect: both old and new connections will have a drain timeout of 10 min.'
      - This can be set to true only if the protocol is TCP.
      - The default is false.
      returned: success
      type: bool
    dropTrafficIfUnhealthy:
      description:
      - This option is used only when no healthy VMs are detected in the primary and
        backup instance groups. When set to true, traffic is dropped. When set to
        false, new connections are sent across all VMs in the primary group.
      - The default is false.
      returned: success
      type: bool
    failoverRatio:
      description:
      - The value of the field must be in [0, 1]. If the ratio of the healthy VMs
        in the primary backend is at or below this number, traffic arriving at the
        load-balanced IP will be directed to the failover backend.
      - In case where 'failoverRatio' is not set or all the VMs in the backup backend
        are unhealthy, the traffic will be directed back to the primary backend in
        the "force" mode, where traffic will be spread to the healthy VMs with the
        best effort, or to all VMs when no VM is healthy.
      - This field is only used with l4 load balancing.
      returned: success
      type: str
enableCDN:
  description:
  - If true, enable Cloud CDN for this RegionBackendService.
  returned: success
  type: bool
fingerprint:
  description:
  - Fingerprint of this resource. A hash of the contents stored in this object. This
    field is used in optimistic locking.
  returned: success
  type: str
healthChecks:
  description:
  - The set of URLs to HealthCheck resources for health checking this RegionBackendService.
    Currently at most one health check can be specified.
  - A health check must be specified unless the backend service uses an internet or
    serverless NEG as a backend.
  returned: success
  type: list
id:
  description:
  - The unique identifier for the resource.
  returned: success
  type: int
loadBalancingScheme:
  description:
  - Indicates what kind of load balancing this regional backend service will be used
    for. A backend service created for one type of load balancing cannot be used with
    the other(s).
  returned: success
  type: str
localityLbPolicy:
  description:
  - The load balancing algorithm used within the scope of the locality.
  - The possible values are - * ROUND_ROBIN - This is a simple policy in which each
    healthy backend is selected in round robin order.
  - "* LEAST_REQUEST - An O(1) algorithm which selects two random healthy hosts and
    picks the host which has fewer active requests."
  - "* RING_HASH - The ring/modulo hash load balancer implements consistent hashing
    to backends. The algorithm has the property that the addition/removal of a host
    from a set of N hosts only affects 1/N of the requests."
  - "* RANDOM - The load balancer selects a random healthy host."
  - "* ORIGINAL_DESTINATION - Backend host is selected based on the client connection
    metadata, i.e., connections are opened to the same address as the destination
    address of the incoming connection before the connection was redirected to the
    load balancer."
  - "* MAGLEV - used as a drop in replacement for the ring hash load balancer."
  - Maglev is not as stable as ring hash but has faster table lookup build times and
    host selection times. For more information about Maglev, refer to https://ai.google/research/pubs/pub44824
    This field is applicable only when the `load_balancing_scheme` is set to INTERNAL_MANAGED
    and the `protocol` is set to HTTP, HTTPS, or HTTP2.
  returned: success
  type: str
name:
  description:
  - Name of the resource. Provided by the client when the resource is created. The
    name must be 1-63 characters long, and comply with RFC1035. Specifically, the
    name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`
    which means the first character must be a lowercase letter, and all following
    characters must be a dash, lowercase letter, or digit, except the last character,
    which cannot be a dash.
  returned: success
  type: str
outlierDetection:
  description:
  - Settings controlling eviction of unhealthy hosts from the load balancing pool.
  - This field is applicable only when the `load_balancing_scheme` is set to INTERNAL_MANAGED
    and the `protocol` is set to HTTP, HTTPS, or HTTP2.
  returned: success
  type: complex
  contains:
    baseEjectionTime:
      description:
      - The base time that a host is ejected for. The real time is equal to the base
        time multiplied by the number of times the host has been ejected. Defaults
        to 30000ms or 30s.
      returned: success
      type: complex
      contains:
        seconds:
          description:
          - Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
            inclusive.
          returned: success
          type: int
        nanos:
          description:
          - Span of time that's a fraction of a second at nanosecond resolution. Durations
            less than one second are represented with a 0 `seconds` field and a positive
            `nanos` field. Must be from 0 to 999,999,999 inclusive.
          returned: success
          type: int
    consecutiveErrors:
      description:
      - Number of errors before a host is ejected from the connection pool. When the
        backend host is accessed over HTTP, a 5xx return code qualifies as an error.
      - Defaults to 5.
      returned: success
      type: int
    consecutiveGatewayFailure:
      description:
      - The number of consecutive gateway failures (502, 503, 504 status or connection
        errors that are mapped to one of those status codes) before a consecutive
        gateway failure ejection occurs. Defaults to 5.
      returned: success
      type: int
    enforcingConsecutiveErrors:
      description:
      - The percentage chance that a host will be actually ejected when an outlier
        status is detected through consecutive 5xx. This setting can be used to disable
        ejection or to ramp it up slowly. Defaults to 100.
      returned: success
      type: int
    enforcingConsecutiveGatewayFailure:
      description:
      - The percentage chance that a host will be actually ejected when an outlier
        status is detected through consecutive gateway failures. This setting can
        be used to disable ejection or to ramp it up slowly. Defaults to 0.
      returned: success
      type: int
    enforcingSuccessRate:
      description:
      - The percentage chance that a host will be actually ejected when an outlier
        status is detected through success rate statistics. This setting can be used
        to disable ejection or to ramp it up slowly. Defaults to 100.
      returned: success
      type: int
    interval:
      description:
      - Time interval between ejection sweep analysis. This can result in both new
        ejections as well as hosts being returned to service. Defaults to 10 seconds.
      returned: success
      type: complex
      contains:
        seconds:
          description:
          - Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
            inclusive.
          returned: success
          type: int
        nanos:
          description:
          - Span of time that's a fraction of a second at nanosecond resolution. Durations
            less than one second are represented with a 0 `seconds` field and a positive
            `nanos` field. Must be from 0 to 999,999,999 inclusive.
          returned: success
          type: int
    maxEjectionPercent:
      description:
      - Maximum percentage of hosts in the load balancing pool for the backend service
        that can be ejected. Defaults to 10%.
      returned: success
      type: int
    successRateMinimumHosts:
      description:
      - The number of hosts in a cluster that must have enough request volume to detect
        success rate outliers. If the number of hosts is less than this setting, outlier
        detection via success rate statistics is not performed for any host in the
        cluster. Defaults to 5.
      returned: success
      type: int
    successRateRequestVolume:
      description:
      - The minimum number of total requests that must be collected in one interval
        (as defined by the interval duration above) to include this host in success
        rate based outlier detection. If the volume is lower than this setting, outlier
        detection via success rate statistics is not performed for that host. Defaults
        to 100.
      returned: success
      type: int
    successRateStdevFactor:
      description:
      - 'This factor is used to determine the ejection threshold for success rate
        outlier ejection. The ejection threshold is the difference between the mean
        success rate, and the product of this factor and the standard deviation of
        the mean success rate: mean - (stdev * success_rate_stdev_factor). This factor
        is divided by a thousand to get a double. That is, if the desired factor is
        1.9, the runtime value should be 1900. Defaults to 1900.'
      returned: success
      type: int
portName:
  description:
  - A named port on a backend instance group representing the port for communication
    to the backend VMs in that group. Required when the loadBalancingScheme is EXTERNAL,
    INTERNAL_MANAGED, or INTERNAL_SELF_MANAGED and the backends are instance groups.
    The named port must be defined on each backend instance group. This parameter
    has no meaning if the backends are NEGs. API sets a default of "http" if not given.
  - Must be omitted when the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load
    Balancing).
  returned: success
  type: str
protocol:
  description:
  - The protocol this RegionBackendService uses to communicate with backends.
  - 'The default is HTTP. **NOTE**: HTTP2 is only valid for beta HTTP/2 load balancer
    types and may result in errors if used with the GA API.'
  returned: success
  type: str
sessionAffinity:
  description:
  - Type of session affinity to use. The default is NONE. Session affinity is not
    applicable if the protocol is UDP.
  returned: success
  type: str
timeoutSec:
  description:
  - How many seconds to wait for the backend before considering it a failed request.
    Default is 30 seconds. Valid range is [1, 86400].
  returned: success
  type: int
logConfig:
  description:
  - This field denotes the logging options for the load balancer traffic served by
    this backend service.
  - If logging is enabled, logs will be exported to Stackdriver.
  returned: success
  type: complex
  contains:
    enable:
      description:
      - Whether to enable logging for the load balancer traffic served by this backend
        service.
      returned: success
      type: bool
    sampleRate:
      description:
      - This field can only be specified if logging is enabled for this backend service.
        The value of the field must be in [0, 1]. This configures the sampling rate
        of requests to the load balancer where 1.0 means all logged requests are reported
        and 0.0 means no logged requests are reported.
      - The default value is 1.0.
      returned: success
      type: str
network:
  description:
  - The URL of the network to which this backend service belongs.
  - This field can only be specified when the load balancing scheme is set to INTERNAL.
  returned: success
  type: dict
region:
  description:
  - A reference to the region where the regional backend service resides.
  returned: success
  type: str
'''

################################################################################
# Imports
################################################################################

from ansible_collections.google.cloud.plugins.module_utils.gcp_utils import (
    navigate_hash,
    GcpSession,
    GcpModule,
    GcpRequest,
    remove_nones_from_dict,
    replace_resource_dict,
)
import json
import time

################################################################################
# Main
################################################################################


def main():
    """Main function"""

    module = GcpModule(
        argument_spec=dict(
            state=dict(default='present', choices=['present', 'absent'], type='str'),
            affinity_cookie_ttl_sec=dict(type='int'),
            backends=dict(
                type='list',
                elements='dict',
                options=dict(
                    balancing_mode=dict(default='CONNECTION', type='str'),
                    capacity_scaler=dict(type='str'),
                    description=dict(type='str'),
                    failover=dict(type='bool'),
                    group=dict(required=True, type='str'),
                    max_connections=dict(type='int'),
                    max_connections_per_instance=dict(type='int'),
                    max_connections_per_endpoint=dict(type='int'),
                    max_rate=dict(type='int'),
                    max_rate_per_instance=dict(type='str'),
                    max_rate_per_endpoint=dict(type='str'),
                    max_utilization=dict(type='str'),
                ),
            ),
            circuit_breakers=dict(
                type='dict',
                options=dict(
                    max_requests_per_connection=dict(type='int'),
                    max_connections=dict(default=1024, type='int'),
                    max_pending_requests=dict(default=1024, type='int'),
                    max_requests=dict(default=1024, type='int'),
                    max_retries=dict(default=3, type='int'),
                ),
            ),
            consistent_hash=dict(
                type='dict',
                options=dict(
                    http_cookie=dict(
                        type='dict',
                        options=dict(
                            ttl=dict(type='dict', options=dict(seconds=dict(required=True, type='int'), nanos=dict(type='int'))),
                            name=dict(type='str'),
                            path=dict(type='str'),
                        ),
                    ),
                    http_header_name=dict(type='str'),
                    minimum_ring_size=dict(default=1024, type='int'),
                ),
            ),
            cdn_policy=dict(
                type='dict',
                options=dict(
                    cache_key_policy=dict(
                        type='dict',
                        options=dict(
                            include_host=dict(type='bool'),
                            include_protocol=dict(type='bool'),
                            include_query_string=dict(type='bool'),
                            query_string_blacklist=dict(type='list', elements='str'),
                            query_string_whitelist=dict(type='list', elements='str'),
                        ),
                    ),
                    signed_url_cache_max_age_sec=dict(default=3600, type='int'),
                    default_ttl=dict(type='int'),
                    max_ttl=dict(type='int'),
                    client_ttl=dict(type='int'),
                    negative_caching=dict(type='bool'),
                    negative_caching_policy=dict(type='list', elements='dict', options=dict(code=dict(type='int'))),
                    cache_mode=dict(type='str'),
                    serve_while_stale=dict(type='int'),
                ),
            ),
            connection_draining=dict(type='dict', options=dict(draining_timeout_sec=dict(default=300, type='int'))),
            description=dict(type='str'),
            failover_policy=dict(
                type='dict',
                options=dict(
                    disable_connection_drain_on_failover=dict(type='bool'), drop_traffic_if_unhealthy=dict(type='bool'), failover_ratio=dict(type='str')
                ),
            ),
            enable_cdn=dict(type='bool'),
            health_checks=dict(type='list', elements='str'),
            load_balancing_scheme=dict(default='INTERNAL', type='str'),
            locality_lb_policy=dict(type='str'),
            name=dict(required=True, type='str'),
            outlier_detection=dict(
                type='dict',
                options=dict(
                    base_ejection_time=dict(type='dict', options=dict(seconds=dict(required=True, type='int'), nanos=dict(type='int'))),
                    consecutive_errors=dict(default=5, type='int'),
                    consecutive_gateway_failure=dict(default=5, type='int'),
                    enforcing_consecutive_errors=dict(default=100, type='int'),
                    enforcing_consecutive_gateway_failure=dict(default=0, type='int'),
                    enforcing_success_rate=dict(default=100, type='int'),
                    interval=dict(type='dict', options=dict(seconds=dict(required=True, type='int'), nanos=dict(type='int'))),
                    max_ejection_percent=dict(default=10, type='int'),
                    success_rate_minimum_hosts=dict(default=5, type='int'),
                    success_rate_request_volume=dict(default=100, type='int'),
                    success_rate_stdev_factor=dict(default=1900, type='int'),
                ),
            ),
            port_name=dict(type='str'),
            protocol=dict(type='str'),
            session_affinity=dict(type='str'),
            timeout_sec=dict(type='int'),
            log_config=dict(type='dict', options=dict(enable=dict(type='bool'), sample_rate=dict(type='str'))),
            network=dict(type='dict'),
            region=dict(required=True, type='str'),
        )
    )

    if not module.params['scopes']:
        module.params['scopes'] = ['https://www.googleapis.com/auth/compute']

    state = module.params['state']
    kind = 'compute#backendService'

    fetch = fetch_resource(module, self_link(module), kind)
    changed = False

    if fetch:
        if state == 'present':
            if is_different(module, fetch):
                update(module, self_link(module), kind)
                fetch = fetch_resource(module, self_link(module), kind)
                changed = True
        else:
            delete(module, self_link(module), kind)
            fetch = {}
            changed = True
    else:
        if state == 'present':
            fetch = create(module, collection(module), kind)
            changed = True
        else:
            fetch = {}

    fetch.update({'changed': changed})

    module.exit_json(**fetch)


def create(module, link, kind):
    auth = GcpSession(module, 'compute')
    return wait_for_operation(module, auth.post(link, resource_to_request(module)))


def update(module, link, kind):
    auth = GcpSession(module, 'compute')
    return wait_for_operation(module, auth.put(link, resource_to_request(module)))


def delete(module, link, kind):
    auth = GcpSession(module, 'compute')
    return wait_for_operation(module, auth.delete(link))


def resource_to_request(module):
    request = {
        u'kind': 'compute#backendService',
        u'affinityCookieTtlSec': module.params.get('affinity_cookie_ttl_sec'),
        u'backends': RegionBackendServiceBackendsArray(module.params.get('backends', []), module).to_request(),
        u'circuitBreakers': RegionBackendServiceCircuitbreakers(module.params.get('circuit_breakers', {}), module).to_request(),
        u'consistentHash': RegionBackendServiceConsistenthash(module.params.get('consistent_hash', {}), module).to_request(),
        u'cdnPolicy': RegionBackendServiceCdnpolicy(module.params.get('cdn_policy', {}), module).to_request(),
        u'connectionDraining': RegionBackendServiceConnectiondraining(module.params.get('connection_draining', {}), module).to_request(),
        u'description': module.params.get('description'),
        u'failoverPolicy': RegionBackendServiceFailoverpolicy(module.params.get('failover_policy', {}), module).to_request(),
        u'enableCDN': module.params.get('enable_cdn'),
        u'healthChecks': module.params.get('health_checks'),
        u'loadBalancingScheme': module.params.get('load_balancing_scheme'),
        u'localityLbPolicy': module.params.get('locality_lb_policy'),
        u'name': module.params.get('name'),
        u'outlierDetection': RegionBackendServiceOutlierdetection(module.params.get('outlier_detection', {}), module).to_request(),
        u'portName': module.params.get('port_name'),
        u'protocol': module.params.get('protocol'),
        u'sessionAffinity': module.params.get('session_affinity'),
        u'timeoutSec': module.params.get('timeout_sec'),
        u'logConfig': RegionBackendServiceLogconfig(module.params.get('log_config', {}), module).to_request(),
        u'network': replace_resource_dict(module.params.get(u'network', {}), 'selfLink'),
    }
    return_vals = {}
    for k, v in request.items():
        if v or v is False:
            return_vals[k] = v

    return return_vals


def fetch_resource(module, link, kind, allow_not_found=True):
    auth = GcpSession(module, 'compute')
    return return_if_object(module, auth.get(link), kind, allow_not_found)


def self_link(module):
    return "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices/{name}".format(**module.params)


def collection(module):
    return "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices".format(**module.params)


def return_if_object(module, response, kind, allow_not_found=False):
    # If not found, return nothing.
    if allow_not_found and response.status_code == 404:
        return None

    # If no content, return nothing.
    if response.status_code == 204:
        return None

    try:
        module.raise_for_status(response)
        result = response.json()
    except getattr(json.decoder, 'JSONDecodeError', ValueError):
        module.fail_json(msg="Invalid JSON response with error: %s" % response.text)

    if navigate_hash(result, ['error', 'errors']):
        module.fail_json(msg=navigate_hash(result, ['error', 'errors']))

    return result


def is_different(module, response):
    request = resource_to_request(module)
    response = response_to_hash(module, response)

    # Remove all output-only from response.
    response_vals = {}
    for k, v in response.items():
        if k in request:
            response_vals[k] = v

    request_vals = {}
    for k, v in request.items():
        if k in response:
            request_vals[k] = v

    return GcpRequest(request_vals) != GcpRequest(response_vals)


# Remove unnecessary properties from the response.
# This is for doing comparisons with Ansible's current parameters.
def response_to_hash(module, response):
    return {
        u'affinityCookieTtlSec': response.get(u'affinityCookieTtlSec'),
        u'backends': RegionBackendServiceBackendsArray(response.get(u'backends', []), module).from_response(),
        u'circuitBreakers': RegionBackendServiceCircuitbreakers(response.get(u'circuitBreakers', {}), module).from_response(),
        u'consistentHash': RegionBackendServiceConsistenthash(response.get(u'consistentHash', {}), module).from_response(),
        u'cdnPolicy': RegionBackendServiceCdnpolicy(response.get(u'cdnPolicy', {}), module).from_response(),
        u'connectionDraining': RegionBackendServiceConnectiondraining(response.get(u'connectionDraining', {}), module).from_response(),
        u'creationTimestamp': response.get(u'creationTimestamp'),
        u'description': response.get(u'description'),
        u'failoverPolicy': RegionBackendServiceFailoverpolicy(response.get(u'failoverPolicy', {}), module).from_response(),
        u'enableCDN': response.get(u'enableCDN'),
        u'fingerprint': response.get(u'fingerprint'),
        u'healthChecks': response.get(u'healthChecks'),
        u'id': response.get(u'id'),
        u'loadBalancingScheme': module.params.get('load_balancing_scheme'),
        u'localityLbPolicy': response.get(u'localityLbPolicy'),
        u'name': module.params.get('name'),
        u'outlierDetection': RegionBackendServiceOutlierdetection(response.get(u'outlierDetection', {}), module).from_response(),
        u'portName': response.get(u'portName'),
        u'protocol': response.get(u'protocol'),
        u'sessionAffinity': response.get(u'sessionAffinity'),
        u'timeoutSec': response.get(u'timeoutSec'),
        u'logConfig': RegionBackendServiceLogconfig(response.get(u'logConfig', {}), module).from_response(),
        u'network': response.get(u'network'),
    }


def async_op_url(module, extra_data=None):
    if extra_data is None:
        extra_data = {}
    url = "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/operations/{op_id}"
    combined = extra_data.copy()
    combined.update(module.params)
    return url.format(**combined)


def wait_for_operation(module, response):
    op_result = return_if_object(module, response, 'compute#operation')
    if op_result is None:
        return {}
    status = navigate_hash(op_result, ['status'])
    wait_done = wait_for_completion(status, op_result, module)
    return fetch_resource(module, navigate_hash(wait_done, ['targetLink']), 'compute#backendService')


def wait_for_completion(status, op_result, module):
    op_id = navigate_hash(op_result, ['name'])
    op_uri = async_op_url(module, {'op_id': op_id})
    while status != 'DONE':
        raise_if_errors(op_result, ['error', 'errors'], module)
        time.sleep(1.0)
        op_result = fetch_resource(module, op_uri, 'compute#operation', False)
        status = navigate_hash(op_result, ['status'])
    return op_result


def raise_if_errors(response, err_path, module):
    errors = navigate_hash(response, err_path)
    if errors is not None:
        module.fail_json(msg=errors)


class RegionBackendServiceBackendsArray(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = []

    def to_request(self):
        items = []
        for item in self.request:
            items.append(self._request_for_item(item))
        return items

    def from_response(self):
        items = []
        for item in self.request:
            items.append(self._response_from_item(item))
        return items

    def _request_for_item(self, item):
        return remove_nones_from_dict(
            {
                u'balancingMode': item.get('balancing_mode'),
                u'capacityScaler': item.get('capacity_scaler'),
                u'description': item.get('description'),
                u'failover': item.get('failover'),
                u'group': item.get('group'),
                u'maxConnections': item.get('max_connections'),
                u'maxConnectionsPerInstance': item.get('max_connections_per_instance'),
                u'maxConnectionsPerEndpoint': item.get('max_connections_per_endpoint'),
                u'maxRate': item.get('max_rate'),
                u'maxRatePerInstance': item.get('max_rate_per_instance'),
                u'maxRatePerEndpoint': item.get('max_rate_per_endpoint'),
                u'maxUtilization': item.get('max_utilization'),
            }
        )

    def _response_from_item(self, item):
        return remove_nones_from_dict(
            {
                u'balancingMode': item.get(u'balancingMode'),
                u'capacityScaler': item.get(u'capacityScaler'),
                u'description': item.get(u'description'),
                u'failover': item.get(u'failover'),
                u'group': item.get(u'group'),
                u'maxConnections': item.get(u'maxConnections'),
                u'maxConnectionsPerInstance': item.get(u'maxConnectionsPerInstance'),
                u'maxConnectionsPerEndpoint': item.get(u'maxConnectionsPerEndpoint'),
                u'maxRate': item.get(u'maxRate'),
                u'maxRatePerInstance': item.get(u'maxRatePerInstance'),
                u'maxRatePerEndpoint': item.get(u'maxRatePerEndpoint'),
                u'maxUtilization': item.get(u'maxUtilization'),
            }
        )


class RegionBackendServiceCircuitbreakers(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = {}

    def to_request(self):
        return remove_nones_from_dict(
            {
                u'maxRequestsPerConnection': self.request.get('max_requests_per_connection'),
                u'maxConnections': self.request.get('max_connections'),
                u'maxPendingRequests': self.request.get('max_pending_requests'),
                u'maxRequests': self.request.get('max_requests'),
                u'maxRetries': self.request.get('max_retries'),
            }
        )

    def from_response(self):
        return remove_nones_from_dict(
            {
                u'maxRequestsPerConnection': self.request.get(u'maxRequestsPerConnection'),
                u'maxConnections': self.request.get(u'maxConnections'),
                u'maxPendingRequests': self.request.get(u'maxPendingRequests'),
                u'maxRequests': self.request.get(u'maxRequests'),
                u'maxRetries': self.request.get(u'maxRetries'),
            }
        )


class RegionBackendServiceConsistenthash(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = {}

    def to_request(self):
        return remove_nones_from_dict(
            {
                u'httpCookie': RegionBackendServiceHttpcookie(self.request.get('http_cookie', {}), self.module).to_request(),
                u'httpHeaderName': self.request.get('http_header_name'),
                u'minimumRingSize': self.request.get('minimum_ring_size'),
            }
        )

    def from_response(self):
        return remove_nones_from_dict(
            {
                u'httpCookie': RegionBackendServiceHttpcookie(self.request.get(u'httpCookie', {}), self.module).from_response(),
                u'httpHeaderName': self.request.get(u'httpHeaderName'),
                u'minimumRingSize': self.request.get(u'minimumRingSize'),
            }
        )


class RegionBackendServiceHttpcookie(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = {}

    def to_request(self):
        return remove_nones_from_dict(
            {
                u'ttl': RegionBackendServiceTtl(self.request.get('ttl', {}), self.module).to_request(),
                u'name': self.request.get('name'),
                u'path': self.request.get('path'),
            }
        )

    def from_response(self):
        return remove_nones_from_dict(
            {
                u'ttl': RegionBackendServiceTtl(self.request.get(u'ttl', {}), self.module).from_response(),
                u'name': self.request.get(u'name'),
                u'path': self.request.get(u'path'),
            }
        )


class RegionBackendServiceTtl(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = {}

    def to_request(self):
        return remove_nones_from_dict({u'seconds': self.request.get('seconds'), u'nanos': self.request.get('nanos')})

    def from_response(self):
        return remove_nones_from_dict({u'seconds': self.request.get(u'seconds'), u'nanos': self.request.get(u'nanos')})


class RegionBackendServiceCdnpolicy(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = {}

    def to_request(self):
        return remove_nones_from_dict(
            {
                u'cacheKeyPolicy': RegionBackendServiceCachekeypolicy(self.request.get('cache_key_policy', {}), self.module).to_request(),
                u'signedUrlCacheMaxAgeSec': self.request.get('signed_url_cache_max_age_sec'),
                u'defaultTtl': self.request.get('default_ttl'),
                u'maxTtl': self.request.get('max_ttl'),
                u'clientTtl': self.request.get('client_ttl'),
                u'negativeCaching': self.request.get('negative_caching'),
                u'negativeCachingPolicy': RegionBackendServiceNegativecachingpolicyArray(
                    self.request.get('negative_caching_policy', []), self.module
                ).to_request(),
                u'cacheMode': self.request.get('cache_mode'),
                u'serveWhileStale': self.request.get('serve_while_stale'),
            }
        )

    def from_response(self):
        return remove_nones_from_dict(
            {
                u'cacheKeyPolicy': RegionBackendServiceCachekeypolicy(self.request.get(u'cacheKeyPolicy', {}), self.module).from_response(),
                u'signedUrlCacheMaxAgeSec': self.request.get(u'signedUrlCacheMaxAgeSec'),
                u'defaultTtl': self.request.get(u'defaultTtl'),
                u'maxTtl': self.request.get(u'maxTtl'),
                u'clientTtl': self.request.get(u'clientTtl'),
                u'negativeCaching': self.request.get(u'negativeCaching'),
                u'negativeCachingPolicy': RegionBackendServiceNegativecachingpolicyArray(
                    self.request.get(u'negativeCachingPolicy', []), self.module
                ).from_response(),
                u'cacheMode': self.request.get(u'cacheMode'),
                u'serveWhileStale': self.request.get(u'serveWhileStale'),
            }
        )


class RegionBackendServiceCachekeypolicy(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = {}

    def to_request(self):
        return remove_nones_from_dict(
            {
                u'includeHost': self.request.get('include_host'),
                u'includeProtocol': self.request.get('include_protocol'),
                u'includeQueryString': self.request.get('include_query_string'),
                u'queryStringBlacklist': self.request.get('query_string_blacklist'),
                u'queryStringWhitelist': self.request.get('query_string_whitelist'),
            }
        )

    def from_response(self):
        return remove_nones_from_dict(
            {
                u'includeHost': self.request.get(u'includeHost'),
                u'includeProtocol': self.request.get(u'includeProtocol'),
                u'includeQueryString': self.request.get(u'includeQueryString'),
                u'queryStringBlacklist': self.request.get(u'queryStringBlacklist'),
                u'queryStringWhitelist': self.request.get(u'queryStringWhitelist'),
            }
        )


class RegionBackendServiceNegativecachingpolicyArray(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = []

    def to_request(self):
        items = []
        for item in self.request:
            items.append(self._request_for_item(item))
        return items

    def from_response(self):
        items = []
        for item in self.request:
            items.append(self._response_from_item(item))
        return items

    def _request_for_item(self, item):
        return remove_nones_from_dict({u'code': item.get('code')})

    def _response_from_item(self, item):
        return remove_nones_from_dict({u'code': item.get(u'code')})


class RegionBackendServiceConnectiondraining(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = {}

    def to_request(self):
        return remove_nones_from_dict({u'drainingTimeoutSec': self.request.get('draining_timeout_sec')})

    def from_response(self):
        return remove_nones_from_dict({u'drainingTimeoutSec': self.request.get(u'drainingTimeoutSec')})


class RegionBackendServiceFailoverpolicy(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = {}

    def to_request(self):
        return remove_nones_from_dict(
            {
                u'disableConnectionDrainOnFailover': self.request.get('disable_connection_drain_on_failover'),
                u'dropTrafficIfUnhealthy': self.request.get('drop_traffic_if_unhealthy'),
                u'failoverRatio': self.request.get('failover_ratio'),
            }
        )

    def from_response(self):
        return remove_nones_from_dict(
            {
                u'disableConnectionDrainOnFailover': self.request.get(u'disableConnectionDrainOnFailover'),
                u'dropTrafficIfUnhealthy': self.request.get(u'dropTrafficIfUnhealthy'),
                u'failoverRatio': self.request.get(u'failoverRatio'),
            }
        )


class RegionBackendServiceOutlierdetection(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = {}

    def to_request(self):
        return remove_nones_from_dict(
            {
                u'baseEjectionTime': RegionBackendServiceBaseejectiontime(self.request.get('base_ejection_time', {}), self.module).to_request(),
                u'consecutiveErrors': self.request.get('consecutive_errors'),
                u'consecutiveGatewayFailure': self.request.get('consecutive_gateway_failure'),
                u'enforcingConsecutiveErrors': self.request.get('enforcing_consecutive_errors'),
                u'enforcingConsecutiveGatewayFailure': self.request.get('enforcing_consecutive_gateway_failure'),
                u'enforcingSuccessRate': self.request.get('enforcing_success_rate'),
                u'interval': RegionBackendServiceInterval(self.request.get('interval', {}), self.module).to_request(),
                u'maxEjectionPercent': self.request.get('max_ejection_percent'),
                u'successRateMinimumHosts': self.request.get('success_rate_minimum_hosts'),
                u'successRateRequestVolume': self.request.get('success_rate_request_volume'),
                u'successRateStdevFactor': self.request.get('success_rate_stdev_factor'),
            }
        )

    def from_response(self):
        return remove_nones_from_dict(
            {
                u'baseEjectionTime': RegionBackendServiceBaseejectiontime(self.request.get(u'baseEjectionTime', {}), self.module).from_response(),
                u'consecutiveErrors': self.request.get(u'consecutiveErrors'),
                u'consecutiveGatewayFailure': self.request.get(u'consecutiveGatewayFailure'),
                u'enforcingConsecutiveErrors': self.request.get(u'enforcingConsecutiveErrors'),
                u'enforcingConsecutiveGatewayFailure': self.request.get(u'enforcingConsecutiveGatewayFailure'),
                u'enforcingSuccessRate': self.request.get(u'enforcingSuccessRate'),
                u'interval': RegionBackendServiceInterval(self.request.get(u'interval', {}), self.module).from_response(),
                u'maxEjectionPercent': self.request.get(u'maxEjectionPercent'),
                u'successRateMinimumHosts': self.request.get(u'successRateMinimumHosts'),
                u'successRateRequestVolume': self.request.get(u'successRateRequestVolume'),
                u'successRateStdevFactor': self.request.get(u'successRateStdevFactor'),
            }
        )


class RegionBackendServiceBaseejectiontime(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = {}

    def to_request(self):
        return remove_nones_from_dict({u'seconds': self.request.get('seconds'), u'nanos': self.request.get('nanos')})

    def from_response(self):
        return remove_nones_from_dict({u'seconds': self.request.get(u'seconds'), u'nanos': self.request.get(u'nanos')})


class RegionBackendServiceInterval(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = {}

    def to_request(self):
        return remove_nones_from_dict({u'seconds': self.request.get('seconds'), u'nanos': self.request.get('nanos')})

    def from_response(self):
        return remove_nones_from_dict({u'seconds': self.request.get(u'seconds'), u'nanos': self.request.get(u'nanos')})


class RegionBackendServiceLogconfig(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = {}

    def to_request(self):
        return remove_nones_from_dict({u'enable': self.request.get('enable'), u'sampleRate': self.request.get('sample_rate')})

    def from_response(self):
        return remove_nones_from_dict({u'enable': self.request.get(u'enable'), u'sampleRate': self.request.get(u'sampleRate')})


if __name__ == '__main__':
    main()
