/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.8.6
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 27 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qpygui_qvector.sip"
#include <qvector.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQVector1900.cpp"



extern "C" {static void assign_QVector_1900(void *, Py_ssize_t, void *);}
static void assign_QVector_1900(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<::QVector<uint> *>(sipDst)[sipDstIdx] = *reinterpret_cast<::QVector<uint> *>(sipSrc);
}


extern "C" {static void *array_QVector_1900(Py_ssize_t);}
static void *array_QVector_1900(Py_ssize_t sipNrElem)
{
    return new ::QVector<uint>[sipNrElem];
}


extern "C" {static void *copy_QVector_1900(const void *, Py_ssize_t);}
static void *copy_QVector_1900(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QVector<uint>(reinterpret_cast<const ::QVector<uint> *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_QVector_1900(void *, int);}
static void release_QVector_1900(void *sipCppV, int)
{
    ::QVector<uint> *sipCpp = reinterpret_cast<::QVector<uint> *>(sipCppV);
    delete sipCpp;
}



extern "C" {static int convertTo_QVector_1900(PyObject *, void **, int *, PyObject *);}
static int convertTo_QVector_1900(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj)
{
    ::QVector<uint> **sipCppPtr = reinterpret_cast<::QVector<uint> **>(sipCppPtrV);

#line 56 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qpygui_qvector.sip"
    PyObject *iter = PyObject_GetIter(sipPy);

    if (!sipIsErr)
    {
        PyErr_Clear();
        Py_XDECREF(iter);

        return (iter
#if PY_MAJOR_VERSION < 3
                && !PyString_Check(sipPy)
#endif
                && !PyUnicode_Check(sipPy));
    }

    if (!iter)
    {
        *sipIsErr = 1;

        return 0;
    }

    QVector<unsigned> *qv = new QVector<unsigned>;

    for (Py_ssize_t i = 0; ; ++i)
    {
        PyErr_Clear();
        PyObject *itm = PyIter_Next(iter);

        if (!itm)
        {
            if (PyErr_Occurred())
            {
                delete qv;
                Py_DECREF(iter);
                *sipIsErr = 1;

                return 0;
            }

            break;
        }

        PyErr_Clear();
        unsigned long val = PyLong_AsUnsignedLongMask(itm);

        if (PyErr_Occurred())
        {
            PyErr_Format(PyExc_TypeError,
                    "index %zd has type '%s' but 'int' is expected", i,
                    sipPyTypeName(Py_TYPE(itm)));

            Py_DECREF(itm);
            delete qv;
            Py_DECREF(iter);
            *sipIsErr = 1;

            return 0;
        }

        qv->append(val);

        Py_DECREF(itm);
    }

    Py_DECREF(iter);

    *sipCppPtr = qv;

    return sipGetState(sipTransferObj);
#line 139 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQVector1900.cpp"
}


extern "C" {static PyObject *convertFrom_QVector_1900(void *, PyObject *);}
static PyObject *convertFrom_QVector_1900(void *sipCppV, PyObject *)
{
    ::QVector<uint> *sipCpp = reinterpret_cast<::QVector<uint> *>(sipCppV);

#line 31 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qpygui_qvector.sip"
    PyObject *l = PyList_New(sipCpp->size());

    if (!l)
        return 0;

    for (int i = 0; i < sipCpp->size(); ++i)
    {
        // Convert to a Python long to make sure it doesn't get interpreted as
        // a signed value.
        PyObject *pobj = PyLong_FromUnsignedLong(sipCpp->value(i));

        if (!pobj)
        {
            Py_DECREF(l);

            return 0;
        }

        PyList_SetItem(l, i, pobj);
    }

    return l;
#line 171 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQVector1900.cpp"
}


sipMappedTypeDef sipTypeDef_QtGui_QVector_1900 = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_30598,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        -1,
        {0, 0, 1},
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
    },
    assign_QVector_1900,
    array_QVector_1900,
    copy_QVector_1900,
    release_QVector_1900,
    convertTo_QVector_1900,
    convertFrom_QVector_1900
};
