/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.hunspell;

import com.google.common.base.Suppliers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.spelling.hunspell.HunspellRule;
import org.languagetool.rules.spelling.morfologik.MorfologikMultiSpeller;
import org.languagetool.tokenizers.CompoundWordTokenizer;
import org.languagetool.tools.StringTools;

public abstract class CompoundAwareHunspellRule
extends HunspellRule {
    private static final int MAX_SUGGESTIONS = 20;
    private final CompoundWordTokenizer compoundSplitter;
    private final Supplier<MorfologikMultiSpeller> morfoSpeller;

    protected abstract void filterForLanguage(List<String> var1);

    @NotNull
    protected static List<String> getSpellingFilePaths(String langCode) {
        return Arrays.asList("/" + langCode + "/hunspell/spelling.txt", "/" + langCode + "/hunspell/spelling_custom.txt", "/" + langCode + "/multitoken-suggest.txt", "spelling_global.txt");
    }

    @NotNull
    protected static List<InputStream> getStreams(List<String> paths) {
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        for (String path : paths) {
            String separation = "# Start of file " + path.replaceAll("\n", "") + "\n";
            ByteArrayInputStream separationStream = new ByteArrayInputStream(Charset.defaultCharset().encode(separation).array());
            streams.add(separationStream);
            streams.add(JLanguageTool.getDataBroker().getFromResourceDirAsStream(path));
            streams.add(new ByteArrayInputStream(System.lineSeparator().getBytes(StandardCharsets.UTF_8)));
        }
        return streams;
    }

    public CompoundAwareHunspellRule(ResourceBundle messages, Language language, CompoundWordTokenizer compoundSplitter, MorfologikMultiSpeller morfoSpeller, UserConfig userConfig) {
        this(messages, language, compoundSplitter, morfoSpeller, userConfig, Collections.emptyList());
    }

    public CompoundAwareHunspellRule(ResourceBundle messages, Language language, CompoundWordTokenizer compoundSplitter, MorfologikMultiSpeller morfoSpeller, UserConfig userConfig, List<Language> altLanguages) {
        this(messages, language, compoundSplitter, morfoSpeller, userConfig, altLanguages, null);
    }

    public CompoundAwareHunspellRule(ResourceBundle messages, Language language, CompoundWordTokenizer compoundSplitter, MorfologikMultiSpeller morfoSpeller, UserConfig userConfig, List<Language> altLanguages, LanguageModel languageModel) {
        this(messages, language, compoundSplitter, () -> morfoSpeller, userConfig, altLanguages, languageModel);
    }

    public CompoundAwareHunspellRule(ResourceBundle messages, Language language, CompoundWordTokenizer compoundSplitter, Supplier<MorfologikMultiSpeller> morfoSpeller, UserConfig userConfig, List<Language> altLanguages, LanguageModel languageModel) {
        super(messages, language, userConfig, altLanguages, languageModel);
        this.compoundSplitter = compoundSplitter;
        this.morfoSpeller = Suppliers.memoize(() -> (MorfologikMultiSpeller)morfoSpeller.get());
    }

    @Override
    public List<String> getSuggestions(String word) throws IOException {
        this.ensureInitialized();
        List<String> candidates = this.getCandidates(word);
        List<String> simpleSuggestions = this.getCorrectWords(candidates);
        simpleSuggestions = this.getFilteredSuggestions(simpleSuggestions);
        MorfologikMultiSpeller morfoSpeller = this.morfoSpeller.get();
        List<String> noSplitSuggestions = morfoSpeller.getSuggestions(word);
        CompoundAwareHunspellRule.handleWordEndPunctuation(".", word, noSplitSuggestions, morfoSpeller);
        CompoundAwareHunspellRule.handleWordEndPunctuation("...", word, noSplitSuggestions, morfoSpeller);
        List<Object> noSplitLowercaseSuggestions = new ArrayList();
        if (StringTools.startsWithUppercase(word) && !StringTools.isAllUppercase(word)) {
            noSplitLowercaseSuggestions = morfoSpeller.getSuggestions(word.toLowerCase());
        }
        ArrayList<String> suggestions = new ArrayList();
        int max = IntStream.of(simpleSuggestions.size(), noSplitSuggestions.size(), noSplitLowercaseSuggestions.size()).max().orElse(0);
        for (int i = 0; i < max; ++i) {
            if (i < noSplitSuggestions.size()) {
                suggestions.add(noSplitSuggestions.get(i));
            }
            if (i < noSplitLowercaseSuggestions.size()) {
                suggestions.add(StringTools.uppercaseFirstChar((String)noSplitLowercaseSuggestions.get(i)));
            }
            if (i >= simpleSuggestions.size()) continue;
            suggestions.add(simpleSuggestions.get(i));
        }
        suggestions = CompoundAwareHunspellRule.filterDupes(suggestions);
        this.filterForLanguage(suggestions);
        List<String> sortedSuggestions = this.sortSuggestionByQuality(word, suggestions);
        return sortedSuggestions.subList(0, Math.min(20, sortedSuggestions.size()));
    }

    private static void handleWordEndPunctuation(String punct, String word, List<String> noSplitSuggestions, MorfologikMultiSpeller morfoSpeller) {
        if (word.endsWith(punct)) {
            List<String> tmp = morfoSpeller.getSuggestions(word.substring(0, word.length() - punct.length()));
            for (String s : tmp) {
                noSplitSuggestions.add(s + punct);
            }
        }
    }

    protected List<String> getCandidates(String word) {
        return this.compoundSplitter.tokenize(word);
    }

    protected List<String> getCandidates(List<String> parts) {
        int partCount = 0;
        ArrayList<String> candidates = new ArrayList<String>();
        for (String part : parts) {
            if (!this.hunspell.spell(part)) {
                boolean doUpperCase;
                MorfologikMultiSpeller morfoSpeller = this.morfoSpeller.get();
                List<String> suggestions = morfoSpeller.getSuggestions((doUpperCase = partCount > 0 && !StringTools.startsWithUppercase(part)) ? StringTools.uppercaseFirstChar(part) : part);
                if (suggestions.isEmpty()) {
                    suggestions = morfoSpeller.getSuggestions(doUpperCase ? StringTools.lowercaseFirstChar(part) : part);
                }
                boolean appendS = false;
                if (doUpperCase && part.endsWith("s")) {
                    suggestions.addAll(morfoSpeller.getSuggestions(StringUtils.removeEnd((String)part, (String)"s")));
                    appendS = true;
                }
                for (String suggestion : suggestions) {
                    ArrayList<String> partsCopy = new ArrayList<String>(parts);
                    if (appendS) {
                        suggestion = suggestion + "s";
                    }
                    if (partCount > 0 && parts.get(partCount).startsWith("-") && parts.get(partCount).length() > 1) {
                        partsCopy.set(partCount, "-" + StringTools.uppercaseFirstChar(suggestion.substring(1)));
                    } else if (partCount > 0 && !parts.get(partCount - 1).endsWith("-")) {
                        partsCopy.set(partCount, suggestion.toLowerCase());
                    } else {
                        partsCopy.set(partCount, suggestion);
                    }
                    String candidate = String.join((CharSequence)"", partsCopy);
                    if (!this.isMisspelled(candidate)) {
                        candidates.add(candidate);
                    }
                    if (partCount >= parts.size() - 1 || !part.endsWith("s") || !suggestion.endsWith("-")) continue;
                    partsCopy.set(partCount, suggestion.substring(0, suggestion.length() - 1));
                    String infixCandidate = String.join((CharSequence)"", partsCopy);
                    if (this.isMisspelled(infixCandidate)) continue;
                    candidates.add(infixCandidate);
                }
            }
            ++partCount;
        }
        return candidates;
    }

    @Override
    protected List<String> sortSuggestionByQuality(String misspelling, List<String> suggestions) {
        ArrayList<String> result = new ArrayList<String>();
        for (String suggestion : suggestions) {
            if (StringUtils.remove((String)suggestion, (char)' ').equals(misspelling) && Arrays.stream(StringUtils.split((String)suggestion, (char)' ')).noneMatch(k -> k.length() == 1)) {
                result.add(0, suggestion);
                continue;
            }
            result.add(suggestion);
        }
        return result;
    }

    private List<String> getCorrectWords(List<String> wordsOrPhrases) {
        ArrayList<String> result = new ArrayList<String>();
        for (String wordOrPhrase : wordsOrPhrases) {
            String[] words = this.tokenizeText(wordOrPhrase);
            boolean wordIsOkay = true;
            for (String word : words) {
                if (this.hunspell.spell(word)) continue;
                wordIsOkay = false;
                break;
            }
            if (!wordIsOkay) continue;
            result.add(wordOrPhrase);
        }
        return result;
    }

    protected List<String> getFilteredSuggestions(List<String> wordsOrPhrases) {
        return wordsOrPhrases;
    }
}

