const makeFunCanvas = canvasId => {
    c = document.getElementById(canvasId);

    ctx = c.getContext("2d");
    ctx.fillStyle = "black";
    ctx.fillRect(0, 0, c.width, c.height);

    pressed = false;
    mouseX = 0;
    mouseY = 0;

    c.addEventListener("mousedown", function (e) {
        // mousedown
        pressed = true;
        mouseX = e.offsetX;
        mouseY = e.offsetY;
    });

    c.addEventListener("mouseup", function () {
        // mouseup
        pressed = false;
    });

    c.addEventListener("mousemove", function (e) {
        // mousemove
        mouseX = e.offsetX;
        mouseY = e.offsetY;
    });

    function update() {
        if (pressed) {
            var r = Math.random() * 255;
            var g = Math.random() * 255;
            var b = Math.random() * 255;
            var color = "rgb(" + ~~r + "," + ~~g + "," + ~~b + ")";
            ctx.fillStyle = color;
            const spread = 35;
            var x = mouseX + Math.random() * spread - spread / 2;
            var y = mouseY + Math.random() * spread - spread / 2;
            var size = Math.random() * 8;
            ctx.fillRect(x, y, size, size);
        }
    }

    setInterval(update, 20);
};
