"""Generated client library for iam version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.iam.v1 import iam_v1_messages as messages


class IamV1(base_api.BaseApiClient):
  """Generated client library for service iam version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://iam.googleapis.com/'

  _PACKAGE = u'iam'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = u'v1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'IamV1'
  _URL_VERSION = u'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new iam handle."""
    url = url or self.BASE_URL
    super(IamV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.iamPolicies = self.IamPoliciesService(self)
    self.organizations_roles = self.OrganizationsRolesService(self)
    self.organizations = self.OrganizationsService(self)
    self.permissions = self.PermissionsService(self)
    self.projects_roles = self.ProjectsRolesService(self)
    self.projects_serviceAccounts_identityBindings = self.ProjectsServiceAccountsIdentityBindingsService(self)
    self.projects_serviceAccounts_keys = self.ProjectsServiceAccountsKeysService(self)
    self.projects_serviceAccounts = self.ProjectsServiceAccountsService(self)
    self.projects = self.ProjectsService(self)
    self.roles = self.RolesService(self)

  class IamPoliciesService(base_api.BaseApiService):
    """Service class for the iamPolicies resource."""

    _NAME = u'iamPolicies'

    def __init__(self, client):
      super(IamV1.IamPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def LintPolicy(self, request, global_params=None):
      r"""Lints a Cloud IAM policy object or its sub fields. Currently supports.
google.iam.v1.Policy, google.iam.v1.Binding and
google.iam.v1.Binding.condition.

Each lint operation consists of multiple lint validation units.
Validation units have the following properties:

- Each unit inspects the input object in regard to a particular
  linting aspect and issues a google.iam.admin.v1.LintResult
  disclosing the result.
- Domain of discourse of each unit can be either
  google.iam.v1.Policy, google.iam.v1.Binding, or
  google.iam.v1.Binding.condition depending on the purpose of the
  validation.
- A unit may require additional data (like the list of all possible
  enumerable values of a particular attribute used in the policy instance)
  which shall be provided by the caller. Refer to the comments of
  google.iam.admin.v1.LintPolicyRequest.context for more details.

The set of applicable validation units is determined by the Cloud IAM
server and is not configurable.

Regardless of any lint issues or their severities, successful calls to
`lintPolicy` return an HTTP 200 OK status code.

      Args:
        request: (LintPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LintPolicyResponse) The response message.
      """
      config = self.GetMethodConfig('LintPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    LintPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'iam.iamPolicies.lintPolicy',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/iamPolicies:lintPolicy',
        request_field='<request>',
        request_type_name=u'LintPolicyRequest',
        response_type_name=u'LintPolicyResponse',
        supports_download=False,
    )

    def QueryAuditableServices(self, request, global_params=None):
      r"""Returns a list of services that support service level audit logging.
configuration for the given resource.

      Args:
        request: (QueryAuditableServicesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (QueryAuditableServicesResponse) The response message.
      """
      config = self.GetMethodConfig('QueryAuditableServices')
      return self._RunMethod(
          config, request, global_params=global_params)

    QueryAuditableServices.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'iam.iamPolicies.queryAuditableServices',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/iamPolicies:queryAuditableServices',
        request_field='<request>',
        request_type_name=u'QueryAuditableServicesRequest',
        response_type_name=u'QueryAuditableServicesResponse',
        supports_download=False,
    )

  class OrganizationsRolesService(base_api.BaseApiService):
    """Service class for the organizations_roles resource."""

    _NAME = u'organizations_roles'

    def __init__(self, client):
      super(IamV1.OrganizationsRolesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Role.

      Args:
        request: (IamOrganizationsRolesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Role) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/organizations/{organizationsId}/roles',
        http_method=u'POST',
        method_id=u'iam.organizations.roles.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1/{+parent}/roles',
        request_field=u'createRoleRequest',
        request_type_name=u'IamOrganizationsRolesCreateRequest',
        response_type_name=u'Role',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Soft deletes a role. The role is suspended and cannot be used to create new.
IAM Policy Bindings.
The Role will not be included in `ListRoles()` unless `show_deleted` is set
in the `ListRolesRequest`. The Role contains the deleted boolean set.
Existing Bindings remains, but are inactive. The Role can be undeleted
within 7 days. After 7 days the Role is deleted and all Bindings associated
with the role are removed.

      Args:
        request: (IamOrganizationsRolesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Role) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/organizations/{organizationsId}/roles/{rolesId}',
        http_method=u'DELETE',
        method_id=u'iam.organizations.roles.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'etag'],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'IamOrganizationsRolesDeleteRequest',
        response_type_name=u'Role',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a Role definition.

      Args:
        request: (IamOrganizationsRolesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Role) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/organizations/{organizationsId}/roles/{rolesId}',
        http_method=u'GET',
        method_id=u'iam.organizations.roles.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'IamOrganizationsRolesGetRequest',
        response_type_name=u'Role',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the Roles defined on a resource.

      Args:
        request: (IamOrganizationsRolesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRolesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/organizations/{organizationsId}/roles',
        http_method=u'GET',
        method_id=u'iam.organizations.roles.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken', u'showDeleted', u'view'],
        relative_path=u'v1/{+parent}/roles',
        request_field='',
        request_type_name=u'IamOrganizationsRolesListRequest',
        response_type_name=u'ListRolesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a Role definition.

      Args:
        request: (IamOrganizationsRolesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Role) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/organizations/{organizationsId}/roles/{rolesId}',
        http_method=u'PATCH',
        method_id=u'iam.organizations.roles.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1/{+name}',
        request_field=u'role',
        request_type_name=u'IamOrganizationsRolesPatchRequest',
        response_type_name=u'Role',
        supports_download=False,
    )

    def Undelete(self, request, global_params=None):
      r"""Undelete a Role, bringing it back in its previous state.

      Args:
        request: (IamOrganizationsRolesUndeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Role) The response message.
      """
      config = self.GetMethodConfig('Undelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Undelete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/organizations/{organizationsId}/roles/{rolesId}:undelete',
        http_method=u'POST',
        method_id=u'iam.organizations.roles.undelete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:undelete',
        request_field=u'undeleteRoleRequest',
        request_type_name=u'IamOrganizationsRolesUndeleteRequest',
        response_type_name=u'Role',
        supports_download=False,
    )

  class OrganizationsService(base_api.BaseApiService):
    """Service class for the organizations resource."""

    _NAME = u'organizations'

    def __init__(self, client):
      super(IamV1.OrganizationsService, self).__init__(client)
      self._upload_configs = {
          }

  class PermissionsService(base_api.BaseApiService):
    """Service class for the permissions resource."""

    _NAME = u'permissions'

    def __init__(self, client):
      super(IamV1.PermissionsService, self).__init__(client)
      self._upload_configs = {
          }

    def QueryTestablePermissions(self, request, global_params=None):
      r"""Lists the permissions testable on a resource.
A permission is testable if it can be tested for an identity on a resource.

      Args:
        request: (QueryTestablePermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (QueryTestablePermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('QueryTestablePermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    QueryTestablePermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'iam.permissions.queryTestablePermissions',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/permissions:queryTestablePermissions',
        request_field='<request>',
        request_type_name=u'QueryTestablePermissionsRequest',
        response_type_name=u'QueryTestablePermissionsResponse',
        supports_download=False,
    )

  class ProjectsRolesService(base_api.BaseApiService):
    """Service class for the projects_roles resource."""

    _NAME = u'projects_roles'

    def __init__(self, client):
      super(IamV1.ProjectsRolesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Role.

      Args:
        request: (IamProjectsRolesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Role) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/roles',
        http_method=u'POST',
        method_id=u'iam.projects.roles.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1/{+parent}/roles',
        request_field=u'createRoleRequest',
        request_type_name=u'IamProjectsRolesCreateRequest',
        response_type_name=u'Role',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Soft deletes a role. The role is suspended and cannot be used to create new.
IAM Policy Bindings.
The Role will not be included in `ListRoles()` unless `show_deleted` is set
in the `ListRolesRequest`. The Role contains the deleted boolean set.
Existing Bindings remains, but are inactive. The Role can be undeleted
within 7 days. After 7 days the Role is deleted and all Bindings associated
with the role are removed.

      Args:
        request: (IamProjectsRolesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Role) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/roles/{rolesId}',
        http_method=u'DELETE',
        method_id=u'iam.projects.roles.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'etag'],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'IamProjectsRolesDeleteRequest',
        response_type_name=u'Role',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a Role definition.

      Args:
        request: (IamProjectsRolesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Role) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/roles/{rolesId}',
        http_method=u'GET',
        method_id=u'iam.projects.roles.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'IamProjectsRolesGetRequest',
        response_type_name=u'Role',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the Roles defined on a resource.

      Args:
        request: (IamProjectsRolesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRolesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/roles',
        http_method=u'GET',
        method_id=u'iam.projects.roles.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken', u'showDeleted', u'view'],
        relative_path=u'v1/{+parent}/roles',
        request_field='',
        request_type_name=u'IamProjectsRolesListRequest',
        response_type_name=u'ListRolesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a Role definition.

      Args:
        request: (IamProjectsRolesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Role) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/roles/{rolesId}',
        http_method=u'PATCH',
        method_id=u'iam.projects.roles.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1/{+name}',
        request_field=u'role',
        request_type_name=u'IamProjectsRolesPatchRequest',
        response_type_name=u'Role',
        supports_download=False,
    )

    def Undelete(self, request, global_params=None):
      r"""Undelete a Role, bringing it back in its previous state.

      Args:
        request: (IamProjectsRolesUndeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Role) The response message.
      """
      config = self.GetMethodConfig('Undelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Undelete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/roles/{rolesId}:undelete',
        http_method=u'POST',
        method_id=u'iam.projects.roles.undelete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:undelete',
        request_field=u'undeleteRoleRequest',
        request_type_name=u'IamProjectsRolesUndeleteRequest',
        response_type_name=u'Role',
        supports_download=False,
    )

  class ProjectsServiceAccountsIdentityBindingsService(base_api.BaseApiService):
    """Service class for the projects_serviceAccounts_identityBindings resource."""

    _NAME = u'projects_serviceAccounts_identityBindings'

    def __init__(self, client):
      super(IamV1.ProjectsServiceAccountsIdentityBindingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a.
ServiceAccountIdentityBinding
and returns it.

      Args:
        request: (IamProjectsServiceAccountsIdentityBindingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAccountIdentityBinding) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}/identityBindings',
        http_method=u'POST',
        method_id=u'iam.projects.serviceAccounts.identityBindings.create',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}/identityBindings',
        request_field=u'createServiceAccountIdentityBindingRequest',
        request_type_name=u'IamProjectsServiceAccountsIdentityBindingsCreateRequest',
        response_type_name=u'ServiceAccountIdentityBinding',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a.
ServiceAccountIdentityBinding.

      Args:
        request: (IamProjectsServiceAccountsIdentityBindingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}/identityBindings/{identityBindingsId}',
        http_method=u'DELETE',
        method_id=u'iam.projects.serviceAccounts.identityBindings.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'IamProjectsServiceAccountsIdentityBindingsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the.
ServiceAccountIdentityBinding
for a service account.

      Args:
        request: (IamProjectsServiceAccountsIdentityBindingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAccountIdentityBinding) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}/identityBindings/{identityBindingsId}',
        http_method=u'GET',
        method_id=u'iam.projects.serviceAccounts.identityBindings.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'IamProjectsServiceAccountsIdentityBindingsGetRequest',
        response_type_name=u'ServiceAccountIdentityBinding',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the.
ServiceAccountIdentityBindings
for a service account.

      Args:
        request: (IamProjectsServiceAccountsIdentityBindingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListServiceAccountIdentityBindingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}/identityBindings',
        http_method=u'GET',
        method_id=u'iam.projects.serviceAccounts.identityBindings.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}/identityBindings',
        request_field='',
        request_type_name=u'IamProjectsServiceAccountsIdentityBindingsListRequest',
        response_type_name=u'ListServiceAccountIdentityBindingsResponse',
        supports_download=False,
    )

  class ProjectsServiceAccountsKeysService(base_api.BaseApiService):
    """Service class for the projects_serviceAccounts_keys resource."""

    _NAME = u'projects_serviceAccounts_keys'

    def __init__(self, client):
      super(IamV1.ProjectsServiceAccountsKeysService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a ServiceAccountKey.
and returns it.

      Args:
        request: (IamProjectsServiceAccountsKeysCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAccountKey) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}/keys',
        http_method=u'POST',
        method_id=u'iam.projects.serviceAccounts.keys.create',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}/keys',
        request_field=u'createServiceAccountKeyRequest',
        request_type_name=u'IamProjectsServiceAccountsKeysCreateRequest',
        response_type_name=u'ServiceAccountKey',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a ServiceAccountKey.

      Args:
        request: (IamProjectsServiceAccountsKeysDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}/keys/{keysId}',
        http_method=u'DELETE',
        method_id=u'iam.projects.serviceAccounts.keys.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'IamProjectsServiceAccountsKeysDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the ServiceAccountKey.
by key id.

      Args:
        request: (IamProjectsServiceAccountsKeysGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAccountKey) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}/keys/{keysId}',
        http_method=u'GET',
        method_id=u'iam.projects.serviceAccounts.keys.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'publicKeyType'],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'IamProjectsServiceAccountsKeysGetRequest',
        response_type_name=u'ServiceAccountKey',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists ServiceAccountKeys.

      Args:
        request: (IamProjectsServiceAccountsKeysListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListServiceAccountKeysResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}/keys',
        http_method=u'GET',
        method_id=u'iam.projects.serviceAccounts.keys.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'keyTypes'],
        relative_path=u'v1/{+name}/keys',
        request_field='',
        request_type_name=u'IamProjectsServiceAccountsKeysListRequest',
        response_type_name=u'ListServiceAccountKeysResponse',
        supports_download=False,
    )

    def Upload(self, request, global_params=None):
      r"""Upload public key for a given service account.
This rpc will create a
ServiceAccountKey that has the
provided public key and returns it.

      Args:
        request: (IamProjectsServiceAccountsKeysUploadRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAccountKey) The response message.
      """
      config = self.GetMethodConfig('Upload')
      return self._RunMethod(
          config, request, global_params=global_params)

    Upload.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}/keys:upload',
        http_method=u'POST',
        method_id=u'iam.projects.serviceAccounts.keys.upload',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}/keys:upload',
        request_field=u'uploadServiceAccountKeyRequest',
        request_type_name=u'IamProjectsServiceAccountsKeysUploadRequest',
        response_type_name=u'ServiceAccountKey',
        supports_download=False,
    )

  class ProjectsServiceAccountsService(base_api.BaseApiService):
    """Service class for the projects_serviceAccounts resource."""

    _NAME = u'projects_serviceAccounts'

    def __init__(self, client):
      super(IamV1.ProjectsServiceAccountsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a ServiceAccount.
and returns it.

      Args:
        request: (IamProjectsServiceAccountsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAccount) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/serviceAccounts',
        http_method=u'POST',
        method_id=u'iam.projects.serviceAccounts.create',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}/serviceAccounts',
        request_field=u'createServiceAccountRequest',
        request_type_name=u'IamProjectsServiceAccountsCreateRequest',
        response_type_name=u'ServiceAccount',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a ServiceAccount.

      Args:
        request: (IamProjectsServiceAccountsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}',
        http_method=u'DELETE',
        method_id=u'iam.projects.serviceAccounts.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'IamProjectsServiceAccountsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Disable(self, request, global_params=None):
      r"""DisableServiceAccount is currently in the alpha launch stage.

Disables a ServiceAccount,
which immediately prevents the service account from authenticating and
gaining access to APIs.

Disabled service accounts can be safely restored by using
EnableServiceAccount at any point. Deleted service accounts cannot be
restored using this method.

Disabling a service account that is bound to VMs, Apps, Functions, or
other jobs will cause those jobs to lose access to resources if they are
using the disabled service account.

To improve reliability of your services and avoid unexpected outages, it
is recommended to first disable a service account rather than delete it.
After disabling the service account, wait at least 24 hours to verify there
are no unintended consequences, and then delete the service account.

      Args:
        request: (IamProjectsServiceAccountsDisableRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Disable')
      return self._RunMethod(
          config, request, global_params=global_params)

    Disable.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}:disable',
        http_method=u'POST',
        method_id=u'iam.projects.serviceAccounts.disable',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:disable',
        request_field=u'disableServiceAccountRequest',
        request_type_name=u'IamProjectsServiceAccountsDisableRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Enable(self, request, global_params=None):
      r"""EnableServiceAccount is currently in the alpha launch stage.

 Restores a disabled ServiceAccount
 that has been manually disabled by using DisableServiceAccount. Service
 accounts that have been disabled by other means or for other reasons,
 such as abuse, cannot be restored using this method.

 EnableServiceAccount will have no effect on a service account that is
 not disabled.  Enabling an already enabled service account will have no
 effect.

      Args:
        request: (IamProjectsServiceAccountsEnableRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Enable')
      return self._RunMethod(
          config, request, global_params=global_params)

    Enable.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}:enable',
        http_method=u'POST',
        method_id=u'iam.projects.serviceAccounts.enable',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:enable',
        request_field=u'enableServiceAccountRequest',
        request_type_name=u'IamProjectsServiceAccountsEnableRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a ServiceAccount.

      Args:
        request: (IamProjectsServiceAccountsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAccount) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}',
        http_method=u'GET',
        method_id=u'iam.projects.serviceAccounts.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'IamProjectsServiceAccountsGetRequest',
        response_type_name=u'ServiceAccount',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Returns the Cloud IAM access control policy for a.
ServiceAccount.

Note: Service accounts are both
[resources and
identities](/iam/docs/service-accounts#service_account_permissions). This
method treats the service account as a resource. It returns the Cloud IAM
policy that reflects what members have access to the service account.

This method does not return what resources the service account has access
to. To see if a service account has access to a resource, call the
`getIamPolicy` method on the target resource. For example, to view grants
for a project, call the
[projects.getIamPolicy](/resource-manager/reference/rest/v1/projects/getIamPolicy)
method.

      Args:
        request: (IamProjectsServiceAccountsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'iam.projects.serviceAccounts.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[u'options_requestedPolicyVersion'],
        relative_path=u'v1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name=u'IamProjectsServiceAccountsGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists ServiceAccounts for a project.

      Args:
        request: (IamProjectsServiceAccountsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListServiceAccountsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/serviceAccounts',
        http_method=u'GET',
        method_id=u'iam.projects.serviceAccounts.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1/{+name}/serviceAccounts',
        request_field='',
        request_type_name=u'IamProjectsServiceAccountsListRequest',
        response_type_name=u'ListServiceAccountsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches a ServiceAccount.

Currently, only the following fields are updatable:
`display_name` and `description`.

Only fields specified in the request are guaranteed to be returned in
the response. Other fields in the response may be empty.

Note: The field mask is required.

      Args:
        request: (IamProjectsServiceAccountsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAccount) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}',
        http_method=u'PATCH',
        method_id=u'iam.projects.serviceAccounts.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field=u'patchServiceAccountRequest',
        request_type_name=u'IamProjectsServiceAccountsPatchRequest',
        response_type_name=u'ServiceAccount',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the Cloud IAM access control policy for a.
ServiceAccount.

Note: Service accounts are both
[resources and
identities](/iam/docs/service-accounts#service_account_permissions). This
method treats the service account as a resource. Use it to grant members
access to the service account, such as when they need to impersonate it.

This method does not grant the service account access to other resources,
such as projects. To grant a service account access to resources, include
the service account in the Cloud IAM policy for the desired resource, then
call the appropriate `setIamPolicy` method on the target resource. For
example, to grant a service account access to a project, call the
[projects.setIamPolicy](/resource-manager/reference/rest/v1/projects/setIamPolicy)
method.

      Args:
        request: (IamProjectsServiceAccountsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'iam.projects.serviceAccounts.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'IamProjectsServiceAccountsSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def SignBlob(self, request, global_params=None):
      r"""**Note**: This method is in the process of being deprecated. Call the.
[`signBlob()`](/iam/credentials/reference/rest/v1/projects.serviceAccounts/signBlob)
method of the Cloud IAM Service Account Credentials API instead.

Signs a blob using a service account's system-managed private key.

      Args:
        request: (IamProjectsServiceAccountsSignBlobRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SignBlobResponse) The response message.
      """
      config = self.GetMethodConfig('SignBlob')
      return self._RunMethod(
          config, request, global_params=global_params)

    SignBlob.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}:signBlob',
        http_method=u'POST',
        method_id=u'iam.projects.serviceAccounts.signBlob',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:signBlob',
        request_field=u'signBlobRequest',
        request_type_name=u'IamProjectsServiceAccountsSignBlobRequest',
        response_type_name=u'SignBlobResponse',
        supports_download=False,
    )

    def SignJwt(self, request, global_params=None):
      r"""**Note**: This method is in the process of being deprecated. Call the.
[`signJwt()`](/iam/credentials/reference/rest/v1/projects.serviceAccounts/signJwt)
method of the Cloud IAM Service Account Credentials API instead.

Signs a JWT using a service account's system-managed private key.

If no expiry time (`exp`) is provided in the `SignJwtRequest`, IAM sets an
an expiry time of one hour by default. If you request an expiry time of
more than one hour, the request will fail.

      Args:
        request: (IamProjectsServiceAccountsSignJwtRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SignJwtResponse) The response message.
      """
      config = self.GetMethodConfig('SignJwt')
      return self._RunMethod(
          config, request, global_params=global_params)

    SignJwt.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}:signJwt',
        http_method=u'POST',
        method_id=u'iam.projects.serviceAccounts.signJwt',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:signJwt',
        request_field=u'signJwtRequest',
        request_type_name=u'IamProjectsServiceAccountsSignJwtRequest',
        response_type_name=u'SignJwtResponse',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Tests the specified permissions against the IAM access control policy.
for a ServiceAccount.

      Args:
        request: (IamProjectsServiceAccountsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'iam.projects.serviceAccounts.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'IamProjectsServiceAccountsTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

    def Undelete(self, request, global_params=None):
      r"""Restores a deleted ServiceAccount.
This is to be used as an action of last resort.  A service account may
not always be restorable.

      Args:
        request: (IamProjectsServiceAccountsUndeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UndeleteServiceAccountResponse) The response message.
      """
      config = self.GetMethodConfig('Undelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Undelete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}:undelete',
        http_method=u'POST',
        method_id=u'iam.projects.serviceAccounts.undelete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:undelete',
        request_field=u'undeleteServiceAccountRequest',
        request_type_name=u'IamProjectsServiceAccountsUndeleteRequest',
        response_type_name=u'UndeleteServiceAccountResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Note: This method is in the process of being deprecated. Use.
PatchServiceAccount instead.

Updates a ServiceAccount.

Currently, only the following fields are updatable:
`display_name` and `description`.

      Args:
        request: (ServiceAccount) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAccount) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}',
        http_method=u'PUT',
        method_id=u'iam.projects.serviceAccounts.update',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='<request>',
        request_type_name=u'ServiceAccount',
        response_type_name=u'ServiceAccount',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(IamV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

  class RolesService(base_api.BaseApiService):
    """Service class for the roles resource."""

    _NAME = u'roles'

    def __init__(self, client):
      super(IamV1.RolesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets a Role definition.

      Args:
        request: (IamRolesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Role) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/roles/{rolesId}',
        http_method=u'GET',
        method_id=u'iam.roles.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'IamRolesGetRequest',
        response_type_name=u'Role',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the Roles defined on a resource.

      Args:
        request: (IamRolesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRolesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'iam.roles.list',
        ordered_params=[],
        path_params=[],
        query_params=[u'pageSize', u'pageToken', u'parent', u'showDeleted', u'view'],
        relative_path=u'v1/roles',
        request_field='',
        request_type_name=u'IamRolesListRequest',
        response_type_name=u'ListRolesResponse',
        supports_download=False,
    )

    def QueryGrantableRoles(self, request, global_params=None):
      r"""Queries roles that can be granted on a particular resource.
A role is grantable if it can be used as the role in a binding for a policy
for that resource.

      Args:
        request: (QueryGrantableRolesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (QueryGrantableRolesResponse) The response message.
      """
      config = self.GetMethodConfig('QueryGrantableRoles')
      return self._RunMethod(
          config, request, global_params=global_params)

    QueryGrantableRoles.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'iam.roles.queryGrantableRoles',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/roles:queryGrantableRoles',
        request_field='<request>',
        request_type_name=u'QueryGrantableRolesRequest',
        response_type_name=u'QueryGrantableRolesResponse',
        supports_download=False,
    )
