require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_I386_INCLUDE_PARAM_H_)) {
    eval 'sub _I386_INCLUDE_PARAM_H_ () {1;}' unless defined(&_I386_INCLUDE_PARAM_H_);
    require 'machine/_align.ph';
    eval 'sub __HAVE_ACPI () {1;}' unless defined(&__HAVE_ACPI);
    eval 'sub __HAVE_PIR () {1;}' unless defined(&__HAVE_PIR);
    eval 'sub __PCI_REROUTE_INTERRUPT () {1;}' unless defined(&__PCI_REROUTE_INTERRUPT);
    unless(defined(&MACHINE)) {
	eval 'sub MACHINE () {"i386";}' unless defined(&MACHINE);
    }
    unless(defined(&MACHINE_ARCH)) {
	eval 'sub MACHINE_ARCH () {"i386";}' unless defined(&MACHINE_ARCH);
    }
    eval 'sub MID_MACHINE () { &MID_I386;}' unless defined(&MID_MACHINE);
    if(defined(&SMP) || defined(&KLD_MODULE)) {
	unless(defined(&MAXCPU)) {
	    eval 'sub MAXCPU () {32;}' unless defined(&MAXCPU);
	}
    } else {
	eval 'sub MAXCPU () {1;}' unless defined(&MAXCPU);
    }
    unless(defined(&MAXMEMDOM)) {
	eval 'sub MAXMEMDOM () {1;}' unless defined(&MAXMEMDOM);
    }
    eval 'sub ALIGNBYTES () { &_ALIGNBYTES;}' unless defined(&ALIGNBYTES);
    eval 'sub ALIGN {
        my($p) = @_;
	    eval q( &_ALIGN($p));
    }' unless defined(&ALIGN);
    eval 'sub ALIGNED_POINTER {
        my($p, $t) = @_;
	    eval q(1);
    }' unless defined(&ALIGNED_POINTER);
    eval 'sub CACHE_LINE_SHIFT () {7;}' unless defined(&CACHE_LINE_SHIFT);
    eval 'sub CACHE_LINE_SIZE () {(1<<  &CACHE_LINE_SHIFT);}' unless defined(&CACHE_LINE_SIZE);
    eval 'sub PAGE_SHIFT () {12;}' unless defined(&PAGE_SHIFT);
    eval 'sub PAGE_SIZE () {(1<< &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE-1);}' unless defined(&PAGE_MASK);
    eval 'sub NPTEPG () {( &PAGE_SIZE/($sizeof{ &pt_entry_t}));}' unless defined(&NPTEPG);
    if(defined(&PAE) || defined(&PAE_TABLES)) {
	eval 'sub NPGPTD () {4;}' unless defined(&NPGPTD);
	eval 'sub PDRSHIFT () {21;}' unless defined(&PDRSHIFT);
	eval 'sub NPGPTD_SHIFT () {9;}' unless defined(&NPGPTD_SHIFT);
    } else {
	eval 'sub NPGPTD () {1;}' unless defined(&NPGPTD);
	eval 'sub PDRSHIFT () {22;}' unless defined(&PDRSHIFT);
	eval 'sub NPGPTD_SHIFT () {10;}' unless defined(&NPGPTD_SHIFT);
    }
    eval 'sub NBPTD () {( &NPGPTD<< &PAGE_SHIFT);}' unless defined(&NBPTD);
    eval 'sub NPDEPTD () {( &NBPTD/($sizeof{ &pd_entry_t}));}' unless defined(&NPDEPTD);
    eval 'sub NPDEPG () {( &PAGE_SIZE/($sizeof{ &pd_entry_t}));}' unless defined(&NPDEPG);
    eval 'sub NBPDR () {(1<< &PDRSHIFT);}' unless defined(&NBPDR);
    eval 'sub PDRMASK () {( &NBPDR-1);}' unless defined(&PDRMASK);
    eval 'sub MAXPAGESIZES () {2;}' unless defined(&MAXPAGESIZES);
    eval 'sub IOPAGES () {2;}' unless defined(&IOPAGES);
    unless(defined(&KSTACK_PAGES)) {
	eval 'sub KSTACK_PAGES () {2;}' unless defined(&KSTACK_PAGES);
    }
    eval 'sub KSTACK_GUARD_PAGES () {1;}' unless defined(&KSTACK_GUARD_PAGES);
    if((defined(&KSTACK_PAGES) ? &KSTACK_PAGES : undef) < 4) {
	eval 'sub TD0_KSTACK_PAGES () {4;}' unless defined(&TD0_KSTACK_PAGES);
    } else {
	eval 'sub TD0_KSTACK_PAGES () { &KSTACK_PAGES;}' unless defined(&TD0_KSTACK_PAGES);
    }
    unless(defined(&VM_SWZONE_SIZE_MAX)) {
	eval 'sub VM_SWZONE_SIZE_MAX () {(276* 128* 1024);}' unless defined(&VM_SWZONE_SIZE_MAX);
    }
    unless(defined(&VM_BCACHE_SIZE_MAX)) {
	eval 'sub VM_BCACHE_SIZE_MAX () {(7224* 16* 1024);}' unless defined(&VM_BCACHE_SIZE_MAX);
    }
    eval 'sub trunc_page {
        my($x) = @_;
	    eval q((($x) & ~ &PAGE_MASK));
    }' unless defined(&trunc_page);
    eval 'sub round_page {
        my($x) = @_;
	    eval q(((($x) +  &PAGE_MASK) & ~ &PAGE_MASK));
    }' unless defined(&round_page);
    eval 'sub trunc_4mpage {
        my($x) = @_;
	    eval q((($x) & ~ &PDRMASK));
    }' unless defined(&trunc_4mpage);
    eval 'sub round_4mpage {
        my($x) = @_;
	    eval q((((($x)) +  &PDRMASK) & ~ &PDRMASK));
    }' unless defined(&round_4mpage);
    eval 'sub atop {
        my($x) = @_;
	    eval q((($x) >>  &PAGE_SHIFT));
    }' unless defined(&atop);
    eval 'sub ptoa {
        my($x) = @_;
	    eval q((($x) <<  &PAGE_SHIFT));
    }' unless defined(&ptoa);
    eval 'sub i386_btop {
        my($x) = @_;
	    eval q((($x) >>  &PAGE_SHIFT));
    }' unless defined(&i386_btop);
    eval 'sub i386_ptob {
        my($x) = @_;
	    eval q((($x) <<  &PAGE_SHIFT));
    }' unless defined(&i386_ptob);
    eval 'sub pgtok {
        my($x) = @_;
	    eval q((($x) * ( &PAGE_SIZE / 1024)));
    }' unless defined(&pgtok);
    eval 'sub INKERNEL {
        my($va) = @_;
	    eval q(((( &vm_offset_t)($va)) >=  &VM_MAXUSER_ADDRESS  && (( &vm_offset_t)($va)) <  &VM_MAX_KERNEL_ADDRESS));
    }' unless defined(&INKERNEL);
}
1;
