#!/usr/bin/env python

"""
Copyright (c) 2014-2018 Miroslav Stampar (@stamparm)
See the file 'LICENSE' for copying permission
"""

import re

from core.common import retrieve_content

__url__ = "http://malwaredomains.lehigh.edu/files/domains.txt"
__check__ = "safebrowsing.clients.google.com"
__reference__ = "malwaredomains.com"

def fetch():
    retval = {}
    content = retrieve_content(__url__)

    if __check__ in content:
        for line in content.split('\n'):
            line = line.strip('\r').replace('\xa0', "")
            if not line or line.startswith('#'):
                continue
            items = line.split('\t')
            if len(items) > 4:
                if items[2].endswith(".anbtr.com"):  # anubis sinkhole (static/sinkhole_anubis.txt)
                    continue
                info = items[3]
                for _ in ("andromeda", "banjori", "banload", "bedep", "bhek", "bhek2", "blackvine", "browlock", "citadel", "corebot", "cridex", "cryptowall", "darkcomet", "dexter", "dircrypt", "dridex", "dyre", "fareit", "geinimi", "gh0st", "gorynych", "goz", "gozi", "gumblar", "hesperbot", "kaixin", "katrina", "kazy", "keitaro", "kelihos", "kins", "koobface", "kryptik", "matsnu", "napolar", "necurs", "neurevt", "njrat", "nymaim", "passwordstealer", "pkybot", "pony", "p0ny", "posmalware", "poweliks", "pushdo", "pykspa", "qakbot", "ramnit", "ranbyus", "rbn", "rovnix", "runforestrun", "russiandoll", "shiotob", "shylock", "simda", "soaksoak", "sofacy", "suppobox", "teslacrypt", "tinba", "vawtrak", "waledac", "yigido", "zemot", "zeus"):
                    if re.search(r"(?i)\b%s\b" % _, info):
                        info = "%s (malware)" % _
                        break
                retval[items[2]] = (info.replace('_', ' '), __reference__)

    return retval
