/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.javascript2.model.spi;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.netbeans.modules.javascript2.types.api.Type;

/**
 *
 * @author Petr Pisl
 */
public interface TypeNameConvertor {

    /**
     * Often the types contains in fully qualified names parts, that shouldn't be
     * visible for users. These parts can be generated names for anonymous function and objects.
     * For example _L1.Data is a fully qualified name of Data object that is defined in
     * an anonymous function _L1. User should not see the _L1 in the navigator
     * or code completion item, because the name is generated by the parser.
     * @return the display name of the type that is visible for user
     */
    public String getDisplayName(Type type);

    @Retention(RetentionPolicy.SOURCE)
    @Target(ElementType.TYPE)
    public @interface Registration {

        int priority() default 106;
    }

}
