#!/usr/bin/env python
#
# Collect statistics on current release.
# This needs a halfway recent Python 3.

import sys
import subprocess
import tempfile
import re
from datetime import date

# Get version and date
with tempfile.TemporaryDirectory() as tmpdirname:
    INFILE='meson.build'
    subprocess.check_call("git archive --format=tar HEAD | ( cd {} && tar -xf -)".format(tmpdirname), shell=True)
    LOC = subprocess.getoutput("cat {0}/*.[chly] {0}/*.a[cm] {0}/*.py 2>/dev/null | wc -l".format(tmpdirname)).strip()
    try:
        with open(INFILE) as f:
            version = list(filter(lambda x: re.search('version:', x),
                                  f.readlines()))[0]
            VERS = re.search(r"version: '([^']+)", version).group(1)
            DATE = date.today().isoformat()
            print("fetchmail-{} (released {}, {} LoC):".format(VERS, DATE, LOC))

    except:
        print(f"Cannot extract version from {INFILE}!", file=sys.stderr)
        raise

# end of getstats.py
