/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf;

import java.io.IOException;
import java.io.InputStream;
import org.pentaho.reporting.libraries.pixie.wmf.Buffer;
import org.pentaho.reporting.libraries.pixie.wmf.MfType;

public class MfRecord
extends Buffer {
    public static final int RECORD_HEADER_SIZE = 6;
    private static final int RECORD_TYPE_POS = 4;
    private MfType type;

    public MfRecord(int parcount) {
        super(parcount * 2 + 6);
    }

    public MfRecord(InputStream in) throws IOException {
        this.read(in);
    }

    protected void read(InputStream in) throws IOException {
        super.read(in, 0, 6);
        int remaining = this.getInt(0) * 2 - 6;
        if (remaining > 0) {
            super.read(in, 6, remaining);
        }
        this.type = MfType.get(this.getType());
    }

    public int getType() {
        return this.getShort(4);
    }

    public void setType(int type) {
        this.setShort(4, type);
    }

    public int getParam(int p) {
        return this.getShort(p * 2 + 6);
    }

    public void setParam(int p, int value) {
        this.setShort(p * 2 + 6, value);
    }

    public int getLongParam(int p) {
        return this.getInt(p * 2 + 6);
    }

    public void setLongParam(int p, int value) {
        this.setInt(p * 2 + 6, value);
    }

    public String getStringParam(int p, int len) {
        return this.getString(p * 2 + 6, len);
    }

    public void setStringParam(int p, String s) {
        this.setString(p * 2 + 6, s);
    }

    public String getName() {
        return this.type.getName();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.type);
        result.append(' ');
        result.append(this.getName());
        result.append(": ");
        StringBuffer str = new StringBuffer();
        int len = (this.getInt(0) - 3) * 2;
        for (int i = 0; i < len; ++i) {
            if (i % 16 == 0) {
                result.append('\n');
                str.append('\n');
            } else if (i % 8 == 0) {
                result.append(' ');
            }
            int by = this.getByte(i + 6);
            if (by < 16) {
                result.append('0');
            }
            result.append(Integer.toHexString(by));
            result.append(' ');
        }
        return result.toString();
    }

    public boolean doesMark() {
        return this.type.doesMark();
    }

    public boolean isMappingMode() {
        return this.type.isMappingMode();
    }
}

