/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.variables;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.model.elements.VariableContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.internal.debug.core.HeapWalkingManager;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIReferenceListVariable;

public class JavaVariableContentProvider
extends VariableContentProvider {
    protected Object[] getChildren(Object parent, int index, int length, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        Object[] variables = this.getAllChildren(parent, context);
        if (JavaVariableContentProvider.displayReferencesAsChild(parent)) {
            Object[] moreVariables = new Object[variables.length + 1];
            System.arraycopy(variables, 0, moreVariables, 1, variables.length);
            IValue value = ((IVariable)parent).getValue();
            moreVariables[0] = new JDIReferenceListVariable(MessageFormat.format((String)JDIDebugModelMessages.JDIReferenceListValue_6, (Object[])new String[]{((IVariable)parent).getName()}), (IJavaObject)value);
            return this.getElements(moreVariables, index, length);
        }
        return this.getElements(variables, index, length);
    }

    protected int getChildCount(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        int count = super.getChildCount(element, context, monitor);
        if (JavaVariableContentProvider.displayReferencesAsChild(element)) {
            ++count;
        }
        return count;
    }

    protected boolean hasChildren(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        if (JavaVariableContentProvider.displayReferencesAsChild(element)) {
            return true;
        }
        return super.hasChildren(element, context, monitor);
    }

    public static boolean displayReferencesAsChild(Object parent) throws DebugException {
        if (HeapWalkingManager.supportsHeapWalking((Object)parent) && !(parent instanceof JDIReferenceListVariable)) {
            IValue value = null;
            if (parent instanceof IVariable) {
                value = ((IVariable)parent).getValue();
            } else if (parent instanceof IExpression) {
                value = ((IExpression)parent).getValue();
            } else {
                return false;
            }
            if (value instanceof IJavaObject && !((IJavaDebugTarget)value.getDebugTarget()).nullValue().equals(value)) {
                return HeapWalkingManager.getDefault().isShowReferenceInVarView();
            }
        }
        return false;
    }
}

