/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.CorrectionEngine;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.debug.ui.launcher.DefineSystemLibraryQuickFix;
import org.eclipse.jdt.internal.debug.ui.launcher.JREResolution;
import org.eclipse.jdt.internal.debug.ui.launcher.SelectDefaultSystemLibraryQuickFix;
import org.eclipse.jdt.internal.debug.ui.launcher.SelectSystemLibraryQuickFix;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;

public class JreResolutionGenerator
implements IMarkerResolutionGenerator {
    private static final IMarkerResolution[] NO_RESOLUTION = new IMarkerResolution[0];

    public IMarkerResolution[] getResolutions(IMarker marker) {
        int id = marker.getAttribute("id", -1);
        switch (id) {
            case 963: {
                String[] arguments = CorrectionEngine.getProblemArguments((IMarker)marker);
                Path path = new Path(arguments[0]);
                if (!path.segment(0).equals(JavaRuntime.JRE_CONTAINER)) break;
                if (JREResolution.getAllVMs().length > 0) {
                    IJavaProject project = this.getJavaProject(marker);
                    return new IMarkerResolution[]{new SelectSystemLibraryQuickFix((IPath)path, project)};
                }
                return new IMarkerResolution[]{new DefineSystemLibraryQuickFix()};
            }
            case 965: {
                String[] arguments = CorrectionEngine.getProblemArguments((IMarker)marker);
                Path path = new Path(arguments[0]);
                if (!path.segment(0).equals("JRE_LIB")) break;
                if (JREResolution.getAllVMs().length > 0) {
                    return new IMarkerResolution[]{new SelectDefaultSystemLibraryQuickFix()};
                }
                return new IMarkerResolution[]{new DefineSystemLibraryQuickFix()};
            }
            case 1010: {
                String[] arguments = CorrectionEngine.getProblemArguments((IMarker)marker);
                Path path = new Path(arguments[0]);
                if (!path.segment(0).equals("JRE_LIB") && !path.segment(0).equals(JavaRuntime.JRE_CONTAINER)) break;
                IJavaProject project = this.getJavaProject(marker);
                return new IMarkerResolution[]{new SelectSystemLibraryQuickFix((IPath)path, project)};
            }
        }
        return NO_RESOLUTION;
    }

    protected IJavaProject getJavaProject(IMarker marker) {
        return JavaCore.create((IProject)marker.getResource().getProject());
    }
}

