/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.buildpath;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.junit.buildpath.JUnitContainerInitializer;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class BuildPathSupport {
    public static final JUnitPluginDescription JUNIT3_PLUGIN = new JUnitPluginDescription("org.junit", new VersionRange("[3.8.2,3.9)"), true);
    public static final JUnitPluginDescription JUNIT4_PLUGIN = new JUnitPluginDescription("org.junit4", new VersionRange("[4.3.1,4.4.0)"), false);

    public static IPath getBundleLocation(JUnitPluginDescription pluginDesc) {
        Bundle bundle = pluginDesc.getBundle();
        if (bundle == null) {
            return null;
        }
        URL local = null;
        try {
            local = FileLocator.toFileURL((URL)bundle.getEntry("/"));
        }
        catch (IOException iOException) {
            return null;
        }
        String fullPath = new File(local.getPath()).getAbsolutePath();
        return Path.fromOSString((String)fullPath);
    }

    public static IPath getSourceLocation(JUnitPluginDescription pluginDesc) {
        Bundle bundle = pluginDesc.getBundle();
        if (bundle == null) {
            return null;
        }
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        if (version == null) {
            return null;
        }
        Bundle sourceBundle = null;
        if (pluginDesc.isOrbitBundle()) {
            Bundle[] bundles = JUnitPlugin.getDefault().getBundles(String.valueOf(pluginDesc.getBundleId()) + ".source", version);
            if (bundles != null && bundles.length > 0) {
                sourceBundle = bundles[0];
            }
        } else {
            sourceBundle = JUnitPlugin.getDefault().getBundle("org.eclipse.jdt.source");
        }
        if (sourceBundle == null) {
            return null;
        }
        URL local = null;
        try {
            local = FileLocator.toFileURL((URL)sourceBundle.getEntry("/"));
        }
        catch (IOException iOException) {
            return null;
        }
        String fullPath = String.valueOf(new File(local.getPath()).getAbsolutePath()) + File.separator + "src" + File.separator + pluginDesc.getBundleId() + "_" + version;
        return Path.fromOSString((String)fullPath);
    }

    public static IClasspathEntry getJUnit3ClasspathEntry() {
        return JavaCore.newContainerEntry((IPath)JUnitContainerInitializer.JUNIT3_PATH);
    }

    public static IClasspathEntry getJUnit4ClasspathEntry() {
        return JavaCore.newContainerEntry((IPath)JUnitContainerInitializer.JUNIT4_PATH);
    }

    public static IClasspathEntry getJUnit3LibraryEntry() {
        IPath bundleBase = BuildPathSupport.getBundleLocation(JUNIT3_PLUGIN);
        if (bundleBase != null) {
            IPath jarLocation = bundleBase.append("junit.jar");
            IPath sourceBase = BuildPathSupport.getSourceLocation(JUNIT3_PLUGIN);
            IPath srcLocation = sourceBase != null ? sourceBase.append("junitsrc.zip") : null;
            IAccessRule[] accessRules = new IAccessRule[]{};
            String javadocLocation = JUnitPlugin.getDefault().getPreferenceStore().getString("org.eclipse.jdt.junit.junit3.javadoclocation");
            IClasspathAttribute[] attributes = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)javadocLocation)};
            return JavaCore.newLibraryEntry((IPath)jarLocation, (IPath)srcLocation, null, (IAccessRule[])accessRules, (IClasspathAttribute[])attributes, (boolean)false);
        }
        return null;
    }

    public static IClasspathEntry getJUnit4LibraryEntry() {
        IPath bundleBase = BuildPathSupport.getBundleLocation(JUNIT4_PLUGIN);
        if (bundleBase != null) {
            IPath jarLocation = bundleBase.append("junit.jar");
            IPath sourceBase = BuildPathSupport.getSourceLocation(JUNIT4_PLUGIN);
            IPath srcLocation = sourceBase != null ? sourceBase.append("junitsrc.zip") : null;
            IAccessRule[] accessRules = new IAccessRule[]{};
            String javadocLocation = JUnitPlugin.getDefault().getPreferenceStore().getString("org.eclipse.jdt.junit.junit4.javadoclocation");
            IClasspathAttribute[] attributes = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)javadocLocation)};
            return JavaCore.newLibraryEntry((IPath)jarLocation, (IPath)srcLocation, null, (IAccessRule[])accessRules, (IClasspathAttribute[])attributes, (boolean)false);
        }
        return null;
    }

    public static class JUnitPluginDescription {
        private final String fBundleId;
        private final VersionRange fVersionRange;
        private final boolean fIsOrbitBundle;

        public JUnitPluginDescription(String bundleId, VersionRange versionRange, boolean isOrbitBundle) {
            this.fBundleId = bundleId;
            this.fVersionRange = versionRange;
            this.fIsOrbitBundle = isOrbitBundle;
        }

        public Bundle getBundle() {
            Bundle[] bundles = JUnitPlugin.getDefault().getBundles(this.fBundleId, null);
            if (bundles != null) {
                int i = 0;
                while (i < bundles.length) {
                    Bundle curr = bundles[i];
                    String version = (String)curr.getHeaders().get("Bundle-Version");
                    try {
                        if (this.fVersionRange.isIncluded(Version.parseVersion((String)version))) {
                            return curr;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    ++i;
                }
            }
            return null;
        }

        public String getBundleId() {
            return this.fBundleId;
        }

        public boolean isOrbitBundle() {
            return this.fIsOrbitBundle;
        }
    }
}

