/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractConstantRefactoring;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.TextInputWizardPage;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.VariableNamesProcessor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.RowLayouter;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExtractConstantWizard
extends RefactoringWizard {
    private static final String MESSAGE = RefactoringMessages.ExtractConstantInputPage_enter_name;

    public ExtractConstantWizard(ExtractConstantRefactoring ref) {
        super((Refactoring)ref, 36);
        this.setDefaultPageTitle(RefactoringMessages.ExtractConstantWizard_defaultPageTitle);
    }

    protected void addUserInputPages() {
        String message = null;
        int messageType = 0;
        if (!this.getExtractConstantRefactoring().selectionAllStaticFinal()) {
            message = RefactoringMessages.ExtractConstantInputPage_selection_refers_to_nonfinal_fields;
            messageType = 1;
        } else {
            message = MESSAGE;
            messageType = 0;
        }
        String[] guessedNames = this.getExtractConstantRefactoring().guessConstantNames();
        String initialValue = guessedNames.length == 0 ? "" : guessedNames[0];
        this.addPage((IWizardPage)new ExtractConstantInputPage(message, messageType, initialValue, guessedNames));
    }

    private ExtractConstantRefactoring getExtractConstantRefactoring() {
        return (ExtractConstantRefactoring)this.getRefactoring();
    }

    private static class ExtractConstantInputPage
    extends TextInputWizardPage {
        private static final String QUALIFY_REFERENCES = "qualifyReferences";
        private Label fLabel;
        private final boolean fInitialValid;
        private final int fOriginalMessageType;
        private final String fOriginalMessage;
        private Button fQualifyReferences;
        private String[] fConstNameProposals;
        private VariableNamesProcessor fContentAssistProcessor;
        private String fAccessModifier;

        public ExtractConstantInputPage(String description, int messageType, String initialValue, String[] guessedNames) {
            super(description, true, initialValue);
            this.fOriginalMessage = description;
            this.fOriginalMessageType = messageType;
            this.fInitialValid = !"".equals(initialValue);
            this.fConstNameProposals = guessedNames;
        }

        public void createControl(Composite parent) {
            Composite result = new Composite(parent, 0);
            this.setControl((Control)result);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.verticalSpacing = 8;
            result.setLayout((Layout)layout);
            RowLayouter layouter = new RowLayouter(2);
            Label label = new Label(result, 0);
            label.setText(RefactoringMessages.ExtractConstantInputPage_constant_name);
            Text text = this.createTextInputField(result);
            text.selectAll();
            text.setLayoutData((Object)new GridData(768));
            if (this.fConstNameProposals.length > 0) {
                this.fContentAssistProcessor = new VariableNamesProcessor(this.fConstNameProposals);
                ControlContentAssistHelper.createTextContentAssistant(text, this.fContentAssistProcessor);
            }
            layouter.perform((Control)label, (Control)text, 1);
            this.addAccessModifierGroup(result, layouter);
            this.addReplaceAllCheckbox(result, layouter);
            this.addQualifyReferencesCheckbox(result, layouter);
            this.addSeparator(result, layouter);
            this.addLabel(result, layouter);
            this.validateTextField(text.getText());
            Dialog.applyDialogFont((Control)result);
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.extract_constant_page_context");
        }

        private void addAccessModifierGroup(Composite result, RowLayouter layouter) {
            this.fAccessModifier = this.getExtractConstantRefactoring().getVisibility();
            if (this.getExtractConstantRefactoring().getTargetIsInterface()) {
                return;
            }
            Label label = new Label(result, 0);
            label.setText(RefactoringMessages.ExtractConstantInputPage_access_modifiers);
            Composite group = new Composite(result, 0);
            group.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout();
            layout.numColumns = 4;
            layout.marginWidth = 0;
            group.setLayout((Layout)layout);
            String[] labels = new String[]{RefactoringMessages.ExtractMethodInputPage_public, RefactoringMessages.ExtractMethodInputPage_protected, RefactoringMessages.ExtractMethodInputPage_default, RefactoringMessages.ExtractMethodInputPage_private};
            String[] data = new String[]{"public", "protected", "", "private"};
            this.updateContentAssistImage();
            int i = 0;
            while (i < labels.length) {
                Button radio = new Button(group, 16);
                radio.setText(labels[i]);
                radio.setData((Object)data[i]);
                if (data[i] == this.fAccessModifier) {
                    radio.setSelection(true);
                }
                radio.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ ExtractConstantInputPage this$1;
                    {
                        this.this$1 = extractConstantInputPage;
                    }

                    public void widgetSelected(SelectionEvent event) {
                        ExtractConstantInputPage.access$0(this.this$1, (String)event.widget.getData());
                    }
                });
                ++i;
            }
            layouter.perform((Control)label, (Control)group, 1);
        }

        private void updateContentAssistImage() {
            if (this.fContentAssistProcessor == null) {
                return;
            }
            int flags = this.fAccessModifier == "private" ? 2 : (this.fAccessModifier == "protected" ? 4 : (this.fAccessModifier == "public" ? 1 : 0));
            Object imageDesc = JavaElementImageProvider.getFieldImageDescriptor(false, flags);
            imageDesc = new JavaElementImageDescriptor((ImageDescriptor)imageDesc, 10, JavaElementImageProvider.BIG_SIZE);
            this.fContentAssistProcessor.setProposalImageDescriptor((ImageDescriptor)imageDesc);
        }

        private void addReplaceAllCheckbox(Composite result, RowLayouter layouter) {
            String title = RefactoringMessages.ExtractConstantInputPage_replace_all;
            boolean defaultValue = this.getExtractConstantRefactoring().replaceAllOccurrences();
            Button checkBox = ExtractConstantInputPage.createCheckbox(result, title, defaultValue, layouter);
            this.getExtractConstantRefactoring().setReplaceAllOccurrences(checkBox.getSelection());
            checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(this, checkBox){
                final /* synthetic */ ExtractConstantInputPage this$1;
                private final /* synthetic */ Button val$checkBox;
                {
                    this.this$1 = extractConstantInputPage;
                    this.val$checkBox = button;
                }

                public void widgetSelected(SelectionEvent e) {
                    ExtractConstantInputPage.access$1(this.this$1).setReplaceAllOccurrences(this.val$checkBox.getSelection());
                }
            });
        }

        private void addQualifyReferencesCheckbox(Composite result, RowLayouter layouter) {
            String title = RefactoringMessages.ExtractConstantInputPage_qualify_constant_references_with_class_name;
            boolean defaultValue = this.getBooleanSetting(QUALIFY_REFERENCES, this.getExtractConstantRefactoring().qualifyReferencesWithDeclaringClassName());
            this.fQualifyReferences = ExtractConstantInputPage.createCheckbox(result, title, defaultValue, layouter);
            this.getExtractConstantRefactoring().setQualifyReferencesWithDeclaringClassName(this.fQualifyReferences.getSelection());
            this.fQualifyReferences.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ExtractConstantInputPage this$1;
                {
                    this.this$1 = extractConstantInputPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    ExtractConstantInputPage.access$1(this.this$1).setQualifyReferencesWithDeclaringClassName(ExtractConstantInputPage.access$2(this.this$1).getSelection());
                }
            });
        }

        private void addLabel(Composite result, RowLayouter layouter) {
            this.fLabel = new Label(result, 64);
            GridData gd = new GridData(1808);
            gd.widthHint = this.convertWidthInCharsToPixels(50);
            this.fLabel.setLayoutData((Object)gd);
            this.updatePreviewLabel();
            layouter.perform((Control)this.fLabel);
        }

        private void addSeparator(Composite result, RowLayouter layouter) {
            Label separator = new Label(result, 258);
            separator.setLayoutData((Object)new GridData(768));
            layouter.perform((Control)separator);
        }

        private void updatePreviewLabel() {
            try {
                if (this.fLabel != null) {
                    this.fLabel.setText(String.valueOf(RefactoringMessages.ExtractConstantInputPage_signature_preview) + this.getExtractConstantRefactoring().getConstantSignaturePreview());
                }
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.ExtractTempInputPage_extract_local, RefactoringMessages.ExtractConstantInputPage_exception);
            }
        }

        protected RefactoringStatus validateTextField(String text) {
            try {
                this.getExtractConstantRefactoring().setConstantName(text);
                this.updatePreviewLabel();
                RefactoringStatus result = this.getExtractConstantRefactoring().checkConstantNameOnChange();
                if (this.fOriginalMessageType == 1 && result.getSeverity() == 0) {
                    return RefactoringStatus.createInfoStatus((String)this.fOriginalMessage);
                }
                return result;
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringMessages.ExtractConstantInputPage_Internal_Error);
            }
        }

        private void setAccessModifier(String accessModifier) {
            this.getExtractConstantRefactoring().setVisibility(accessModifier);
            this.fAccessModifier = accessModifier;
            this.updateContentAssistImage();
            this.updatePreviewLabel();
        }

        private ExtractConstantRefactoring getExtractConstantRefactoring() {
            return (ExtractConstantRefactoring)this.getRefactoring();
        }

        private static Button createCheckbox(Composite parent, String title, boolean value, RowLayouter layouter) {
            Button checkBox = new Button(parent, 32);
            checkBox.setText(title);
            checkBox.setSelection(value);
            layouter.perform((Control)checkBox);
            return checkBox;
        }

        protected boolean isInitialInputValid() {
            return this.fInitialValid;
        }

        protected void restoreMessage() {
            this.setMessage(this.fOriginalMessage, this.fOriginalMessageType);
        }

        private boolean getBooleanSetting(String key, boolean defaultValue) {
            String update = this.getRefactoringSettings().get(key);
            if (update != null) {
                return Boolean.valueOf(update);
            }
            return defaultValue;
        }

        private void saveBooleanSetting(String key, Button checkBox) {
            if (checkBox != null) {
                this.getRefactoringSettings().put(key, checkBox.getSelection());
            }
        }

        private boolean saveSettings() {
            if (this.getContainer() instanceof Dialog) {
                return ((Dialog)this.getContainer()).getReturnCode() == 0;
            }
            return true;
        }

        public void dispose() {
            if (this.saveSettings()) {
                this.saveBooleanSetting(QUALIFY_REFERENCES, this.fQualifyReferences);
            }
            super.dispose();
        }

        static /* synthetic */ void access$0(ExtractConstantInputPage extractConstantInputPage, String string) {
            extractConstantInputPage.setAccessModifier(string);
        }

        static /* synthetic */ ExtractConstantRefactoring access$1(ExtractConstantInputPage extractConstantInputPage) {
            return extractConstantInputPage.getExtractConstantRefactoring();
        }

        static /* synthetic */ Button access$2(ExtractConstantInputPage extractConstantInputPage) {
            return extractConstantInputPage.fQualifyReferences;
        }
    }
}

