/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackager;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.ltk.ui.refactoring.history.ISortableRefactoringHistoryControl;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class JarRefactoringDialog
extends TrayDialog {
    private static final String SETTING_SORT = "org.eclipse.jdt.ui.jar.export.sortRefactorings";
    private final JarPackageData fData;
    private Button fExportStructural = null;
    private final RefactoringHistory fHistory;
    private ISortableRefactoringHistoryControl fHistoryControl = null;
    private final IDialogSettings fSettings;

    public JarRefactoringDialog(Shell shell, IDialogSettings settings, JarPackageData data, RefactoringHistory history) {
        super(shell);
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)history);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fSettings = settings;
        this.fData = data;
        this.fHistory = history;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.fData.setRefactoringAware(true);
            RefactoringDescriptorProxy[] descriptors = this.fHistoryControl.getCheckedDescriptors();
            HashSet<IProject> set = new HashSet<IProject>();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            int index = 0;
            while (index < descriptors.length) {
                String project = descriptors[index].getProject();
                if (project != null && !"".equals(project)) {
                    set.add(root.getProject(project));
                }
                ++index;
            }
            this.fData.setRefactoringProjects(set.toArray(new IProject[set.size()]));
            this.fData.setRefactoringDescriptors(descriptors);
            this.fData.setExportStructuralOnly(this.fExportStructural.getSelection());
            IDialogSettings settings = this.fSettings;
            if (settings != null) {
                settings.put(SETTING_SORT, this.fHistoryControl.isSortByProjects());
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(JarPackagerMessages.JarRefactoringDialog_dialog_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.jdt.ui.jar_packager_refactoring_dialog_context");
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(!this.fHistory.isEmpty());
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)container);
        Composite composite = new Composite(container, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        RefactoringHistoryControlConfiguration configuration = new RefactoringHistoryControlConfiguration(null, true, true){

            public final String getWorkspaceCaption() {
                return JarPackagerMessages.JarRefactoringDialog_workspace_caption;
            }
        };
        this.fHistoryControl = (ISortableRefactoringHistoryControl)RefactoringUI.createSortableRefactoringHistoryControl((Composite)composite, (RefactoringHistoryControlConfiguration)configuration);
        this.fHistoryControl.createControl();
        boolean sortProjects = true;
        IDialogSettings settings = this.fSettings;
        if (settings != null) {
            sortProjects = settings.getBoolean(SETTING_SORT);
        }
        if (sortProjects) {
            this.fHistoryControl.sortByProjects();
        } else {
            this.fHistoryControl.sortByDate();
        }
        GridData data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(32);
        data.widthHint = this.convertWidthInCharsToPixels(72);
        this.fHistoryControl.getControl().setLayoutData((Object)data);
        this.fHistoryControl.setInput(this.fHistory);
        this.fHistoryControl.setCheckedDescriptors(this.fData.getRefactoringDescriptors());
        this.createPlainLabel(composite, JarPackagerMessages.JarPackageWizardPage_options_label);
        this.createOptionsGroup(composite);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected void createOptionsGroup(Composite parent) {
        Composite optionsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        optionsGroup.setLayout((Layout)layout);
        this.fExportStructural = new Button(optionsGroup, 16416);
        this.fExportStructural.setText(JarPackagerMessages.JarRefactoringDialog_export_structural);
        this.fExportStructural.setSelection(this.fData.isExportStructuralOnly());
    }

    protected Label createPlainLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setFont(parent.getFont());
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }
}

