/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;

public final class ImportRewriteUtil {
    public static void addImports(CompilationUnitRewrite rewrite, ASTNode node, Map typeImports, Map staticImports, boolean declarations) {
        ImportRewriteUtil.addImports(rewrite, node, typeImports, staticImports, null, declarations);
    }

    public static void addImports(CompilationUnitRewrite rewrite, ASTNode node, Map typeImports, Map staticImports, Collection excludeBindings, final boolean declarations) {
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)node);
        Assert.isNotNull((Object)typeImports);
        Assert.isNotNull((Object)staticImports);
        HashSet types = new HashSet();
        HashSet members = new HashSet();
        ImportReferencesCollector collector = new ImportReferencesCollector(rewrite.getCu().getJavaProject(), null, types, members){

            public final boolean visit(Block block) {
                Assert.isNotNull((Object)block);
                if (declarations && block.getParent() instanceof MethodDeclaration) {
                    return false;
                }
                return super.visit(block);
            }
        };
        node.accept((ASTVisitor)collector);
        ImportRewrite rewriter = rewrite.getImportRewrite();
        ImportRemover remover = rewrite.getImportRemover();
        Name name = null;
        IBinding binding = null;
        Iterator iterator = types.iterator();
        while (iterator.hasNext()) {
            name = (Name)iterator.next();
            binding = name.resolveBinding();
            if (!(binding instanceof ITypeBinding)) continue;
            ITypeBinding type = (ITypeBinding)binding;
            if (excludeBindings != null && excludeBindings.contains(type)) continue;
            typeImports.put(name, rewriter.addImport(type));
            remover.registerAddedImport(type.getQualifiedName());
        }
        iterator = members.iterator();
        while (iterator.hasNext()) {
            IMethodBinding method;
            ITypeBinding declaring;
            name = (Name)iterator.next();
            binding = name.resolveBinding();
            if (binding instanceof IVariableBinding) {
                IVariableBinding variable = (IVariableBinding)binding;
                declaring = variable.getDeclaringClass();
                if (declaring == null || excludeBindings != null && excludeBindings.contains(variable)) continue;
                staticImports.put(name, rewriter.addStaticImport((IBinding)variable));
                remover.registerAddedStaticImport(declaring.getQualifiedName(), variable.getName(), true);
                continue;
            }
            if (!(binding instanceof IMethodBinding) || (declaring = (method = (IMethodBinding)binding).getDeclaringClass()) == null || excludeBindings != null && excludeBindings.contains(method)) continue;
            staticImports.put(name, rewriter.addStaticImport((IBinding)method));
            remover.registerAddedStaticImport(declaring.getQualifiedName(), method.getName(), false);
        }
    }

    public static void collectImports(IJavaProject project, ASTNode node, Collection typeBindings, Collection staticBindings, boolean declarations) {
        ImportRewriteUtil.collectImports(project, node, typeBindings, staticBindings, null, declarations);
    }

    public static void collectImports(IJavaProject project, ASTNode node, Collection typeBindings, Collection staticBindings, Collection excludeBindings, final boolean declarations) {
        Assert.isNotNull((Object)project);
        Assert.isNotNull((Object)node);
        Assert.isNotNull((Object)typeBindings);
        Assert.isNotNull((Object)staticBindings);
        HashSet types = new HashSet();
        HashSet members = new HashSet();
        ImportReferencesCollector collector = new ImportReferencesCollector(project, null, types, members){

            public final boolean visit(Block block) {
                Assert.isNotNull((Object)block);
                if (declarations && block.getParent() instanceof MethodDeclaration) {
                    return false;
                }
                return super.visit(block);
            }
        };
        node.accept((ASTVisitor)collector);
        Name name = null;
        IBinding binding = null;
        Iterator iterator = types.iterator();
        while (iterator.hasNext()) {
            name = (Name)iterator.next();
            binding = name.resolveBinding();
            if (!(binding instanceof ITypeBinding)) continue;
            ITypeBinding type = (ITypeBinding)binding;
            if (excludeBindings != null && excludeBindings.contains(type)) continue;
            typeBindings.add(type);
        }
        iterator = members.iterator();
        while (iterator.hasNext()) {
            name = (Name)iterator.next();
            binding = name.resolveBinding();
            if (binding == null || excludeBindings != null && excludeBindings.contains(binding)) continue;
            staticBindings.add(binding);
        }
    }

    private ImportRewriteUtil() {
    }
}

