/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.process;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.gradle.internal.InternalTransformer;
import org.gradle.internal.process.ArgCollector;

public class ArgWriter
implements ArgCollector {
    private static final Pattern WHITESPACE = Pattern.compile("\\s");
    private static final Pattern WHITESPACE_OR_HASH = Pattern.compile("\\s|#");
    private final PrintWriter writer;
    private final boolean backslashEscape;
    private final Pattern quotablePattern;

    private ArgWriter(PrintWriter writer, boolean backslashEscape, Pattern quotablePattern) {
        this.writer = writer;
        this.backslashEscape = backslashEscape;
        this.quotablePattern = quotablePattern;
    }

    public static ArgWriter unixStyle(PrintWriter writer) {
        return new ArgWriter(writer, true, WHITESPACE);
    }

    public static InternalTransformer<ArgWriter, PrintWriter> unixStyleFactory() {
        return new InternalTransformer<ArgWriter, PrintWriter>(){

            public ArgWriter transform(PrintWriter original) {
                return ArgWriter.unixStyle(original);
            }
        };
    }

    public static ArgWriter javaStyle(PrintWriter writer) {
        return new ArgWriter(writer, true, WHITESPACE_OR_HASH);
    }

    public static InternalTransformer<ArgWriter, PrintWriter> javaStyleFactory() {
        return new InternalTransformer<ArgWriter, PrintWriter>(){

            public ArgWriter transform(PrintWriter original) {
                return ArgWriter.javaStyle(original);
            }
        };
    }

    public static ArgWriter windowsStyle(PrintWriter writer) {
        return new ArgWriter(writer, false, WHITESPACE);
    }

    public static InternalTransformer<ArgWriter, PrintWriter> windowsStyleFactory() {
        return new InternalTransformer<ArgWriter, PrintWriter>(){

            public ArgWriter transform(PrintWriter original) {
                return ArgWriter.windowsStyle(original);
            }
        };
    }

    public static InternalTransformer<List<String>, List<String>> argsFileGenerator(final File argsFile, final InternalTransformer<ArgWriter, PrintWriter> argWriterFactory) {
        return new InternalTransformer<List<String>, List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<String> transform(List<String> args) {
                if (args.isEmpty()) {
                    return args;
                }
                argsFile.getParentFile().mkdirs();
                try (PrintWriter writer = new PrintWriter(argsFile);){
                    ArgWriter argWriter = (ArgWriter)argWriterFactory.transform((Object)writer);
                    argWriter.args(args);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(String.format("Could not write options file '%s'.", argsFile.getAbsolutePath()), e);
                }
                return Collections.singletonList("@" + argsFile.getAbsolutePath());
            }
        };
    }

    @Override
    public ArgWriter args(Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (i > 0) {
                this.writer.print(' ');
            }
            String str = arg.toString();
            if (this.backslashEscape) {
                str = str.replace("\\", "\\\\").replace("\"", "\\\"");
            }
            if (str.isEmpty()) {
                this.writer.print("\"\"");
                continue;
            }
            if (this.needsQuoting(str)) {
                this.writer.print('\"');
                this.writer.print(str);
                this.writer.print('\"');
                continue;
            }
            this.writer.print(str);
        }
        this.writer.println();
        return this;
    }

    private boolean needsQuoting(String str) {
        return this.quotablePattern.matcher(str).find();
    }

    @Override
    public ArgCollector args(Iterable<?> args) {
        for (Object arg : args) {
            this.args(arg);
        }
        return this;
    }
}

