/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.gradle.api.Named;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AbstractAttributeContainer;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.isolation.Isolatable;

public final class DefaultImmutableAttributesContainer
extends AbstractAttributeContainer
implements ImmutableAttributes,
AttributeValue<Object> {
    private static final Comparator<Attribute<?>> ATTRIBUTE_NAME_COMPARATOR = Comparator.comparing(Attribute::getName);
    private final Map<Attribute<?>, Object> coercionCache = new ConcurrentHashMap();
    final Attribute<?> attribute;
    final Isolatable<?> value;
    private final ImmutableMap<Attribute<?>, DefaultImmutableAttributesContainer> hierarchy;
    private final ImmutableMap<String, DefaultImmutableAttributesContainer> hierarchyByName;
    private final int hashCode;
    private final String singleEntryName;
    private final DefaultImmutableAttributesContainer singleEntryValue;

    DefaultImmutableAttributesContainer() {
        this.attribute = null;
        this.value = null;
        this.hashCode = 0;
        this.hierarchy = ImmutableMap.of();
        this.hierarchyByName = ImmutableMap.of();
        this.singleEntryName = null;
        this.singleEntryValue = null;
    }

    DefaultImmutableAttributesContainer(DefaultImmutableAttributesContainer parent, Attribute<?> key, Isolatable<?> value) {
        this.attribute = key;
        this.value = value;
        LinkedHashMap hierarchy = new LinkedHashMap((Map<Attribute<?>, DefaultImmutableAttributesContainer>)parent.hierarchy);
        hierarchy.put(this.attribute, this);
        this.hierarchy = ImmutableMap.copyOf(hierarchy);
        LinkedHashMap<String, DefaultImmutableAttributesContainer> hierarchyByName = new LinkedHashMap<String, DefaultImmutableAttributesContainer>((Map<String, DefaultImmutableAttributesContainer>)parent.hierarchyByName);
        hierarchyByName.put(this.attribute.getName(), this);
        this.hierarchyByName = ImmutableMap.copyOf(hierarchyByName);
        int hashCode = parent.hashCode();
        hashCode = 31 * hashCode + this.attribute.hashCode();
        this.hashCode = hashCode = 31 * hashCode + value.hashCode();
        if (hierarchyByName.size() == 1) {
            Map.Entry entry = hierarchyByName.entrySet().iterator().next();
            this.singleEntryName = (String)entry.getKey();
            this.singleEntryValue = (DefaultImmutableAttributesContainer)entry.getValue();
        } else {
            this.singleEntryName = null;
            this.singleEntryValue = null;
        }
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultImmutableAttributesContainer that = (DefaultImmutableAttributesContainer)o;
        if (this.hierarchy.size() != that.hierarchy.size()) {
            return false;
        }
        for (Map.Entry entry : this.hierarchy.entrySet()) {
            if (Objects.requireNonNull(((DefaultImmutableAttributesContainer)entry.getValue()).value.isolate()).equals(that.getAttribute((Attribute)entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    public <T> AttributeContainer attribute(Attribute<T> key, T value) {
        throw new UnsupportedOperationException("Mutation of attributes is not allowed");
    }

    @Override
    public ImmutableSet<Attribute<?>> keySet() {
        return this.hierarchy.keySet();
    }

    public <T> AttributeContainer attributeProvider(Attribute<T> key, Provider<? extends T> provider) {
        throw new UnsupportedOperationException("Mutation of attributes is not allowed");
    }

    @Nullable
    public <T> T getAttribute(Attribute<T> key) {
        if (!this.isValidAttributeRequest(key)) {
            return null;
        }
        Isolatable<T> isolatable = this.getIsolatableAttribute(key);
        if (isolatable == null) {
            return null;
        }
        Object value = isolatable.isolate();
        if (!this.isAppropriateType(value, key)) {
            value = isolatable.coerce(key.getType());
        }
        return (T)Cast.uncheckedCast((Object)value);
    }

    private boolean isAppropriateType(@Nullable Object value, Attribute<?> key) {
        return value != null && key.getType().isAssignableFrom(value.getClass());
    }

    @Nullable
    <T> Isolatable<T> getIsolatableAttribute(Attribute<T> key) {
        DefaultImmutableAttributesContainer attributes = (DefaultImmutableAttributesContainer)this.hierarchyByName.get((Object)key.getName());
        return (Isolatable)Cast.uncheckedCast(attributes == null ? null : attributes.value);
    }

    @Override
    public <T> AttributeValue<T> findEntry(Attribute<T> key) {
        DefaultImmutableAttributesContainer attributes = (DefaultImmutableAttributesContainer)this.hierarchy.get(key);
        return (AttributeValue)Cast.uncheckedNonnullCast((Object)(attributes == null ? MISSING : attributes));
    }

    @Override
    public AttributeValue<?> findEntry(String name) {
        if (this.singleEntryName == name) {
            return this.singleEntryValue;
        }
        DefaultImmutableAttributesContainer attributes = (DefaultImmutableAttributesContainer)this.hierarchyByName.get((Object)name);
        return attributes == null ? MISSING : attributes;
    }

    @Override
    @Nullable
    public Attribute<?> findAttribute(String name) {
        DefaultImmutableAttributesContainer attributes = (DefaultImmutableAttributesContainer)this.hierarchyByName.get((Object)name);
        return attributes == null ? null : attributes.attribute;
    }

    @Override
    public Object get() {
        Preconditions.checkState((this.value != null ? 1 : 0) != 0, (Object)"When calling get() value should never be null");
        return this.value.isolate();
    }

    @Nullable
    private String desugar() {
        if (Named.class.isAssignableFrom(this.attribute.getType())) {
            return ((Named)this.get()).getName();
        }
        if (Enum.class.isAssignableFrom(this.attribute.getType())) {
            return ((Enum)this.get()).name();
        }
        return null;
    }

    @Override
    @Nullable
    private <S> S coerce(Class<S> type) {
        if (this.value != null) {
            return (S)this.value.coerce(type);
        }
        return null;
    }

    @Override
    public <S> S coerce(Attribute<S> otherAttribute) {
        Preconditions.checkState((this.value != null ? 1 : 0) != 0, (Object)"When coercing, value should never be null");
        Object s = Cast.uncheckedCast((Object)this.coercionCache.get(otherAttribute));
        if (s == null) {
            s = this.uncachedCoerce(otherAttribute);
            this.coercionCache.put(otherAttribute, s);
        }
        return (S)s;
    }

    private <S> S uncachedCoerce(Attribute<S> otherAttribute) {
        Class otherAttributeType = otherAttribute.getType();
        if (otherAttributeType.isAssignableFrom(this.attribute.getType())) {
            return (S)Cast.uncheckedCast((Object)this.get());
        }
        Object converted = this.coerce(otherAttributeType);
        if (converted != null) {
            return converted;
        }
        if (otherAttributeType.isAssignableFrom(String.class) && (converted = Cast.uncheckedCast((Object)this.desugar())) != null) {
            return converted;
        }
        String foundType = this.get().getClass().getName();
        if (foundType.equals(otherAttributeType.getName())) {
            foundType = foundType + " with a different ClassLoader";
        }
        throw new IllegalArgumentException(String.format("Unexpected type for attribute '%s' provided. Expected a value of type %s but found a value of type %s.", this.attribute.getName(), otherAttributeType.getName(), foundType));
    }

    @Override
    public boolean isPresent() {
        return this.attribute != null;
    }

    @Override
    public boolean isEmpty() {
        return this.attribute == null;
    }

    @Override
    public boolean contains(Attribute<?> key) {
        return this.hierarchy.containsKey(key);
    }

    @Override
    public ImmutableAttributes asImmutable() {
        return this;
    }

    @Override
    public Map<Attribute<?>, ?> asMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Attribute attribute : this.keySet()) {
            builder.put((Object)attribute, Cast.uncheckedCast(this.getAttribute(attribute)));
        }
        return builder.build();
    }

    public String toString() {
        TreeMap sorted = new TreeMap(ATTRIBUTE_NAME_COMPARATOR);
        for (Map.Entry entry : this.hierarchy.entrySet()) {
            sorted.put((Attribute)entry.getKey(), ((DefaultImmutableAttributesContainer)entry.getValue()).value.isolate());
        }
        return ((Object)sorted).toString();
    }
}

