/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.configurations.ConflictResolution;
import org.gradle.api.internal.artifacts.dsl.ImmutableModuleReplacements;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionApplicator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DownloadMetadataOperation;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CapabilitiesConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.DefaultCapabilitiesConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.DefaultConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ModuleConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.PotentialConflict;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.AttributeSchemaServices;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.api.internal.attributes.matching.AttributeMatcher;
import org.gradle.api.internal.capabilities.CapabilityInternal;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Factory;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveState;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentIdGenerator;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.GraphVariantSelector;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.resolution.failure.ResolutionFailureHandler;
import org.gradle.internal.component.resolution.failure.exception.AbstractResolutionFailureException;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationConstraint;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyGraphBuilder {
    static final Spec<EdgeState> ENDORSE_STRICT_VERSIONS_DEPENDENCY_SPEC = dependencyState -> dependencyState.getDependencyState().getDependency().isEndorsingStrictVersions();
    static final Spec<EdgeState> NOT_ENDORSE_STRICT_VERSIONS_DEPENDENCY_SPEC = dependencyState -> !dependencyState.getDependencyState().getDependency().isEndorsingStrictVersions();
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyGraphBuilder.class);
    private final ModuleExclusions moduleExclusions;
    private final AttributesFactory attributesFactory;
    private final AttributeSchemaServices attributeSchemaServices;
    private final AttributeDesugaring attributeDesugaring;
    private final VersionSelectorScheme versionSelectorScheme;
    private final VersionComparator versionComparator;
    private final ComponentIdGenerator idGenerator;
    private final VersionParser versionParser;
    private final GraphVariantSelector variantSelector;
    private final BuildOperationExecutor buildOperationExecutor;

    @Inject
    public DependencyGraphBuilder(ModuleExclusions moduleExclusions, AttributesFactory attributesFactory, AttributeSchemaServices attributeSchemaServices, AttributeDesugaring attributeDesugaring, VersionSelectorScheme versionSelectorScheme, VersionComparator versionComparator, ComponentIdGenerator idGenerator, VersionParser versionParser, GraphVariantSelector variantSelector, BuildOperationExecutor buildOperationExecutor) {
        this.moduleExclusions = moduleExclusions;
        this.attributesFactory = attributesFactory;
        this.attributeSchemaServices = attributeSchemaServices;
        this.attributeDesugaring = attributeDesugaring;
        this.versionSelectorScheme = versionSelectorScheme;
        this.versionComparator = versionComparator;
        this.idGenerator = idGenerator;
        this.versionParser = versionParser;
        this.variantSelector = variantSelector;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    public void resolve(LocalComponentGraphResolveState rootComponent, LocalVariantGraphResolveState rootVariant, List<? extends DependencyMetadata> syntheticDependencies, Spec<? super DependencyMetadata> edgeFilter, ComponentSelectorConverter componentSelectorConverter, DependencyToComponentIdResolver componentIdResolver, ComponentMetaDataResolver componentMetaDataResolver, ImmutableModuleReplacements moduleReplacements, DependencySubstitutionApplicator dependencySubstitutionApplicator, ModuleConflictResolver<ComponentState> moduleConflictResolver, List<CapabilitiesConflictHandler.Resolver> capabilityConflictResolvers, ConflictResolution conflictResolution, boolean failingOnDynamicVersions, boolean failingOnChangingVersions, DependencyGraphVisitor modelVisitor) {
        DefaultConflictHandler moduleConflictHandler = new DefaultConflictHandler(moduleConflictResolver, moduleReplacements);
        DefaultCapabilitiesConflictHandler capabilitiesConflictHandler = new DefaultCapabilitiesConflictHandler(capabilityConflictResolvers);
        ResolveState resolveState = new ResolveState(this.idGenerator, rootComponent, rootVariant, componentIdResolver, componentMetaDataResolver, edgeFilter, this.moduleExclusions, componentSelectorConverter, this.attributesFactory, this.attributeSchemaServices, this.attributeDesugaring, dependencySubstitutionApplicator, this.versionSelectorScheme, this.versionComparator, this.versionParser, conflictResolution, syntheticDependencies, moduleConflictHandler, capabilitiesConflictHandler, this.variantSelector);
        this.traverseGraph(resolveState);
        DependencyGraphBuilder.validateGraph(resolveState, failingOnDynamicVersions, failingOnChangingVersions);
        DependencyGraphBuilder.assembleResult(resolveState, modelVisitor);
    }

    private void traverseGraph(ResolveState resolveState) {
        resolveState.onMoreSelected(resolveState.getRoot());
        ArrayList<EdgeState> dependencies = new ArrayList<EdgeState>();
        ModuleConflictHandler moduleConflictHandler = resolveState.getModuleConflictHandler();
        CapabilitiesConflictHandler capabilitiesConflictHandler = resolveState.getCapabilitiesConflictHandler();
        while (resolveState.peek() != null || moduleConflictHandler.hasConflicts() || capabilitiesConflictHandler.hasConflicts()) {
            if (resolveState.peek() != null) {
                NodeState node = resolveState.pop();
                LOGGER.debug("Visiting configuration {}.", (Object)node);
                if (!node.getComponent().isSelected()) {
                    node.cleanupConstraints();
                    continue;
                }
                if (DependencyGraphBuilder.registerCapabilities(resolveState, node)) continue;
                dependencies.clear();
                node.visitOutgoingDependencies(dependencies);
                boolean edgeWasProcessed = this.resolveEdges(node, dependencies, ENDORSE_STRICT_VERSIONS_DEPENDENCY_SPEC, false, resolveState);
                node.collectEndorsedStrictVersions(dependencies);
                this.resolveEdges(node, dependencies, NOT_ENDORSE_STRICT_VERSIONS_DEPENDENCY_SPEC, edgeWasProcessed, resolveState);
                continue;
            }
            if (moduleConflictHandler.hasConflicts()) {
                moduleConflictHandler.resolveNextConflict(resolveState.getReplaceSelectionWithConflictResultAction());
                continue;
            }
            capabilitiesConflictHandler.resolveNextConflict(resolveState.getReplaceSelectionWithConflictResultAction());
        }
    }

    private static boolean registerCapabilities(final ResolveState resolveState, final NodeState node) {
        final AtomicBoolean foundConflict = new AtomicBoolean(false);
        final CapabilitiesConflictHandler capabilitiesConflictHandler = resolveState.getCapabilitiesConflictHandler();
        node.forEachCapability(capabilitiesConflictHandler, (Action<? super CapabilityInternal>)new Action<CapabilityInternal>(){

            public void execute(CapabilityInternal capability) {
                PotentialConflict c;
                List<NodeState> implicitProvidersForCapability = Collections.emptyList();
                for (ModuleResolveState state : resolveState.getModules()) {
                    if (!state.getId().getGroup().equals(capability.getGroup()) || !state.getId().getName().equals(capability.getName())) continue;
                    Collection<ComponentState> versions = state.getVersions();
                    implicitProvidersForCapability = new ArrayList<NodeState>(versions.size());
                    for (ComponentState version : versions) {
                        List<NodeState> nodes = version.getNodes();
                        for (NodeState nodeState : nodes) {
                            if (node == nodeState || !nodeState.isSelected() || !this.doesNotDeclareExplicitCapability(nodeState)) continue;
                            implicitProvidersForCapability.add(nodeState);
                        }
                    }
                }
                if ((c = capabilitiesConflictHandler.registerCandidate(DefaultCapabilitiesConflictHandler.candidate(node, capability, implicitProvidersForCapability))).conflictExists()) {
                    c.withParticipatingModules(resolveState.getDeselectVersionAction());
                    foundConflict.set(true);
                }
            }

            private boolean doesNotDeclareExplicitCapability(NodeState nodeState) {
                return nodeState.getMetadata().getCapabilities().asSet().isEmpty();
            }
        });
        return foundConflict.get();
    }

    private boolean resolveEdges(NodeState node, List<EdgeState> dependencies, Spec<EdgeState> edgeFilter, boolean recomputeSelectors, ResolveState resolveState) {
        if (dependencies.isEmpty()) {
            return false;
        }
        if (DependencyGraphBuilder.performSelectionSerially(dependencies, edgeFilter, resolveState, recomputeSelectors)) {
            DependencyGraphBuilder.maybeDownloadMetadataInParallel(node, dependencies, edgeFilter, this.buildOperationExecutor, resolveState.getComponentMetadataResolver());
            DependencyGraphBuilder.attachToTargetRevisionsSerially(dependencies, edgeFilter);
            return true;
        }
        return false;
    }

    private static boolean performSelectionSerially(List<EdgeState> edges, Spec<EdgeState> edgeFilter, ResolveState resolveState, boolean recomputeSelectors) {
        boolean processed = false;
        for (EdgeState edge : edges) {
            if (!edgeFilter.isSatisfiedBy((Object)edge)) continue;
            if (recomputeSelectors) {
                edge.computeSelector();
            }
            SelectorState selector = edge.getSelector();
            ModuleResolveState module = selector.getTargetModule();
            if (selector.canAffectSelection() && module.getSelectors().size() > 0) {
                DependencyGraphBuilder.performSelection(resolveState, module);
            }
            if (edge.isUsed()) {
                module.addUnattachedEdge(edge);
            }
            processed = true;
        }
        return processed;
    }

    private static void performSelection(ResolveState resolveState, ModuleResolveState module) {
        ComponentState currentSelection = module.getSelected();
        try {
            module.maybeUpdateSelection();
        }
        catch (ModuleVersionResolveException e) {
            return;
        }
        if (currentSelection == null) {
            DependencyGraphBuilder.checkForModuleConflicts(resolveState, module);
        }
    }

    private static void checkForModuleConflicts(ResolveState resolveState, ModuleResolveState module) {
        PotentialConflict c = resolveState.getModuleConflictHandler().registerCandidate(module);
        if (c.conflictExists()) {
            LOGGER.debug("Found new conflicting module {}", (Object)module);
            c.withParticipatingModules(resolveState.getDeselectVersionAction());
        }
    }

    private static void maybeDownloadMetadataInParallel(NodeState node, List<EdgeState> edges, Spec<EdgeState> edgeFilter, BuildOperationExecutor buildOperationExecutor, ComponentMetaDataResolver componentMetaDataResolver) {
        ArrayList<ComponentState> requiringDownload = null;
        for (EdgeState edge : edges) {
            ComponentState targetComponent;
            if (!edgeFilter.isSatisfiedBy((Object)edge) || (targetComponent = edge.getTargetComponent()) == null || !targetComponent.isSelected() || targetComponent.alreadyResolved() || componentMetaDataResolver.isFetchingMetadataCheap(targetComponent.getComponentId())) continue;
            if (requiringDownload == null) {
                requiringDownload = new ArrayList<ComponentState>();
            }
            requiringDownload.add(targetComponent);
        }
        if (requiringDownload != null && requiringDownload.size() > 1) {
            ImmutableList toDownloadInParallel = ImmutableList.copyOf((Collection)requiringDownload);
            LOGGER.debug("Submitting {} metadata files to resolve in parallel for {}", (Object)toDownloadInParallel.size(), (Object)node);
            buildOperationExecutor.runAll(buildOperationQueue -> {
                for (ComponentState componentState : toDownloadInParallel) {
                    buildOperationQueue.add((BuildOperation)new DownloadMetadataOperation(componentState));
                }
            }, BuildOperationConstraint.UNCONSTRAINED);
        }
    }

    private static void attachToTargetRevisionsSerially(List<EdgeState> edges, Spec<EdgeState> edgeFilter) {
        for (EdgeState edge : edges) {
            if (!edgeFilter.isSatisfiedBy((Object)edge)) continue;
            edge.attachToTargetNodes();
        }
    }

    private static void validateGraph(ResolveState resolveState, boolean denyDynamicSelectors, boolean denyChangingModules) {
        ImmutableAttributesSchema consumerSchema = resolveState.getConsumerSchema();
        for (ModuleResolveState module : resolveState.getModules()) {
            ComponentState selected = module.getSelected();
            if (selected != null) {
                ResolutionFailureHandler resolutionFailureHandler = resolveState.getVariantSelector().getFailureHandler();
                if (selected.isRejected()) {
                    GradleException error = new GradleException(selected.getRejectedErrorMessage());
                    DependencyGraphBuilder.attachFailureToEdges(error, module.getIncomingEdges());
                    DependencyGraphBuilder.attachFailureToEdges(error, module.getUnattachedEdges());
                    continue;
                }
                if (module.isVirtualPlatform()) {
                    DependencyGraphBuilder.attachMultipleForceOnPlatformFailureToEdges(module);
                } else if (selected.hasMoreThanOneSelectedNodeUsingVariantAwareResolution()) {
                    DependencyGraphBuilder.validateMultipleNodeSelection(consumerSchema, module, selected, resolutionFailureHandler, resolveState.getAttributeSchemaServices());
                }
                if (denyDynamicSelectors) {
                    DependencyGraphBuilder.validateDynamicSelectors(selected);
                }
                if (!denyChangingModules) continue;
                DependencyGraphBuilder.validateChangingVersions(selected);
                continue;
            }
            if (!module.isVirtualPlatform()) continue;
            DependencyGraphBuilder.attachMultipleForceOnPlatformFailureToEdges(module);
        }
        if (resolveState.getRoot().wasIncomingEdgeAdded()) {
            String rootNodeName = resolveState.getRoot().getMetadata().getName();
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecate((String)String.format("While resolving configuration '%s', it was also selected as a variant. Configurations should not act as both a resolution root and a variant simultaneously. Depending on the resolved configuration in this manner", rootNodeName)).withProblemIdDisplayName("Configurations should not act as both a resolution root and a variant simultaneously.").withProblemId("configurations-acting-as-both-root-and-variant").withAdvice("Be sure to mark configurations meant for resolution as canBeConsumed=false or use the 'resolvable(String)' configuration factory method to create them.").willBecomeAnErrorInGradle9().withUpgradeGuideSection(8, "depending_on_root_configuration")).nagUser();
        }
    }

    private static boolean isDynamic(SelectorState selector) {
        ResolvedVersionConstraint versionConstraint = selector.getVersionConstraint();
        if (versionConstraint != null) {
            return versionConstraint.isDynamic();
        }
        return false;
    }

    private static void validateDynamicSelectors(ComponentState selected) {
        ImmutableList selectors = ImmutableList.copyOf(selected.getModule().getSelectors());
        if (!selectors.isEmpty()) {
            if (selectors.stream().allMatch(DependencyGraphBuilder::isDynamic)) {
                DependencyGraphBuilder.markDeniedDynamicVersions(selected);
            } else if (selectors.stream().anyMatch(DependencyGraphBuilder::isDynamic)) {
                DependencyGraphBuilder.checkIfDynamicVersionAllowed(selected, (List<SelectorState>)selectors);
            }
        }
    }

    private static void checkIfDynamicVersionAllowed(ComponentState selected, List<SelectorState> selectors) {
        String version = selected.getId().getVersion();
        boolean accept = false;
        for (SelectorState selector : selectors) {
            ResolvedVersionConstraint versionConstraint = selector.getVersionConstraint();
            if (!versionConstraint.isDynamic()) {
                if (!versionConstraint.accepts(version)) continue;
                accept = true;
                continue;
            }
            if (versionConstraint.canBeStable()) continue;
            accept = false;
            break;
        }
        if (!accept) {
            DependencyGraphBuilder.markDeniedDynamicVersions(selected);
        }
    }

    private static void markDeniedDynamicVersions(ComponentState cs) {
        for (NodeState node : cs.getNodes()) {
            Collection incomingEdges = node.getIncomingEdges();
            for (EdgeState incomingEdge : incomingEdges) {
                ComponentSelector selector = incomingEdge.getSelector().getSelector();
                incomingEdge.failWith((Throwable)((Object)new ModuleVersionResolveException(selector, (Factory<String>)((Factory)() -> String.format("Could not resolve %s: Resolution strategy disallows usage of dynamic versions", selector)))));
            }
        }
    }

    private static void validateChangingVersions(ComponentState selected) {
        ComponentGraphResolveMetadata metadata = selected.getMetadataOrNull();
        boolean moduleIsChanging = metadata != null && metadata.isChanging();
        for (NodeState node : selected.getNodes()) {
            Collection incomingEdges = node.getIncomingEdges();
            for (EdgeState incomingEdge : incomingEdges) {
                if (!moduleIsChanging && !incomingEdge.getDependencyMetadata().isChanging()) continue;
                ComponentSelector selector = incomingEdge.getSelector().getSelector();
                incomingEdge.failWith((Throwable)((Object)new ModuleVersionResolveException(selector, (Factory<String>)((Factory)() -> String.format("Could not resolve %s: Resolution strategy disallows usage of changing versions", selector)))));
            }
        }
    }

    private static void validateMultipleNodeSelection(ImmutableAttributesSchema consumerSchema, ModuleResolveState module, ComponentState selected, ResolutionFailureHandler resolutionFailureHandler, AttributeSchemaServices attributeSchemaServices) {
        Set selectedNodes = selected.getNodes().stream().filter(n -> n.isSelected() && !n.isAttachedToVirtualPlatform() && !n.hasShadowedCapability()).collect(Collectors.toSet());
        if (selectedNodes.size() < 2) {
            return;
        }
        Set combinations = Sets.combinations(selectedNodes, (int)2);
        HashSet<NodeState> incompatibleNodes = new HashSet<NodeState>();
        AttributeMatcher matcher = attributeSchemaServices.getMatcher(consumerSchema, selected.getMetadata().getAttributesSchema());
        for (Set combination : combinations) {
            Iterator it = combination.iterator();
            NodeState first = (NodeState)it.next();
            NodeState second = (NodeState)it.next();
            if (matcher.areMutuallyCompatible(first.getMetadata().getAttributes(), second.getMetadata().getAttributes())) continue;
            incompatibleNodes.add(first);
            incompatibleNodes.add(second);
        }
        if (!incompatibleNodes.isEmpty()) {
            Set<VariantGraphResolveMetadata> incompatibleNodeMetadatas = incompatibleNodes.stream().map(NodeState::getMetadata).collect(Collectors.toSet());
            AbstractResolutionFailureException variantsSelectionException = resolutionFailureHandler.incompatibleMultipleNodesValidationFailure(matcher, selected.getMetadata(), incompatibleNodeMetadatas);
            for (EdgeState edge : module.getIncomingEdges()) {
                edge.failWith((Throwable)((Object)variantsSelectionException));
            }
        }
    }

    private static void attachMultipleForceOnPlatformFailureToEdges(ModuleResolveState module) {
        ArrayList<EdgeState> forcedEdges = null;
        boolean hasMultipleVersions = false;
        String currentVersion = module.maybeFindForcedPlatformVersion();
        Set<ModuleResolveState> participatingModules = module.getPlatformState().getParticipatingModules();
        for (ModuleResolveState participatingModule : participatingModules) {
            for (EdgeState incomingEdge : participatingModule.getIncomingEdges()) {
                ComponentSelector componentSelector;
                SelectorState selector = incomingEdge.getSelector();
                if (!DependencyGraphBuilder.isPlatformForcedEdge(selector) || !((componentSelector = selector.getSelector()) instanceof ModuleComponentSelector)) continue;
                ModuleComponentSelector mcs = (ModuleComponentSelector)componentSelector;
                if (incomingEdge.getFrom().getComponent().getModule().equals(module)) continue;
                if (forcedEdges == null) {
                    forcedEdges = new ArrayList<EdgeState>();
                }
                forcedEdges.add(incomingEdge);
                if (currentVersion == null) {
                    currentVersion = mcs.getVersion();
                    continue;
                }
                if (currentVersion.equals(mcs.getVersion())) continue;
                hasMultipleVersions = true;
            }
        }
        if (hasMultipleVersions) {
            DependencyGraphBuilder.attachFailureToEdges(new GradleException("Multiple forces on different versions for virtual platform " + module.getId()), forcedEdges);
        }
    }

    private static boolean isPlatformForcedEdge(SelectorState selector) {
        return selector.isForce() && !selector.isSoftForce();
    }

    private static void attachFailureToEdges(GradleException error, Collection<EdgeState> incomingEdges) {
        for (EdgeState edge : incomingEdges) {
            edge.failWith((Throwable)error);
        }
    }

    private static void assembleResult(ResolveState resolveState, DependencyGraphVisitor visitor) {
        visitor.start(resolveState.getRoot());
        for (DependencyGraphSelector dependencyGraphSelector : resolveState.getSelectors()) {
            visitor.visitSelector(dependencyGraphSelector);
        }
        for (NodeState nodeState : resolveState.getNodes()) {
            if (!nodeState.shouldIncludedInGraphResult()) continue;
            visitor.visitNode(nodeState);
        }
        LinkedList<ComponentState> queue = new LinkedList<ComponentState>();
        for (ModuleResolveState module : resolveState.getModules()) {
            if (module.getSelected() == null || module.isVirtualPlatform()) continue;
            queue.add(module.getSelected());
        }
        while (!queue.isEmpty()) {
            ComponentState componentState = (ComponentState)queue.peekFirst();
            if (componentState.getVisitState() == VisitState.NotSeen) {
                componentState.setVisitState(VisitState.Visiting);
                int pos = 0;
                for (NodeState node : componentState.getNodes()) {
                    if (!node.isSelected()) continue;
                    for (EdgeState edge : node.getIncomingEdges()) {
                        ComponentState owner = edge.getFrom().getOwner();
                        if (owner.getVisitState() != VisitState.NotSeen || owner.getModule().isVirtualPlatform()) continue;
                        queue.add(pos, owner);
                        ++pos;
                    }
                }
                if (pos != 0) continue;
                componentState.setVisitState(VisitState.Visited);
                queue.removeFirst();
                for (NodeState node : componentState.getNodes()) {
                    if (!node.isSelected()) continue;
                    visitor.visitEdges(node);
                }
                continue;
            }
            if (componentState.getVisitState() == VisitState.Visiting) {
                componentState.setVisitState(VisitState.Visited);
                queue.removeFirst();
                for (NodeState node : componentState.getNodes()) {
                    if (!node.isSelected()) continue;
                    visitor.visitEdges(node);
                }
                continue;
            }
            queue.removeFirst();
        }
        visitor.finish(resolveState.getRoot());
    }

    static enum VisitState {
        NotSeen,
        Visiting,
        Visited;

    }
}

