/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli.converter;

import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.launcher.cli.WelcomeMessageConfiguration;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.cli.ProjectPropertiesCommandLineConverter;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.initialization.ParallelismBuildOptions;
import org.gradle.initialization.StartParameterBuildOptions;
import org.gradle.internal.logging.LoggingConfigurationBuildOptions;
import org.gradle.launcher.cli.converter.BuildOptionBackedConverter;
import org.gradle.launcher.cli.converter.WelcomeMessageBuildOptions;
import org.gradle.launcher.configuration.AllProperties;
import org.gradle.launcher.configuration.BuildLayoutResult;

public class StartParameterConverter {
    private final BuildOptionBackedConverter<WelcomeMessageConfiguration> welcomeMessageConfigurationCommandLineConverter = new BuildOptionBackedConverter<WelcomeMessageConfiguration>(new WelcomeMessageBuildOptions());
    private final BuildOptionBackedConverter<LoggingConfiguration> loggingConfigurationCommandLineConverter = new BuildOptionBackedConverter(new LoggingConfigurationBuildOptions());
    private final BuildOptionBackedConverter<ParallelismConfiguration> parallelConfigurationCommandLineConverter = new BuildOptionBackedConverter(new ParallelismBuildOptions());
    private final ProjectPropertiesCommandLineConverter projectPropertiesCommandLineConverter = new ProjectPropertiesCommandLineConverter();
    private final BuildOptionBackedConverter<StartParameterInternal> buildOptionsConverter = new BuildOptionBackedConverter(new StartParameterBuildOptions());

    public void configure(CommandLineParser parser) {
        this.welcomeMessageConfigurationCommandLineConverter.configure(parser);
        this.loggingConfigurationCommandLineConverter.configure(parser);
        this.parallelConfigurationCommandLineConverter.configure(parser);
        this.projectPropertiesCommandLineConverter.configure(parser);
        parser.allowMixedSubcommandsAndOptions();
        this.buildOptionsConverter.configure(parser);
    }

    public StartParameterInternal convert(ParsedCommandLine parsedCommandLine, BuildLayoutResult buildLayout, AllProperties properties, StartParameterInternal startParameter) throws CommandLineArgumentException {
        buildLayout.applyTo(startParameter);
        this.welcomeMessageConfigurationCommandLineConverter.convert(parsedCommandLine, properties.getProperties(), startParameter.getWelcomeMessageConfiguration());
        this.loggingConfigurationCommandLineConverter.convert(parsedCommandLine, properties.getProperties(), (LoggingConfiguration)startParameter);
        this.parallelConfigurationCommandLineConverter.convert(parsedCommandLine, properties.getProperties(), (ParallelismConfiguration)startParameter);
        startParameter.getSystemPropertiesArgs().putAll(properties.getRequestedSystemProperties());
        this.projectPropertiesCommandLineConverter.convert(parsedCommandLine, startParameter.getProjectProperties());
        if (!parsedCommandLine.getExtraArguments().isEmpty()) {
            startParameter.setTaskNames((Iterable)parsedCommandLine.getExtraArguments());
        }
        this.buildOptionsConverter.convert(parsedCommandLine, properties.getProperties(), startParameter);
        return startParameter;
    }
}

