/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.collect.ImmutableSortedSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.BaseSnapshotInputsBuildOperationResult;
import org.gradle.api.internal.tasks.properties.InputFilePropertySpec;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotVisitResult;
import org.gradle.operations.execution.FilePropertyVisitor;

@NonNullApi
public abstract class BaseFilePropertyVisitState
implements FilePropertyVisitor.VisitState,
FileSystemSnapshotHierarchyVisitor {
    private final Map<String, InputFilePropertySpec> propertySpecsByName;
    private final Deque<DirectorySnapshot> unvisitedDirectories = new ArrayDeque<DirectorySnapshot>();
    Map<String, FileSystemLocationFingerprint> fingerprints;
    String propertyName;
    HashCode propertyHash;
    String name;
    String path;
    HashCode hash;
    int depth;

    protected BaseFilePropertyVisitState(Map<String, InputFilePropertySpec> propertySpecsByName) {
        this.propertySpecsByName = propertySpecsByName;
    }

    protected abstract void preRoot();

    protected abstract void postRoot();

    protected abstract void preDirectory();

    protected abstract void preUnvisitedDirectory(DirectorySnapshot var1);

    protected abstract void postDirectory();

    protected abstract void file();

    public String getPropertyName() {
        return this.propertyName;
    }

    public byte[] getPropertyHashBytes() {
        return this.propertyHash.toByteArray();
    }

    public Set<String> getPropertyAttributes() {
        InputFilePropertySpec propertySpec = this.propertySpec(this.propertyName);
        return ImmutableSortedSet.of((Comparable)((Object)BaseSnapshotInputsBuildOperationResult.FilePropertyAttribute.fromNormalizer(propertySpec.getNormalizer()).name()), (Comparable)((Object)BaseSnapshotInputsBuildOperationResult.FilePropertyAttribute.from(propertySpec.getDirectorySensitivity()).name()), (Comparable)((Object)BaseSnapshotInputsBuildOperationResult.FilePropertyAttribute.from(propertySpec.getLineEndingNormalization()).name()));
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public byte[] getHashBytes() {
        return this.hash.toByteArray();
    }

    public void enterDirectory(DirectorySnapshot physicalSnapshot) {
        FileSystemLocationFingerprint fingerprint;
        this.path = physicalSnapshot.getAbsolutePath();
        this.name = physicalSnapshot.getName();
        this.hash = null;
        if (this.depth++ == 0) {
            this.preRoot();
        }
        if ((fingerprint = this.fingerprints.get(this.path)) == null) {
            this.unvisitedDirectories.add(physicalSnapshot);
        } else {
            this.visitUnvisitedDirectories();
            this.preDirectory();
        }
    }

    public SnapshotVisitResult visitEntry(FileSystemLocationSnapshot snapshot) {
        boolean isRoot;
        if (snapshot.getType() == FileType.Directory) {
            return SnapshotVisitResult.CONTINUE;
        }
        FileSystemLocationFingerprint fingerprint = this.fingerprints.get(snapshot.getAbsolutePath());
        if (fingerprint == null) {
            return SnapshotVisitResult.CONTINUE;
        }
        this.visitUnvisitedDirectories();
        this.path = snapshot.getAbsolutePath();
        this.name = snapshot.getName();
        this.hash = fingerprint.getNormalizedContentHash();
        boolean bl = isRoot = this.depth == 0;
        if (isRoot) {
            this.preRoot();
        }
        this.file();
        if (isRoot) {
            this.postRoot();
        }
        return SnapshotVisitResult.CONTINUE;
    }

    public void leaveDirectory(DirectorySnapshot directorySnapshot) {
        DirectorySnapshot lastUnvisitedDirectory = this.unvisitedDirectories.pollLast();
        if (lastUnvisitedDirectory == null) {
            this.postDirectory();
        }
        if (--this.depth == 0) {
            this.postRoot();
        }
    }

    private void visitUnvisitedDirectories() {
        DirectorySnapshot unvisited;
        while ((unvisited = this.unvisitedDirectories.poll()) != null) {
            this.preUnvisitedDirectory(unvisited);
        }
    }

    protected InputFilePropertySpec propertySpec(String propertyName) {
        InputFilePropertySpec propertySpec = this.propertySpecsByName.get(propertyName);
        if (propertySpec == null) {
            throw new IllegalStateException("Unknown input property '" + propertyName + "' (known: " + this.propertySpecsByName.keySet() + ")");
        }
        return propertySpec;
    }

    protected static class DirectoryVisitState<T extends FilePropertyVisitor.VisitState>
    implements FilePropertyVisitor.VisitState {
        protected final T delegate;
        private final DirectorySnapshot directorySnapshot;

        public DirectoryVisitState(DirectorySnapshot unvisited, T delegate) {
            this.directorySnapshot = unvisited;
            this.delegate = delegate;
        }

        public String getPath() {
            return this.directorySnapshot.getAbsolutePath();
        }

        public String getName() {
            return this.directorySnapshot.getName();
        }

        public byte[] getHashBytes() {
            throw new UnsupportedOperationException("Cannot query hash for directories");
        }

        public String getPropertyName() {
            return this.delegate.getPropertyName();
        }

        public byte[] getPropertyHashBytes() {
            return this.delegate.getPropertyHashBytes();
        }

        public Set<String> getPropertyAttributes() {
            return this.delegate.getPropertyAttributes();
        }
    }
}

