/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.NonExtensible;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.artifacts.transform.VariantTransformConfigurationException;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.TransformRegistration;
import org.gradle.api.internal.artifacts.VariantTransformRegistry;
import org.gradle.api.internal.artifacts.transform.TransformRegistrationFactory;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.isolated.IsolationScheme;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;

public class DefaultVariantTransformRegistry
implements VariantTransformRegistry {
    private final List<TransformRegistration> registrations = new ArrayList<TransformRegistration>();
    private final ImmutableAttributesFactory immutableAttributesFactory;
    private final ServiceRegistry services;
    private final InstantiatorFactory instantiatorFactory;
    private final InstantiationScheme parametersInstantiationScheme;
    private final TransformRegistrationFactory registrationFactory;
    private final IsolationScheme<TransformAction<?>, TransformParameters> isolationScheme = new IsolationScheme(TransformAction.class, TransformParameters.class, TransformParameters.None.class);

    public DefaultVariantTransformRegistry(InstantiatorFactory instantiatorFactory, ImmutableAttributesFactory immutableAttributesFactory, ServiceRegistry services, TransformRegistrationFactory registrationFactory, InstantiationScheme parametersInstantiationScheme) {
        this.instantiatorFactory = instantiatorFactory;
        this.immutableAttributesFactory = immutableAttributesFactory;
        this.services = services;
        this.registrationFactory = registrationFactory;
        this.parametersInstantiationScheme = parametersInstantiationScheme;
    }

    @Override
    public <T extends TransformParameters> void registerTransform(Class<? extends TransformAction<T>> actionType, Action<? super TransformSpec<T>> registrationAction) {
        TypedRegistration registration = null;
        try {
            Class parameterType = this.isolationScheme.parameterTypeFor(actionType);
            TransformParameters parameterObject = parameterType == null ? null : (TransformParameters)this.parametersInstantiationScheme.withServices((ServiceLookup)this.services).instantiator().newInstance(parameterType, new Object[0]);
            registration = (TypedRegistration)Cast.uncheckedNonnullCast((Object)this.instantiatorFactory.decorateLenient().newInstance(TypedRegistration.class, new Object[]{parameterObject, this.immutableAttributesFactory}));
            registrationAction.execute((Object)registration);
            this.register(registration, actionType, parameterObject);
        }
        catch (VariantTransformConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Could not register artifact transform ");
            formatter.appendType(actionType);
            if (!(registration == null || registration.from.isEmpty() && registration.to.isEmpty())) {
                formatter.append((CharSequence)" (");
                if (!registration.from.isEmpty()) {
                    formatter.append((CharSequence)"from ");
                    formatter.appendValue((Object)registration.from);
                }
                if (!registration.to.isEmpty()) {
                    if (!registration.from.isEmpty()) {
                        formatter.append((CharSequence)" ");
                    }
                    formatter.append((CharSequence)"to ");
                    formatter.appendValue((Object)registration.to);
                }
                formatter.append((CharSequence)")");
            }
            formatter.append((CharSequence)".");
            throw new VariantTransformConfigurationException(formatter.toString(), (Throwable)e);
        }
    }

    private <T extends TransformParameters> void register(RecordingRegistration registration, Class<? extends TransformAction<?>> actionType, @Nullable T parameterObject) {
        DefaultVariantTransformRegistry.validateActionType(actionType);
        try {
            DefaultVariantTransformRegistry.validateAttributes(registration);
            TransformRegistration finalizedRegistration = this.registrationFactory.create(registration.from.asImmutable(), registration.to.asImmutable(), actionType, parameterObject);
            this.registrations.add(finalizedRegistration);
        }
        catch (Exception e) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Could not register artifact transform ");
            formatter.appendType(actionType);
            formatter.append((CharSequence)" (from ");
            formatter.appendValue((Object)registration.from);
            formatter.append((CharSequence)" to ");
            formatter.appendValue((Object)registration.to);
            formatter.append((CharSequence)").");
            throw new VariantTransformConfigurationException(formatter.toString(), (Throwable)e);
        }
    }

    private static <T> void validateActionType(@Nullable Class<T> actionType) {
        if (actionType == null) {
            throw new IllegalArgumentException("An artifact transform action type must be provided.");
        }
    }

    private static void validateAttributes(RecordingRegistration registration) {
        if (registration.to.isEmpty()) {
            throw new IllegalArgumentException("At least one 'to' attribute must be provided.");
        }
        if (registration.from.isEmpty()) {
            throw new IllegalArgumentException("At least one 'from' attribute must be provided.");
        }
        if (!registration.from.keySet().containsAll(registration.to.keySet())) {
            throw new IllegalArgumentException("Each 'to' attribute must be included as a 'from' attribute.");
        }
    }

    @Override
    public List<TransformRegistration> getRegistrations() {
        return this.registrations;
    }

    @NonExtensible
    public static class TypedRegistration<T extends TransformParameters>
    extends RecordingRegistration
    implements TransformSpec<T> {
        private final T parameterObject;

        public TypedRegistration(@Nullable T parameterObject, ImmutableAttributesFactory immutableAttributesFactory) {
            super(immutableAttributesFactory);
            this.parameterObject = parameterObject;
        }

        public T getParameters() {
            if (this.parameterObject == null) {
                throw new IllegalStateException("Cannot query parameters for artifact transform without parameters.");
            }
            return this.parameterObject;
        }

        public void parameters(Action<? super T> action) {
            if (this.parameterObject == null) {
                throw new IllegalStateException("Cannot configure parameters for artifact transform without parameters.");
            }
            action.execute(this.parameterObject);
        }
    }

    public static abstract class RecordingRegistration {
        final AttributeContainerInternal from;
        final AttributeContainerInternal to;

        public RecordingRegistration(ImmutableAttributesFactory immutableAttributesFactory) {
            this.from = immutableAttributesFactory.mutable();
            this.to = immutableAttributesFactory.mutable();
        }

        public AttributeContainer getFrom() {
            return this.from;
        }

        public AttributeContainer getTo() {
            return this.to;
        }
    }
}

