/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.capability;

import org.gradle.api.internal.artifacts.capability.CapabilitySelectorInternal;
import org.gradle.api.internal.artifacts.capability.FeatureCapabilitySelector;
import org.gradle.api.internal.capabilities.ImmutableCapability;

public final class DefaultFeatureCapabilitySelector
implements CapabilitySelectorInternal,
FeatureCapabilitySelector {
    private final String featureName;

    public DefaultFeatureCapabilitySelector(String featureName) {
        this.featureName = featureName;
    }

    @Override
    public String getFeatureName() {
        return this.featureName;
    }

    @Override
    public boolean matches(String capabilityGroup, String capabilityName, ImmutableCapability implicitCapability) {
        return capabilityGroup.equals(implicitCapability.getGroup()) && capabilityName.equals(implicitCapability.getName() + "-" + this.featureName);
    }

    public String getDisplayName() {
        return "capability selector for feature '" + this.featureName + "'";
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultFeatureCapabilitySelector that = (DefaultFeatureCapabilitySelector)o;
        return this.featureName.equals(that.featureName);
    }

    public int hashCode() {
        return this.featureName.hashCode();
    }
}

