; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --force-dwarf-frame-section %s -o - | FileCheck %s
; RUN: llc --filetype=obj %s -o - | llvm-readelf -s --unwind - | FileCheck %s --check-prefix=UNWIND
target datalayout = "e-m:e-p:32:32-Fi8-i64:64-v128:64:128-a:0:32-n32-S64"
target triple = "thumbv8m.main-none-none-eabi"

; int g(int);
;
; #if __ARM_FEATURE_CMSE == 3
; #define ENTRY __attribute__((cmse_nonsecure_entry))
; #else
; #define ENTRY
; #endif
;
; ENTRY int f(int x) {
;     return 1 + g(x - 1);
; }

define hidden i32 @f0(i32 %x) local_unnamed_addr "sign-return-address"="non-leaf" {
; CHECK-LABEL: f0:
; CHECK:         .cfi_sections .debug_frame
; CHECK-NEXT:    .cfi_startproc
; CHECK-NEXT:  @ %bb.0: @ %entry
; CHECK-NEXT:    pac r12, lr, sp
; CHECK-NEXT:    .save {r7, ra_auth_code, lr}
; CHECK-NEXT:    push.w {r7, r12, lr}
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    .cfi_offset lr, -4
; CHECK-NEXT:    .cfi_offset ra_auth_code, -8
; CHECK-NEXT:    .cfi_offset r7, -12
; CHECK-NEXT:    .pad #4
; CHECK-NEXT:    sub sp, #4
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    subs r0, #1
; CHECK-NEXT:    bl g
; CHECK-NEXT:    adds r0, #1
; CHECK-NEXT:    add sp, #4
; CHECK-NEXT:    pop.w {r7, r12, lr}
; CHECK-NEXT:    aut r12, lr, sp
; CHECK-NEXT:    bx lr
entry:
  %sub = add nsw i32 %x, -1
  %call = tail call i32 @g(i32 %sub)
  %add = add nsw i32 %call, 1
  ret i32 %add
}

define hidden i32 @f1(i32 %x) local_unnamed_addr #0 {
; CHECK-LABEL: f1:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  @ %bb.0: @ %entry
; CHECK-NEXT:    pac r12, lr, sp
; CHECK-NEXT:    vstr fpcxtns, [sp, #-4]!
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    .save {r7, ra_auth_code, lr}
; CHECK-NEXT:    push.w {r7, r12, lr}
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset lr, -8
; CHECK-NEXT:    .cfi_offset ra_auth_code, -12
; CHECK-NEXT:    .cfi_offset r7, -16
; CHECK-NEXT:    subs r0, #1
; CHECK-NEXT:    bl g
; CHECK-NEXT:    adds r0, #1
; CHECK-NEXT:    pop.w {r7, r12, lr}
; CHECK-NEXT:    vscclrm {s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, vpr}
; CHECK-NEXT:    vldr fpcxtns, [sp], #4
; CHECK-NEXT:    aut r12, lr, sp
; CHECK-NEXT:    clrm {r1, r2, r3, r12, apsr}
; CHECK-NEXT:    bxns lr
entry:
  %sub = add nsw i32 %x, -1
  %call = tail call i32 @g(i32 %sub)
  %add = add nsw i32 %call, 1
  ret i32 %add
}

define hidden i32 @f2(i32 %x) local_unnamed_addr #1 {
; CHECK-LABEL: f2:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  @ %bb.0: @ %entry
; CHECK-NEXT:    pac r12, lr, sp
; CHECK-NEXT:    .save {r7, ra_auth_code, lr}
; CHECK-NEXT:    push.w {r7, r12, lr}
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    .cfi_offset lr, -4
; CHECK-NEXT:    .cfi_offset ra_auth_code, -8
; CHECK-NEXT:    .cfi_offset r7, -12
; CHECK-NEXT:    .pad #4
; CHECK-NEXT:    sub sp, #4
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    subs r0, #1
; CHECK-NEXT:    bl g
; CHECK-NEXT:    adds r0, #1
; CHECK-NEXT:    add sp, #4
; CHECK-NEXT:    pop.w {r7, r12, lr}
; CHECK-NEXT:    aut r12, lr, sp
; CHECK-NEXT:    mrs r12, control
; CHECK-NEXT:    tst.w r12, #8
; CHECK-NEXT:    beq .LBB2_2
; CHECK-NEXT:  @ %bb.1: @ %entry
; CHECK-NEXT:    vmrs r12, fpscr
; CHECK-NEXT:    vmov d0, lr, lr
; CHECK-NEXT:    vmov d1, lr, lr
; CHECK-NEXT:    vmov d2, lr, lr
; CHECK-NEXT:    vmov d3, lr, lr
; CHECK-NEXT:    vmov d4, lr, lr
; CHECK-NEXT:    vmov d5, lr, lr
; CHECK-NEXT:    vmov d6, lr, lr
; CHECK-NEXT:    vmov d7, lr, lr
; CHECK-NEXT:    bic r12, r12, #159
; CHECK-NEXT:    bic r12, r12, #4026531840
; CHECK-NEXT:    vmsr fpscr, r12
; CHECK-NEXT:  .LBB2_2: @ %entry
; CHECK-NEXT:    mov r1, lr
; CHECK-NEXT:    mov r2, lr
; CHECK-NEXT:    mov r3, lr
; CHECK-NEXT:    mov r12, lr
; CHECK-NEXT:    msr apsr_nzcvq, lr
; CHECK-NEXT:    bxns lr
entry:
  %sub = add nsw i32 %x, -1
  %call = tail call i32 @g(i32 %sub)
  %add = add nsw i32 %call, 1
  ret i32 %add
}

declare dso_local i32 @g(i32) local_unnamed_addr

attributes #0 = { "sign-return-address"="non-leaf" "cmse_nonsecure_entry" "target-features"="+8msecext,+armv8.1-m.main"}
attributes #1 = { "sign-return-address"="non-leaf" "cmse_nonsecure_entry" "target-features"="+8msecext,+armv8-m.main,+fp-armv8d16"}

!llvm.module.flags = !{!0, !1, !2}

!0 = !{i32 8, !"branch-target-enforcement", i32 0}
!1 = !{i32 8, !"sign-return-address", i32 1}
!2 = !{i32 8, !"sign-return-address-all", i32 0}

; UNWIND-LABEL: FunctionAddress: 0x0
; UNWIND:       0x00      ; vsp = vsp + 4
; UNWIND-NEXT:  0x80 0x08 ; pop {r7}
; UNWIND-NEXT:  0xB4      ; pop ra_auth_code
; UNWIND-NEXT:  0x84 0x00 ; pop {lr}


; UNWIND-LABEL: FunctionAddress: 0x1E
; UNWIND:       0x80 0x08 ; pop {r7}
; UNWIND-NEXT:  0xB4      ; pop ra_auth_code
; UNWIND-NEXT:  0x84 0x00 ; pop {lr}

; UNWIND-LABEL: FunctionAddress: 0x48
; UNWIND:       0x00      ; vsp = vsp + 4
; UNWIND-NEXT:  0x80 0x08 ; pop {r7}
; UNWIND-NEXT:  0xB4      ; pop ra_auth_code
; UNWIND-NEXT:  0x84 0x00 ; pop {lr}

; UNWIND-LABEL: 00000001 {{.*}} f0
; UNWIND-LABEL: 0000001f {{.*}} f1
; UNWIND-LABEL: 00000049 {{.*}} f2
